/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Any;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.grpc.protobuf.StatusProto;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ExtractStatus {
    public static Optional<CheckedApiException> extract(Throwable t) {
        try {
            throw t;
        }
        catch (ApiException e) {
            return Optional.of(new CheckedApiException(e));
        }
        catch (CheckedApiException e) {
            return Optional.of(e);
        }
        catch (ExecutionException e) {
            return ExtractStatus.extract(e.getCause());
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static CheckedApiException toCanonical(Throwable t) {
        Optional<CheckedApiException> statusOr = ExtractStatus.extract(t);
        if (statusOr.isPresent()) {
            return statusOr.get();
        }
        return new CheckedApiException(t, StatusCode.Code.INTERNAL);
    }

    public static String getErrorInfoReason(CheckedApiException error) {
        Status status = StatusProto.fromThrowable((Throwable)error.underlying);
        if (status == null) {
            return "";
        }
        for (Any any : status.getDetailsList()) {
            if (!any.is(ErrorInfo.class)) continue;
            try {
                ErrorInfo errorInfo = (ErrorInfo)any.unpack(ErrorInfo.class);
                if (!"pubsublite.googleapis.com".equals(errorInfo.getDomain())) continue;
                return errorInfo.getReason();
            }
            catch (Throwable throwable) {
            }
        }
        return "";
    }

    public static <T> ApiFuture<T> toClientFuture(ApiFuture<T> source) {
        return ApiFutures.catchingAsync(source, Throwable.class, t -> ApiFutures.immediateFailedFuture((Throwable)ExtractStatus.toCanonical((Throwable)t).underlying), (Executor)MoreExecutors.directExecutor());
    }

    public static void addFailureHandler(ApiFuture<?> future, Consumer<CheckedApiException> consumer) {
        future.addListener(() -> {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                consumer.accept(ExtractStatus.toCanonical(e));
            }
        }, SystemExecutors.getFuturesExecutor());
    }

    public static <I, O> Function<I, O> rethrowAsRuntime(StatusFunction<I, O> function) {
        return i -> {
            try {
                return function.apply(i);
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        };
    }

    public static <I> Consumer<I> rethrowAsRuntime(StatusConsumer<I> consumer) {
        return i -> {
            try {
                consumer.apply(i);
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        };
    }

    public static <K, V> BiConsumer<K, V> rethrowAsRuntime(StatusBiconsumer<K, V> consumer) {
        return (k, v) -> {
            try {
                consumer.apply(k, v);
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        };
    }

    private ExtractStatus() {
    }

    public static interface StatusFunction<I, O> {
        public O apply(I var1) throws CheckedApiException;
    }

    public static interface StatusConsumer<I> {
        public void apply(I var1) throws CheckedApiException;
    }

    public static interface StatusBiconsumer<K, V> {
        public void apply(K var1, V var2) throws CheckedApiException;
    }
}

