/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultRoutingPolicy
implements RoutingPolicy {
    private final long numPartitions;
    private final AtomicLong withoutKeyCounter;

    public DefaultRoutingPolicy(long numPartitions) throws ApiException {
        UncheckedApiPreconditions.checkArgument(numPartitions > 0L, "Must have a positive number of partitions.");
        this.numPartitions = numPartitions;
        this.withoutKeyCounter = new AtomicLong(ThreadLocalRandom.current().nextLong(numPartitions));
    }

    @Override
    public Partition routeWithoutKey() throws ApiException {
        long index = this.withoutKeyCounter.incrementAndGet();
        return Partition.of(index % this.numPartitions);
    }

    @Override
    public Partition route(ByteString messageKey) throws ApiException {
        HashCode code = Hashing.sha256().hashBytes(messageKey.asReadOnlyByteBuffer());
        UncheckedApiPreconditions.checkArgument(code.bits() == 256);
        BigInteger bigEndianValue = new BigInteger(1, code.asBytes());
        return Partition.of(bigEndianValue.mod(BigInteger.valueOf(this.numPartitions)).longValueExact());
    }
}

