/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Endpoints;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.concurrent.ScheduledExecutorService;
import org.threeten.bp.Duration;

public final class ServiceClients {
    private static final int CLIENT_POOL_SIZE = Integer.parseInt(System.getProperty("PUBSUB_LITE_CHANNELS_PER_CLIENT", "10"));

    private ServiceClients() {
    }

    private static TransportChannelProvider getTransportChannelProvider() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE)).setKeepAliveTime(Duration.ofMinutes((long)1L)).setKeepAliveWithoutCalls(Boolean.valueOf(true)).setKeepAliveTimeout(Duration.ofMinutes((long)1L)).setPoolSize(CLIENT_POOL_SIZE).setExecutor(SystemExecutors.getFuturesExecutor()).build();
    }

    public static <Settings extends ClientSettings<Settings>, Builder extends ClientSettings.Builder<Settings, Builder>> Settings addDefaultSettings(CloudRegion target, Builder builder) throws ApiException {
        try {
            return (Settings)builder.setEndpoint(Endpoints.regionalEndpoint(target)).setBackgroundExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)SystemExecutors.getAlarmExecutor())).setTransportChannelProvider(ServiceClients.getTransportChannelProvider()).build();
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public static ApiCallContext getCallContext(PubsubContext context, RoutingMetadata routingMetadata) {
        return GrpcCallContext.createDefault().withExtraHeaders(Multimaps.asMap((ListMultimap)ImmutableListMultimap.builder().putAll(context.getMetadata().entrySet()).putAll(routingMetadata.getMetadata().entrySet()).build()));
    }
}

