/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.BuildsSettings;
import com.google.cloud.run.v2.SubmitBuildRequest;
import com.google.cloud.run.v2.SubmitBuildResponse;
import com.google.cloud.run.v2.stub.BuildsStub;
import com.google.cloud.run.v2.stub.BuildsStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class BuildsClient
implements BackgroundResource {
    private final BuildsSettings settings;
    private final BuildsStub stub;

    public static final BuildsClient create() throws IOException {
        return BuildsClient.create(BuildsSettings.newBuilder().build());
    }

    public static final BuildsClient create(BuildsSettings settings) throws IOException {
        return new BuildsClient(settings);
    }

    public static final BuildsClient create(BuildsStub stub) {
        return new BuildsClient(stub);
    }

    protected BuildsClient(BuildsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BuildsStubSettings)settings.getStubSettings()).createStub();
    }

    protected BuildsClient(BuildsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BuildsSettings getSettings() {
        return this.settings;
    }

    public BuildsStub getStub() {
        return this.stub;
    }

    public final SubmitBuildResponse submitBuild(SubmitBuildRequest request) {
        return (SubmitBuildResponse)this.submitBuildCallable().call((Object)request);
    }

    public final UnaryCallable<SubmitBuildRequest, SubmitBuildResponse> submitBuildCallable() {
        return this.stub.submitBuildCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

