/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.run.v2.DeleteRevisionRequest;
import com.google.cloud.run.v2.GetRevisionRequest;
import com.google.cloud.run.v2.ListRevisionsRequest;
import com.google.cloud.run.v2.ListRevisionsResponse;
import com.google.cloud.run.v2.Revision;
import com.google.cloud.run.v2.RevisionsClient;
import com.google.cloud.run.v2.stub.GrpcRevisionsCallableFactory;
import com.google.cloud.run.v2.stub.RevisionsStub;
import com.google.cloud.run.v2.stub.RevisionsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRevisionsStub
extends RevisionsStub {
    private static final MethodDescriptor<GetRevisionRequest, Revision> getRevisionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Revisions/GetRevision").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRevisionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Revision.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListRevisionsRequest, ListRevisionsResponse> listRevisionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Revisions/ListRevisions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRevisionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRevisionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteRevisionRequest, Operation> deleteRevisionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Revisions/DeleteRevision").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRevisionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable;
    private final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable;
    private final UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable;
    private final UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable;
    private final OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate GET_REVISION_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate LIST_REVISIONS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate DELETE_REVISION_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");

    public static final GrpcRevisionsStub create(RevisionsStubSettings settings) throws IOException {
        return new GrpcRevisionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRevisionsStub create(ClientContext clientContext) throws IOException {
        return new GrpcRevisionsStub(RevisionsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRevisionsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRevisionsStub(RevisionsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRevisionsCallableFactory());
    }

    protected GrpcRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getRevisionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRevisionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_REVISION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listRevisionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRevisionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_REVISIONS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings deleteRevisionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRevisionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_REVISION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.getRevisionCallable = callableFactory.createUnaryCallable(getRevisionTransportSettings, settings.getRevisionSettings(), clientContext);
        this.listRevisionsCallable = callableFactory.createUnaryCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.listRevisionsPagedCallable = callableFactory.createPagedCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.deleteRevisionCallable = callableFactory.createUnaryCallable(deleteRevisionTransportSettings, settings.deleteRevisionSettings(), clientContext);
        this.deleteRevisionOperationCallable = callableFactory.createOperationCallable(deleteRevisionTransportSettings, settings.deleteRevisionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.getRevisionCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.listRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.listRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable() {
        return this.deleteRevisionCallable;
    }

    @Override
    public OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable() {
        return this.deleteRevisionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

