/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.run.v2.DeleteRevisionRequest;
import com.google.cloud.run.v2.GetRevisionRequest;
import com.google.cloud.run.v2.ListRevisionsRequest;
import com.google.cloud.run.v2.ListRevisionsResponse;
import com.google.cloud.run.v2.Revision;
import com.google.cloud.run.v2.RevisionsClient;
import com.google.cloud.run.v2.stub.HttpJsonRevisionsCallableFactory;
import com.google.cloud.run.v2.stub.RevisionsStub;
import com.google.cloud.run.v2.stub.RevisionsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonRevisionsStub
extends RevisionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Revision.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetRevisionRequest, Revision> getRevisionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/GetRevision").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/services/*/revisions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/workerPools/*/revisions/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Revision.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRevisionsRequest, ListRevisionsResponse> listRevisionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/ListRevisions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/services/*}/revisions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/locations/*/workerPools/*}/revisions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRevisionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRevisionRequest, Operation> deleteRevisionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Revisions/DeleteRevision").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/services/*/revisions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/workerPools/*/revisions/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable;
    private final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable;
    private final UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable;
    private final UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable;
    private final OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;
    private static final PathTemplate GET_REVISION_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate LIST_REVISIONS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate DELETE_REVISION_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");

    public static final HttpJsonRevisionsStub create(RevisionsStubSettings settings) throws IOException {
        return new HttpJsonRevisionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRevisionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRevisionsStub(RevisionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRevisionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRevisionsStub(RevisionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRevisionsCallableFactory());
    }

    protected HttpJsonRevisionsStub(RevisionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).put((Object)"google.longrunning.Operations.WaitOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:wait").build()).build());
        HttpJsonCallSettings getRevisionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRevisionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_REVISION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings listRevisionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRevisionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_REVISIONS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteRevisionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRevisionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_REVISION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.getRevisionCallable = callableFactory.createUnaryCallable(getRevisionTransportSettings, settings.getRevisionSettings(), clientContext);
        this.listRevisionsCallable = callableFactory.createUnaryCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.listRevisionsPagedCallable = callableFactory.createPagedCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.deleteRevisionCallable = callableFactory.createUnaryCallable(deleteRevisionTransportSettings, settings.deleteRevisionSettings(), clientContext);
        this.deleteRevisionOperationCallable = callableFactory.createOperationCallable(deleteRevisionTransportSettings, settings.deleteRevisionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getRevisionMethodDescriptor);
        methodDescriptors.add(listRevisionsMethodDescriptor);
        methodDescriptors.add(deleteRevisionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.getRevisionCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.listRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, RevisionsClient.ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.listRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable() {
        return this.deleteRevisionCallable;
    }

    @Override
    public OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable() {
        return this.deleteRevisionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

