/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.jdbc.AbstractJdbcStatement;
import com.google.cloud.spanner.jdbc.CloudSpannerJdbcPartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.CloudSpannerJdbcStatement;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcPartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.rpc.Code;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

class JdbcStatement
extends AbstractJdbcStatement
implements CloudSpannerJdbcStatement {
    static final ImmutableList<String> ALL_COLUMNS = ImmutableList.of((Object)"*");
    private java.sql.ResultSet currentResultSet;
    private java.sql.ResultSet currentGeneratedKeys;
    private long currentUpdateCount;
    private int fetchSize;
    private BatchType currentBatchType = BatchType.NONE;
    final List<Statement> batchedStatements = new ArrayList<Statement>();

    JdbcStatement(JdbcConnection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void close() throws SQLException {
        this.setCurrentResultSet(null);
        super.close();
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        return this.executeQuery(Statement.of((String)sql), new Options.QueryOption[0]);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    private int executeUpdate(String sql, ImmutableList<String> generatedKeysColumns) throws SQLException {
        return this.checkedCast(this.executeLargeUpdate(sql, generatedKeysColumns));
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeLargeUpdate(sql, JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    private long executeLargeUpdate(String sql, ImmutableList<String> generatedKeysColumns) throws SQLException {
        return this.executeLargeUpdate(Statement.of((String)sql), generatedKeysColumns);
    }

    protected long executeLargeUpdate(Statement statement, ImmutableList<String> generatedKeysColumns) throws SQLException {
        Preconditions.checkNotNull(generatedKeysColumns);
        this.checkClosed();
        Statement statementWithReturningClause = this.addReturningToStatement(statement, generatedKeysColumns);
        StatementResult result = this.execute(statementWithReturningClause);
        switch (result.getResultType()) {
            case RESULT_SET: {
                if (generatedKeysColumns.isEmpty()) {
                    throw this.closeResultSetAndCreateInvalidQueryException(result);
                }
                this.currentGeneratedKeys = JdbcResultSet.copyOf(result.getResultSet());
                return this.extractUpdateCountAndClose(result.getResultSet());
            }
            case UPDATE_COUNT: {
                return result.getUpdateCount();
            }
            case NO_RESULT: {
                return 0L;
            }
        }
        throw JdbcSqlExceptionFactory.of("unknown result: " + result.getResultType(), Code.FAILED_PRECONDITION);
    }

    private long extractUpdateCountAndClose(ResultSet resultSet) throws SQLException {
        try {
            long updateCount;
            if (resultSet.getStats() == null) {
                throw JdbcSqlExceptionFactory.of("Result does not contain any stats", Code.FAILED_PRECONDITION);
            }
            if (resultSet.getStats().hasRowCountExact()) {
                updateCount = resultSet.getStats().getRowCountExact();
            } else if (resultSet.getStats().hasRowCountLowerBound()) {
                updateCount = resultSet.getStats().getRowCountLowerBound();
            } else {
                throw JdbcSqlExceptionFactory.of("Result does not contain an update count", Code.FAILED_PRECONDITION);
            }
            long l = updateCount;
            return l;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw JdbcSqlExceptionFactory.of(unsupportedOperationException.getMessage(), Code.FAILED_PRECONDITION, unsupportedOperationException);
        }
        finally {
            resultSet.close();
        }
    }

    private SQLException closeResultSetAndCreateInvalidQueryException(StatementResult result) {
        try {
            result.getResultSet().close();
        }
        finally {
            return JdbcSqlExceptionFactory.of("The statement is not a non-returning DML or DDL statement", Code.INVALID_ARGUMENT);
        }
    }

    Statement addReturningToStatement(Statement statement, ImmutableList<String> generatedKeysColumns) throws SQLException {
        if (((ImmutableList)Preconditions.checkNotNull(generatedKeysColumns)).isEmpty()) {
            return statement;
        }
        AbstractStatementParser.ParsedStatement parsedStatement = this.getConnection().getParser().parse(statement);
        if (parsedStatement.isUpdate() && !parsedStatement.hasReturningClause()) {
            if (generatedKeysColumns.size() == 1 && ((String)ALL_COLUMNS.get(0)).equals(generatedKeysColumns.get(0))) {
                return statement.toBuilder().replace(statement.getSql() + this.getReturningAllColumnsClause()).build();
            }
            return statement.toBuilder().replace(generatedKeysColumns.stream().map(this::quoteColumn).collect(Collectors.joining(", ", statement.getSql() + this.getReturningClause() + " ", ""))).build();
        }
        return statement;
    }

    String getReturningAllColumnsClause() {
        switch (this.getConnection().getDialect()) {
            case POSTGRESQL: {
                return "\nRETURNING *";
            }
        }
        return "\nTHEN RETURN *";
    }

    String getReturningClause() {
        switch (this.getConnection().getDialect()) {
            case POSTGRESQL: {
                return "\nRETURNING";
            }
        }
        return "\nTHEN RETURN";
    }

    String quoteColumn(String column) {
        switch (this.getConnection().getDialect()) {
            case POSTGRESQL: {
                return "\"" + column + "\"";
            }
        }
        return "`" + column + "`";
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeStatement(Statement.of((String)sql), JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    boolean executeStatement(Statement statement, ImmutableList<String> generatedKeysColumns) throws SQLException {
        this.checkClosed();
        Statement statementWithReturning = this.addReturningToStatement(statement, generatedKeysColumns);
        StatementResult result = this.execute(statementWithReturning);
        switch (result.getResultType()) {
            case RESULT_SET: {
                if (statementWithReturning == statement) {
                    this.setCurrentResultSet(JdbcResultSet.of(this, result.getResultSet()));
                    this.currentUpdateCount = -1L;
                    return true;
                }
                this.currentGeneratedKeys = JdbcResultSet.copyOf(result.getResultSet());
                this.currentUpdateCount = this.extractUpdateCountAndClose(result.getResultSet());
                return false;
            }
            case UPDATE_COUNT: {
                this.setCurrentResultSet(null);
                this.currentUpdateCount = result.getUpdateCount();
                return false;
            }
            case NO_RESULT: {
                this.setCurrentResultSet(null);
                this.currentUpdateCount = -2L;
                return false;
            }
        }
        throw JdbcSqlExceptionFactory.of("unknown result: " + result.getResultType(), Code.FAILED_PRECONDITION);
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.currentResultSet;
    }

    void setCurrentResultSet(java.sql.ResultSet resultSet) throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        this.currentResultSet = resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.checkedCast(this.currentUpdateCount);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (!(this.currentResultSet == null || this.currentResultSet.isClosed() || current != 1 && current != 3)) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        this.currentUpdateCount = -1L;
        return false;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    private BatchType determineStatementBatchType(String sql) throws SQLException {
        String sqlWithoutComments = this.parser.removeCommentsAndTrim(sql);
        if (this.parser.isDdlStatement(sqlWithoutComments)) {
            return BatchType.DDL;
        }
        if (this.parser.isUpdateStatement(sqlWithoutComments)) {
            return BatchType.DML;
        }
        throw JdbcSqlExceptionFactory.of("The statement is not suitable for batching. Only DML and DDL statements are allowed for batching.", Code.INVALID_ARGUMENT);
    }

    void checkAndSetBatchType(String sql) throws SQLException {
        this.checkConnectionHasNoActiveBatch();
        BatchType type = this.determineStatementBatchType(sql);
        if (this.currentBatchType == BatchType.NONE) {
            this.currentBatchType = type;
        } else if (this.currentBatchType != type) {
            throw JdbcSqlExceptionFactory.of("Mixing DML and DDL statements in a batch is not allowed.", Code.INVALID_ARGUMENT);
        }
    }

    private void checkConnectionHasNoActiveBatch() throws SQLException {
        if (this.getConnection().getSpannerConnection().isDdlBatchActive() || this.getConnection().getSpannerConnection().isDmlBatchActive()) {
            throw JdbcSqlExceptionFactory.of("Calling addBatch() is not allowed when a DML or DDL batch has been started on the connection.", Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        this.checkAndSetBatchType(sql);
        this.batchedStatements.add(Statement.of((String)sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.checkConnectionHasNoActiveBatch();
        this.batchedStatements.clear();
        this.currentBatchType = BatchType.NONE;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.convertUpdateCounts(this.executeBatch(false));
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.executeBatch(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] executeBatch(boolean large) throws SQLException {
        this.checkClosed();
        this.checkConnectionHasNoActiveBatch();
        AbstractJdbcStatement.StatementTimeout originalTimeout = this.setTemporaryStatementTimeout();
        try {
            switch (this.currentBatchType) {
                case DML: {
                    try {
                        long[] lArray = this.getConnection().getSpannerConnection().executeBatchUpdate(this.batchedStatements);
                        return lArray;
                    }
                    catch (SpannerBatchUpdateException e) {
                        if (!large) throw JdbcSqlExceptionFactory.batchException(this.convertUpdateCounts(e.getUpdateCounts()), e);
                        throw JdbcSqlExceptionFactory.batchException(e.getUpdateCounts(), e);
                    }
                    catch (SpannerException e) {
                        throw JdbcSqlExceptionFactory.of(e);
                    }
                }
                case DDL: {
                    try {
                        this.getConnection().getSpannerConnection().startBatchDdl();
                        Iterator<Statement> e = this.batchedStatements.iterator();
                        while (true) {
                            Object statement;
                            if (!e.hasNext()) {
                                this.getConnection().getSpannerConnection().runBatch();
                                long[] res = new long[this.batchedStatements.size()];
                                Arrays.fill(res, -2L);
                                statement = res;
                                return statement;
                            }
                            statement = e.next();
                            this.execute((Statement)statement);
                        }
                    }
                    catch (SpannerBatchUpdateException e) {
                        long[] res = new long[this.batchedStatements.size()];
                        Arrays.fill(res, -3L);
                        this.convertUpdateCountsToSuccessNoInfo(e.getUpdateCounts(), res);
                        if (!large) throw JdbcSqlExceptionFactory.batchException(this.convertUpdateCounts(res), e);
                        throw JdbcSqlExceptionFactory.batchException(res, e);
                    }
                    catch (SpannerException e) {
                        throw JdbcSqlExceptionFactory.of(e);
                    }
                }
                case NONE: {
                    long[] lArray = new long[]{};
                    return lArray;
                }
            }
            throw JdbcSqlExceptionFactory.unsupported(String.format("Unknown batch type: %s", this.currentBatchType.name()));
        }
        finally {
            this.resetStatementTimeout(originalTimeout);
            this.batchedStatements.clear();
            this.currentBatchType = BatchType.NONE;
        }
    }

    @VisibleForTesting
    int[] convertUpdateCounts(long[] updateCounts) throws SQLException {
        int[] res = new int[updateCounts.length];
        for (int index = 0; index < updateCounts.length; ++index) {
            res[index] = this.checkedCast(updateCounts[index]);
        }
        return res;
    }

    @VisibleForTesting
    void convertUpdateCountsToSuccessNoInfo(long[] updateCounts, long[] res) {
        Preconditions.checkNotNull((Object)updateCounts);
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkArgument((res.length >= updateCounts.length ? 1 : 0) != 0);
        for (int index = 0; index < updateCounts.length; ++index) {
            res[index] = updateCounts[index] > 0L ? -2L : -3L;
        }
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.currentGeneratedKeys == null) {
            this.currentGeneratedKeys = JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"VALUE", (Type)Type.int64())}), Collections.emptyList()));
        }
        return this.currentGeneratedKeys;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql, autoGeneratedKeys == 1 ? ALL_COLUMNS : JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, (ImmutableList<String>)(JdbcStatement.isNullOrEmpty(columnNames) ? JdbcConnection.NO_GENERATED_KEY_COLUMNS : ImmutableList.copyOf((Object[])columnNames)));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql, autoGeneratedKeys == 1 ? ALL_COLUMNS : JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, (ImmutableList<String>)(JdbcStatement.isNullOrEmpty(columnNames) ? JdbcConnection.NO_GENERATED_KEY_COLUMNS : ImmutableList.copyOf((Object[])columnNames)));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeStatement(Statement.of((String)sql), autoGeneratedKeys == 1 ? ALL_COLUMNS : JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeStatement(Statement.of((String)sql), JdbcConnection.NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeStatement(Statement.of((String)sql), (ImmutableList<String>)(JdbcStatement.isNullOrEmpty(columnNames) ? JdbcConnection.NO_GENERATED_KEY_COLUMNS : ImmutableList.copyOf((Object[])columnNames)));
    }

    static boolean isNullOrEmpty(String[] columnNames) {
        return columnNames == null || columnNames.length == 0;
    }

    @Override
    public java.sql.ResultSet partitionQuery(String query, PartitionOptions partitionOptions, Options.QueryOption ... options) throws SQLException {
        return this.runWithStatementTimeout(connection -> JdbcResultSet.of(this, connection.partitionQuery(Statement.of((String)query), partitionOptions, options)));
    }

    @Override
    public java.sql.ResultSet runPartition(String encodedPartitionId) throws SQLException {
        return this.runWithStatementTimeout(connection -> JdbcResultSet.of(this, connection.runPartition(encodedPartitionId)));
    }

    @Override
    public CloudSpannerJdbcPartitionedQueryResultSet runPartitionedQuery(String query, PartitionOptions partitionOptions, Options.QueryOption ... options) throws SQLException {
        return this.runWithStatementTimeout(connection -> JdbcPartitionedQueryResultSet.of((java.sql.Statement)this, connection.runPartitionedQuery(Statement.of((String)query), partitionOptions, options)));
    }

    static enum BatchType {
        NONE,
        DML,
        DDL;

    }
}

