/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseId;
import javax.annotation.Nullable;

public class RestoreInfo {
    private final BackupId backup;
    private final RestoreSourceType sourceType;
    private final Timestamp backupCreateTime;
    private final DatabaseId sourceDatabase;
    private final com.google.spanner.admin.database.v1.RestoreInfo proto;

    private RestoreInfo(Builder builder) {
        this.backup = builder.backup;
        this.sourceType = builder.sourceType;
        this.backupCreateTime = builder.backupCreateTime;
        this.sourceDatabase = builder.sourceDatabase;
        this.proto = builder.proto;
    }

    public BackupId getBackup() {
        return this.backup;
    }

    public RestoreSourceType getSourceType() {
        return this.sourceType;
    }

    public Timestamp getBackupCreateTime() {
        return this.backupCreateTime;
    }

    public DatabaseId getSourceDatabase() {
        return this.sourceDatabase;
    }

    @Nullable
    public com.google.spanner.admin.database.v1.RestoreInfo getProto() {
        return this.proto;
    }

    static RestoreInfo fromProtoOrNullIfDefaultInstance(com.google.spanner.admin.database.v1.RestoreInfo proto) {
        return proto.equals((Object)com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()) ? null : new Builder(BackupId.of(proto.getBackupInfo().getBackup())).setSourceType(RestoreInfo.fromProtoSourceType(proto.getSourceType())).setBackupCreateTime(Timestamp.fromProto((com.google.protobuf.Timestamp)proto.getBackupInfo().getCreateTime())).setSourceDatabase(DatabaseId.of(proto.getBackupInfo().getSourceDatabase())).setProto(proto).build();
    }

    static RestoreSourceType fromProtoSourceType(com.google.spanner.admin.database.v1.RestoreSourceType protoSourceType) {
        switch (protoSourceType) {
            case BACKUP: {
                return RestoreSourceType.BACKUP;
            }
            case TYPE_UNSPECIFIED: {
                return RestoreSourceType.UNSPECIFIED;
            }
        }
        throw new IllegalArgumentException("Unrecognized source type " + protoSourceType);
    }

    private static class Builder {
        private final BackupId backup;
        private RestoreSourceType sourceType;
        private Timestamp backupCreateTime;
        private DatabaseId sourceDatabase;
        private com.google.spanner.admin.database.v1.RestoreInfo proto;

        private Builder(BackupId backup) {
            this.backup = backup;
        }

        private Builder setSourceType(RestoreSourceType sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        private Builder setBackupCreateTime(Timestamp backupCreateTime) {
            this.backupCreateTime = backupCreateTime;
            return this;
        }

        private Builder setSourceDatabase(DatabaseId sourceDatabase) {
            this.sourceDatabase = sourceDatabase;
            return this;
        }

        private Builder setProto(com.google.spanner.admin.database.v1.RestoreInfo proto) {
            this.proto = proto;
            return this;
        }

        private RestoreInfo build() {
            return new RestoreInfo(this);
        }
    }

    public static enum RestoreSourceType {
        UNSPECIFIED,
        BACKUP;

    }
}

