/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class DelayedReadContext<T extends ReadContext>
implements ReadContext {
    private final ApiFuture<T> readContextFuture;

    DelayedReadContext(ApiFuture<T> readContextFuture) {
        this.readContextFuture = readContextFuture;
    }

    T getReadContext() {
        try {
            return (T)((ReadContext)this.readContextFuture.get());
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    @Override
    public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return new ForwardingResultSet((Supplier<? extends ResultSet>)Suppliers.memoize(() -> this.getReadContext().read(table, keys, columns, options)));
    }

    @Override
    public AsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return new ForwardingAsyncResultSet((Supplier<AsyncResultSet>)Suppliers.memoize(() -> this.getReadContext().readAsync(table, keys, columns, options)));
    }

    @Override
    public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return new ForwardingResultSet((Supplier<? extends ResultSet>)Suppliers.memoize(() -> this.getReadContext().readUsingIndex(table, index, keys, columns, options)));
    }

    @Override
    public AsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return new ForwardingAsyncResultSet((Supplier<AsyncResultSet>)Suppliers.memoize(() -> this.getReadContext().readUsingIndexAsync(table, index, keys, columns, options)));
    }

    @Override
    @Nullable
    public Struct readRow(String table, Key key, Iterable<String> columns) {
        return this.getReadContext().readRow(table, key, columns);
    }

    @Override
    public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
        return ApiFutures.transformAsync(this.readContextFuture, readContext -> readContext.readRowAsync(table, key, columns), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    @Nullable
    public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
        return this.getReadContext().readRowUsingIndex(table, index, key, columns);
    }

    @Override
    public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
        return ApiFutures.transformAsync(this.readContextFuture, readContext -> readContext.readRowUsingIndexAsync(table, index, key, columns), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
        return new ForwardingResultSet((Supplier<? extends ResultSet>)Suppliers.memoize(() -> this.getReadContext().executeQuery(statement, options)));
    }

    @Override
    public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
        return new ForwardingAsyncResultSet((Supplier<AsyncResultSet>)Suppliers.memoize(() -> this.getReadContext().executeQueryAsync(statement, options)));
    }

    @Override
    public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
        return new ForwardingResultSet((Supplier<? extends ResultSet>)Suppliers.memoize(() -> this.getReadContext().analyzeQuery(statement, queryMode)));
    }

    @Override
    public void close() {
        try {
            ((ReadContext)this.readContextFuture.get()).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class DelayedReadOnlyTransaction
    extends DelayedReadContext<ReadOnlyTransaction>
    implements ReadOnlyTransaction {
        DelayedReadOnlyTransaction(ApiFuture<ReadOnlyTransaction> readContextFuture) {
            super(readContextFuture);
        }

        @Override
        public Timestamp getReadTimestamp() {
            return ((ReadOnlyTransaction)this.getReadContext()).getReadTimestamp();
        }
    }
}

