/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.Distribution;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class SpannerCloudMonitoringExporterUtils {
    private static final Logger logger = Logger.getLogger(SpannerCloudMonitoringExporterUtils.class.getName());

    private SpannerCloudMonitoringExporterUtils() {
    }

    static String getProjectId(PointData pointData) {
        return (String)pointData.getAttributes().get(BuiltInMetricsConstant.PROJECT_ID_KEY);
    }

    static String getInstanceId(PointData pointData) {
        return (String)pointData.getAttributes().get(BuiltInMetricsConstant.INSTANCE_ID_KEY);
    }

    static List<TimeSeries> convertToSpannerTimeSeries(List<MetricData> collection) {
        ArrayList<TimeSeries> allTimeSeries = new ArrayList<TimeSeries>();
        for (MetricData metricData : collection) {
            if (!metricData.getInstrumentationScopeInfo().getName().equals("gax-java") && !metricData.getInstrumentationScopeInfo().getName().equals("spanner-java")) continue;
            metricData.getData().getPoints().stream().map(pointData -> SpannerCloudMonitoringExporterUtils.convertPointToSpannerTimeSeries(metricData, pointData)).forEach(allTimeSeries::add);
        }
        return allTimeSeries;
    }

    private static TimeSeries convertPointToSpannerTimeSeries(MetricData metricData, PointData pointData) {
        TimeSeries.Builder builder = TimeSeries.newBuilder().setMetricKind(SpannerCloudMonitoringExporterUtils.convertMetricKind(metricData)).setValueType(SpannerCloudMonitoringExporterUtils.convertValueType(metricData.getType()));
        Metric.Builder metricBuilder = Metric.newBuilder().setType(metricData.getName());
        Attributes attributes = pointData.getAttributes();
        MonitoredResource.Builder monitoredResourceBuilder = MonitoredResource.newBuilder().setType("spanner_instance_client");
        for (AttributeKey key : attributes.asMap().keySet()) {
            if (BuiltInMetricsConstant.SPANNER_PROMOTED_RESOURCE_LABELS.contains(key)) {
                monitoredResourceBuilder.putLabels(key.getKey(), String.valueOf(attributes.get(key)));
                continue;
            }
            metricBuilder.putLabels(key.getKey(), String.valueOf(attributes.get(key)));
        }
        builder.setResource(monitoredResourceBuilder.build());
        builder.setMetric(metricBuilder.build());
        TimeInterval timeInterval = TimeInterval.newBuilder().setStartTime(Timestamps.fromNanos((long)pointData.getStartEpochNanos())).setEndTime(Timestamps.fromNanos((long)pointData.getEpochNanos())).build();
        builder.addPoints(SpannerCloudMonitoringExporterUtils.createPoint(metricData.getType(), pointData, timeInterval));
        return builder.build();
    }

    private static MetricDescriptor.MetricKind convertMetricKind(MetricData metricData) {
        switch (metricData.getType()) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return SpannerCloudMonitoringExporterUtils.convertHistogramType(metricData.getHistogramData());
            }
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return MetricDescriptor.MetricKind.GAUGE;
            }
            case LONG_SUM: {
                return SpannerCloudMonitoringExporterUtils.convertSumDataType(metricData.getLongSumData());
            }
            case DOUBLE_SUM: {
                return SpannerCloudMonitoringExporterUtils.convertSumDataType(metricData.getDoubleSumData());
            }
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertHistogramType(HistogramData histogramData) {
        if (histogramData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.MetricKind convertSumDataType(SumData<?> sum) {
        if (!sum.isMonotonic()) {
            return MetricDescriptor.MetricKind.GAUGE;
        }
        if (sum.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.ValueType convertValueType(MetricDataType metricDataType) {
        switch (metricDataType) {
            case LONG_GAUGE: 
            case LONG_SUM: {
                return MetricDescriptor.ValueType.INT64;
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return MetricDescriptor.ValueType.DOUBLE;
            }
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return MetricDescriptor.ValueType.DISTRIBUTION;
            }
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    private static Point createPoint(MetricDataType type, PointData pointData, TimeInterval timeInterval) {
        Point.Builder builder = Point.newBuilder().setInterval(timeInterval);
        switch (type) {
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return builder.setValue(TypedValue.newBuilder().setDistributionValue(SpannerCloudMonitoringExporterUtils.convertHistogramData((HistogramPointData)pointData)).build()).build();
            }
            case DOUBLE_GAUGE: 
            case DOUBLE_SUM: {
                return builder.setValue(TypedValue.newBuilder().setDoubleValue(((DoublePointData)pointData).getValue()).build()).build();
            }
            case LONG_GAUGE: 
            case LONG_SUM: {
                return builder.setValue(TypedValue.newBuilder().setInt64Value(((LongPointData)pointData).getValue())).build();
            }
        }
        logger.log(Level.WARNING, "unsupported metric type");
        return builder.build();
    }

    private static Distribution convertHistogramData(HistogramPointData pointData) {
        return Distribution.newBuilder().setCount(pointData.getCount()).setMean(pointData.getCount() == 0L ? 0.0 : pointData.getSum() / (double)pointData.getCount()).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds((Iterable)pointData.getBoundaries()))).addAllBucketCounts((Iterable)pointData.getCounts()).build();
    }
}

