/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.services.storage.model.Bucket;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BackwardCompatibilityUtils;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.Rpo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@TransportCompatibility(value={TransportCompatibility.Transport.HTTP, TransportCompatibility.Transport.GRPC})
public class BucketInfo
implements Serializable {
    private static final Predicate<LifecycleRule> IS_DELETE_LIFECYCLE_RULE = r -> r.getAction().getActionType().equals("Delete");
    private static final long serialVersionUID = 4793572058456298945L;
    private final String generatedId;
    private final BigInteger project;
    private final String name;
    private final Acl.Entity owner;
    private final String selfLink;
    private final Boolean requesterPays;
    private final Boolean versioningEnabled;
    private final String indexPage;
    private final String notFoundPage;
    final List<LifecycleRule> lifecycleRules;
    private final String etag;
    private final OffsetDateTime createTime;
    private final OffsetDateTime updateTime;
    private final Long metageneration;
    private final List<Cors> cors;
    private final List<Acl> acl;
    private final List<Acl> defaultAcl;
    private final String location;
    private final Rpo rpo;
    private final StorageClass storageClass;
    private final @Nullable Map<String, String> labels;
    private final String defaultKmsKeyName;
    private final Boolean defaultEventBasedHold;
    private final OffsetDateTime retentionEffectiveTime;
    private final Boolean retentionPolicyIsLocked;
    private final Duration retentionPeriod;
    private final IamConfiguration iamConfiguration;
    private final Autoclass autoclass;
    private final String locationType;
    private final Logging logging;
    private final CustomPlacementConfig customPlacementConfig;
    private final ObjectRetention objectRetention;
    private final HierarchicalNamespace hierarchicalNamespace;
    private final SoftDeletePolicy softDeletePolicy;
    private final transient ImmutableSet<UnifiedOpts.NamedField> modifiedFields;
    static final Logger log = Logger.getLogger(BucketInfo.class.getName());

    BucketInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.project = builder.project;
        this.name = builder.name;
        this.etag = builder.etag;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.metageneration = builder.metageneration;
        this.location = builder.location;
        this.rpo = builder.rpo;
        this.storageClass = builder.storageClass;
        this.cors = builder.cors;
        this.acl = builder.acl;
        this.defaultAcl = builder.defaultAcl;
        this.owner = builder.owner;
        this.selfLink = builder.selfLink;
        this.versioningEnabled = builder.versioningEnabled;
        this.indexPage = builder.indexPage;
        this.notFoundPage = builder.notFoundPage;
        this.lifecycleRules = builder.lifecycleRules;
        this.labels = builder.labels;
        this.requesterPays = builder.requesterPays;
        this.defaultKmsKeyName = builder.defaultKmsKeyName;
        this.defaultEventBasedHold = builder.defaultEventBasedHold;
        this.retentionEffectiveTime = builder.retentionEffectiveTime;
        this.retentionPolicyIsLocked = builder.retentionPolicyIsLocked;
        this.retentionPeriod = builder.retentionPeriod;
        this.iamConfiguration = builder.iamConfiguration;
        this.autoclass = builder.autoclass;
        this.locationType = builder.locationType;
        this.logging = builder.logging;
        this.customPlacementConfig = builder.customPlacementConfig;
        this.objectRetention = builder.objectRetention;
        this.softDeletePolicy = builder.softDeletePolicy;
        this.hierarchicalNamespace = builder.hierarchicalNamespace;
        this.modifiedFields = builder.modifiedFields.build();
    }

    public BigInteger getProject() {
        return this.project;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.name;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Boolean versioningEnabled() {
        return Data.isNull((Object)this.versioningEnabled) ? null : this.versioningEnabled;
    }

    public Boolean requesterPays() {
        return Data.isNull((Object)this.requesterPays) ? null : this.requesterPays;
    }

    public String getIndexPage() {
        return this.indexPage;
    }

    public String getNotFoundPage() {
        return this.notFoundPage;
    }

    @Deprecated
    public List<? extends DeleteRule> getDeleteRules() {
        return (List)this.getLifecycleRules().stream().filter(IS_DELETE_LIFECYCLE_RULE).map(BackwardCompatibilityUtils.deleteRuleCodec::decode).collect(ImmutableList.toImmutableList());
    }

    public @NonNull List<? extends LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules != null ? this.lifecycleRules : ImmutableList.of();
    }

    public String getEtag() {
        return this.etag;
    }

    @Deprecated
    public Long getCreateTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.createTime);
    }

    public OffsetDateTime getCreateTimeOffsetDateTime() {
        return this.createTime;
    }

    @Deprecated
    public Long getUpdateTime() {
        return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.updateTime);
    }

    public OffsetDateTime getUpdateTimeOffsetDateTime() {
        return this.updateTime;
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public Rpo getRpo() {
        return this.rpo;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public List<Cors> getCors() {
        return this.cors;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public List<Acl> getDefaultAcl() {
        return this.defaultAcl;
    }

    public @Nullable Map<@NonNull String, @Nullable String> getLabels() {
        return this.labels;
    }

    public String getDefaultKmsKeyName() {
        return this.defaultKmsKeyName;
    }

    @BetaApi
    public Boolean getDefaultEventBasedHold() {
        return Data.isNull((Object)this.defaultEventBasedHold) ? null : this.defaultEventBasedHold;
    }

    @BetaApi
    @Deprecated
    public Long getRetentionEffectiveTime() {
        return Data.isNull((Object)this.retentionEffectiveTime) ? null : (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.retentionEffectiveTime);
    }

    @BetaApi
    public OffsetDateTime getRetentionEffectiveTimeOffsetDateTime() {
        return this.retentionEffectiveTime;
    }

    @BetaApi
    public Boolean retentionPolicyIsLocked() {
        return Data.isNull((Object)this.retentionPolicyIsLocked) ? null : this.retentionPolicyIsLocked;
    }

    @BetaApi
    @Deprecated
    public Long getRetentionPeriod() {
        return (Long)BackwardCompatibilityUtils.nullableDurationSecondsCodec.encode(this.retentionPeriod);
    }

    @BetaApi
    public Duration getRetentionPeriodDuration() {
        return this.retentionPeriod;
    }

    @BetaApi
    public IamConfiguration getIamConfiguration() {
        return this.iamConfiguration;
    }

    public Autoclass getAutoclass() {
        return this.autoclass;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public CustomPlacementConfig getCustomPlacementConfig() {
        return this.customPlacementConfig;
    }

    public ObjectRetention getObjectRetention() {
        return this.objectRetention;
    }

    public SoftDeletePolicy getSoftDeletePolicy() {
        return this.softDeletePolicy;
    }

    public HierarchicalNamespace getHierarchicalNamespace() {
        return this.hierarchicalNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.generatedId, this.project, this.name, this.owner, this.selfLink, this.requesterPays, this.versioningEnabled, this.indexPage, this.notFoundPage, this.lifecycleRules, this.etag, this.createTime, this.updateTime, this.metageneration, this.cors, this.acl, this.defaultAcl, this.location, this.rpo, this.storageClass, this.labels, this.defaultKmsKeyName, this.defaultEventBasedHold, this.retentionEffectiveTime, this.retentionPolicyIsLocked, this.retentionPeriod, this.iamConfiguration, this.autoclass, this.locationType, this.objectRetention, this.softDeletePolicy, this.customPlacementConfig, this.hierarchicalNamespace, this.logging});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketInfo)) {
            return false;
        }
        BucketInfo that = (BucketInfo)o;
        return Objects.equals(this.generatedId, that.generatedId) && Objects.equals(this.project, that.project) && Objects.equals(this.name, that.name) && Objects.equals(this.owner, that.owner) && Objects.equals(this.selfLink, that.selfLink) && Objects.equals(this.requesterPays, that.requesterPays) && Objects.equals(this.versioningEnabled, that.versioningEnabled) && Objects.equals(this.indexPage, that.indexPage) && Objects.equals(this.notFoundPage, that.notFoundPage) && Objects.equals(this.lifecycleRules, that.lifecycleRules) && Objects.equals(this.etag, that.etag) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.metageneration, that.metageneration) && Objects.equals(this.cors, that.cors) && Objects.equals(this.acl, that.acl) && Objects.equals(this.defaultAcl, that.defaultAcl) && Objects.equals(this.location, that.location) && Objects.equals((Object)this.rpo, (Object)that.rpo) && Objects.equals((Object)this.storageClass, (Object)that.storageClass) && Objects.equals(this.labels, that.labels) && Objects.equals(this.defaultKmsKeyName, that.defaultKmsKeyName) && Objects.equals(this.defaultEventBasedHold, that.defaultEventBasedHold) && Objects.equals(this.retentionEffectiveTime, that.retentionEffectiveTime) && Objects.equals(this.retentionPolicyIsLocked, that.retentionPolicyIsLocked) && Objects.equals(this.retentionPeriod, that.retentionPeriod) && Objects.equals(this.iamConfiguration, that.iamConfiguration) && Objects.equals(this.autoclass, that.autoclass) && Objects.equals(this.locationType, that.locationType) && Objects.equals(this.customPlacementConfig, that.customPlacementConfig) && Objects.equals(this.objectRetention, that.objectRetention) && Objects.equals(this.softDeletePolicy, that.softDeletePolicy) && Objects.equals(this.hierarchicalNamespace, that.hierarchicalNamespace) && Objects.equals(this.logging, that.logging);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    Bucket asBucket(Storage storage) {
        return new Bucket(storage, new BuilderImpl(this));
    }

    ImmutableSet<UnifiedOpts.NamedField> getModifiedFields() {
        return this.modifiedFields;
    }

    public static BucketInfo of(String name) {
        return BucketInfo.newBuilder(name).build();
    }

    public static Builder newBuilder(String name) {
        return new BuilderImpl(name);
    }

    public static final class HierarchicalNamespace
    implements Serializable {
        private static final long serialVersionUID = 5932926691444613101L;
        private Boolean enabled;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HierarchicalNamespace)) {
                return false;
            }
            HierarchicalNamespace that = (HierarchicalNamespace)o;
            return Objects.equals(this.enabled, that.enabled);
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).toString();
        }

        private HierarchicalNamespace() {
        }

        private HierarchicalNamespace(Builder builder) {
            this.enabled = builder.enabled;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return HierarchicalNamespace.newBuilder().setEnabled(this.enabled);
        }

        public static final class Builder {
            private Boolean enabled;

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public HierarchicalNamespace build() {
                return new HierarchicalNamespace(this);
            }
        }
    }

    public static class SoftDeletePolicy
    implements Serializable {
        private static final long serialVersionUID = -8100190443052242908L;
        private Duration retentionDuration;
        private OffsetDateTime effectiveTime;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoftDeletePolicy)) {
                return false;
            }
            SoftDeletePolicy that = (SoftDeletePolicy)o;
            return Objects.equals(this.retentionDuration, that.retentionDuration) && Objects.equals(this.effectiveTime, that.effectiveTime);
        }

        public int hashCode() {
            return Objects.hash(this.retentionDuration, this.effectiveTime);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("retentionDuration", (Object)this.retentionDuration).add("effectiveTime", (Object)this.effectiveTime).toString();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().setRetentionDuration(this.retentionDuration).setEffectiveTime(this.effectiveTime);
        }

        private SoftDeletePolicy() {
        }

        public SoftDeletePolicy(Builder builder) {
            this.retentionDuration = builder.retentionDuration;
            this.effectiveTime = builder.effectiveTime;
        }

        public Duration getRetentionDuration() {
            return this.retentionDuration;
        }

        public OffsetDateTime getEffectiveTime() {
            return this.effectiveTime;
        }

        public static final class Builder {
            private Duration retentionDuration;
            private OffsetDateTime effectiveTime;

            public Builder setRetentionDuration(Duration retentionDuration) {
                this.retentionDuration = retentionDuration;
                return this;
            }

            Builder setEffectiveTime(OffsetDateTime effectiveTime) {
                this.effectiveTime = effectiveTime;
                return this;
            }

            public SoftDeletePolicy build() {
                return new SoftDeletePolicy(this);
            }
        }
    }

    public static final class ObjectRetention
    implements Serializable {
        private static final long serialVersionUID = 3948199339534287669L;
        private Mode mode;

        public Mode getMode() {
            return this.mode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ObjectRetention)) {
                return false;
            }
            ObjectRetention that = (ObjectRetention)o;
            return Objects.equals((Object)this.mode, (Object)that.mode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mode});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).toString();
        }

        private ObjectRetention() {
        }

        private ObjectRetention(Builder builder) {
            this.mode = builder.mode;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().setMode(this.mode);
        }

        public static final class Builder {
            private Mode mode;

            public Builder setMode(Mode mode) {
                this.mode = mode;
                return this;
            }

            public ObjectRetention build() {
                return new ObjectRetention(this);
            }
        }

        public static final class Mode
        extends StringEnumValue {
            private static final long serialVersionUID = 1973143582659557184L;
            private static final ApiFunction<String, Mode> CONSTRUCTOR = Mode::new;
            private static final StringEnumType<Mode> type = new StringEnumType(Mode.class, CONSTRUCTOR);
            public static final Mode ENABLED = (Mode)((Object)type.createAndRegister("Enabled"));
            public static final Mode DISABLED = (Mode)((Object)type.createAndRegister("Disabled"));

            private Mode(String constant) {
                super(constant);
            }

            public static Mode valueOfStrict(String constant) {
                return (Mode)((Object)type.valueOfStrict(constant));
            }

            public static Mode valueOf(String constant) {
                return (Mode)((Object)type.valueOf(constant));
            }

            public static Mode[] values() {
                return (Mode[])type.values();
            }
        }
    }

    public static class CustomPlacementConfig
    implements Serializable {
        private static final long serialVersionUID = 7284488308696895602L;
        private List<String> dataLocations;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomPlacementConfig)) {
                return false;
            }
            CustomPlacementConfig that = (CustomPlacementConfig)o;
            return Objects.equals(this.dataLocations, that.dataLocations);
        }

        public int hashCode() {
            return Objects.hash(this.dataLocations);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dataLocations", this.dataLocations).toString();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.dataLocations = this.dataLocations;
            return builder;
        }

        public List<String> getDataLocations() {
            return this.dataLocations;
        }

        private CustomPlacementConfig(Builder builder) {
            this.dataLocations = builder.dataLocations;
        }

        public static class Builder {
            private List<String> dataLocations;

            public Builder setDataLocations(List<String> dataLocations) {
                this.dataLocations = dataLocations != null ? ImmutableList.copyOf(dataLocations) : null;
                return this;
            }

            public CustomPlacementConfig build() {
                return new CustomPlacementConfig(this);
            }
        }
    }

    public static class Logging
    implements Serializable {
        private static final long serialVersionUID = 5213268072569764596L;
        private final String logBucket;
        private final String logObjectPrefix;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Logging)) {
                return false;
            }
            Logging logging = (Logging)o;
            return Objects.equals(this.logBucket, logging.logBucket) && Objects.equals(this.logObjectPrefix, logging.logObjectPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.logBucket, this.logObjectPrefix);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.logBucket = this.logBucket;
            builder.logObjectPrefix = this.logObjectPrefix;
            return builder;
        }

        public String getLogBucket() {
            return this.logBucket;
        }

        public String getLogObjectPrefix() {
            return this.logObjectPrefix;
        }

        private Logging(Builder builder) {
            this.logBucket = builder.logBucket;
            this.logObjectPrefix = builder.logObjectPrefix;
        }

        public static class Builder {
            private String logBucket;
            private String logObjectPrefix;

            public Builder setLogBucket(String logBucket) {
                this.logBucket = logBucket;
                return this;
            }

            public Builder setLogObjectPrefix(String logObjectPrefix) {
                this.logObjectPrefix = logObjectPrefix;
                return this;
            }

            public Logging build() {
                return new Logging(this);
            }
        }
    }

    public static final class Autoclass
    implements Serializable {
        private static final long serialVersionUID = -2378172222188072439L;
        private final Boolean enabled;
        private final OffsetDateTime toggleTime;
        private final StorageClass terminalStorageClass;
        private final OffsetDateTime terminalStorageClassUpdateTime;

        private Autoclass(Builder builder) {
            this.enabled = builder.enabled;
            this.toggleTime = builder.toggleTime;
            this.terminalStorageClass = builder.terminalStorageClass;
            this.terminalStorageClassUpdateTime = builder.terminalStorageClassUpdateTime;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public OffsetDateTime getToggleTime() {
            return this.toggleTime;
        }

        public StorageClass getTerminalStorageClass() {
            return this.terminalStorageClass;
        }

        public OffsetDateTime getTerminalStorageClassUpdateTime() {
            return this.terminalStorageClassUpdateTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Autoclass)) {
                return false;
            }
            Autoclass autoclass = (Autoclass)o;
            return Objects.equals(this.enabled, autoclass.enabled) && Objects.equals(this.toggleTime, autoclass.toggleTime) && Objects.equals((Object)this.terminalStorageClass, (Object)autoclass.terminalStorageClass) && Objects.equals(this.terminalStorageClassUpdateTime, autoclass.terminalStorageClassUpdateTime);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.enabled, this.toggleTime, this.terminalStorageClass, this.terminalStorageClassUpdateTime});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).add("toggleTime", (Object)this.toggleTime).add("terminalStorageClass", (Object)this.terminalStorageClass).add("terminalStorageClassUpdateTime", (Object)this.terminalStorageClassUpdateTime).toString();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Autoclass.newBuilder().setEnabled(this.enabled).setToggleTime(this.toggleTime).setTerminalStorageClass(this.terminalStorageClass).setTerminalStorageClassUpdateTime(this.terminalStorageClassUpdateTime);
        }

        public static final class Builder {
            private Boolean enabled;
            private OffsetDateTime toggleTime;
            private StorageClass terminalStorageClass;
            private OffsetDateTime terminalStorageClassUpdateTime;

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            Builder setToggleTime(OffsetDateTime toggleTime) {
                this.toggleTime = toggleTime;
                return this;
            }

            public Builder setTerminalStorageClass(StorageClass terminalStorageClass) {
                this.terminalStorageClass = terminalStorageClass;
                return this;
            }

            Builder setTerminalStorageClassUpdateTime(OffsetDateTime terminalStorageClassUpdateTime) {
                this.terminalStorageClassUpdateTime = terminalStorageClassUpdateTime;
                return this;
            }

            public Autoclass build() {
                return new Autoclass(this);
            }
        }
    }

    public static class IamConfiguration
    implements Serializable {
        private static final long serialVersionUID = -7564209362829587435L;
        private final Boolean isUniformBucketLevelAccessEnabled;
        private final OffsetDateTime uniformBucketLevelAccessLockedTime;
        private final PublicAccessPrevention publicAccessPrevention;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IamConfiguration)) {
                return false;
            }
            IamConfiguration that = (IamConfiguration)o;
            return Objects.equals(this.isUniformBucketLevelAccessEnabled, that.isUniformBucketLevelAccessEnabled) && Objects.equals(this.uniformBucketLevelAccessLockedTime, that.uniformBucketLevelAccessLockedTime) && this.publicAccessPrevention == that.publicAccessPrevention;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.isUniformBucketLevelAccessEnabled, this.uniformBucketLevelAccessLockedTime, this.publicAccessPrevention});
        }

        private IamConfiguration(Builder builder) {
            this.isUniformBucketLevelAccessEnabled = builder.isUniformBucketLevelAccessEnabled;
            this.uniformBucketLevelAccessLockedTime = builder.uniformBucketLevelAccessLockedTime;
            this.publicAccessPrevention = builder.publicAccessPrevention;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.isUniformBucketLevelAccessEnabled = this.isUniformBucketLevelAccessEnabled;
            builder.uniformBucketLevelAccessLockedTime = this.uniformBucketLevelAccessLockedTime;
            builder.publicAccessPrevention = this.publicAccessPrevention;
            return builder;
        }

        @Deprecated
        public Boolean isBucketPolicyOnlyEnabled() {
            return this.isUniformBucketLevelAccessEnabled;
        }

        @Deprecated
        public Long getBucketPolicyOnlyLockedTime() {
            return this.getUniformBucketLevelAccessLockedTime();
        }

        public Boolean isUniformBucketLevelAccessEnabled() {
            return this.isUniformBucketLevelAccessEnabled;
        }

        @Deprecated
        public Long getUniformBucketLevelAccessLockedTime() {
            return (Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(this.uniformBucketLevelAccessLockedTime);
        }

        public OffsetDateTime getUniformBucketLevelAccessLockedTimeOffsetDateTime() {
            return this.uniformBucketLevelAccessLockedTime;
        }

        public PublicAccessPrevention getPublicAccessPrevention() {
            return this.publicAccessPrevention;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("isUniformBucketLevelAccessEnabled", (Object)this.isUniformBucketLevelAccessEnabled).add("uniformBucketLevelAccessLockedTime", (Object)this.uniformBucketLevelAccessLockedTime).add("publicAccessPrevention", (Object)this.publicAccessPrevention).toString();
        }

        public static class Builder {
            private Boolean isUniformBucketLevelAccessEnabled;
            private OffsetDateTime uniformBucketLevelAccessLockedTime;
            private PublicAccessPrevention publicAccessPrevention;

            @Deprecated
            public Builder setIsBucketPolicyOnlyEnabled(Boolean isBucketPolicyOnlyEnabled) {
                this.isUniformBucketLevelAccessEnabled = isBucketPolicyOnlyEnabled;
                return this;
            }

            @Deprecated
            Builder setBucketPolicyOnlyLockedTime(Long bucketPolicyOnlyLockedTime) {
                return this.setUniformBucketLevelAccessLockedTime(bucketPolicyOnlyLockedTime);
            }

            public Builder setIsUniformBucketLevelAccessEnabled(Boolean isUniformBucketLevelAccessEnabled) {
                this.isUniformBucketLevelAccessEnabled = isUniformBucketLevelAccessEnabled;
                return this;
            }

            @Deprecated
            Builder setUniformBucketLevelAccessLockedTime(Long uniformBucketLevelAccessLockedTime) {
                return this.setUniformBucketLevelAccessLockedTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(uniformBucketLevelAccessLockedTime));
            }

            Builder setUniformBucketLevelAccessLockedTimeOffsetDateTime(OffsetDateTime uniformBucketLevelAccessLockedTime) {
                this.uniformBucketLevelAccessLockedTime = uniformBucketLevelAccessLockedTime;
                return this;
            }

            public Builder setPublicAccessPrevention(PublicAccessPrevention publicAccessPrevention) {
                this.publicAccessPrevention = publicAccessPrevention;
                return this;
            }

            public IamConfiguration build() {
                return new IamConfiguration(this);
            }
        }
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private BigInteger project;
        private String name;
        private Acl.Entity owner;
        private String selfLink;
        private Boolean requesterPays;
        private Boolean versioningEnabled;
        private String indexPage;
        private String notFoundPage;
        private @Nullable List<LifecycleRule> lifecycleRules;
        private Rpo rpo;
        private StorageClass storageClass;
        private String location;
        private String etag;
        private OffsetDateTime createTime;
        private OffsetDateTime updateTime;
        private Long metageneration;
        private List<Cors> cors;
        private List<Acl> acl;
        private List<Acl> defaultAcl;
        private Map<String, String> labels;
        private String defaultKmsKeyName;
        private Boolean defaultEventBasedHold;
        private OffsetDateTime retentionEffectiveTime;
        private Boolean retentionPolicyIsLocked;
        private Duration retentionPeriod;
        private IamConfiguration iamConfiguration;
        private Autoclass autoclass;
        private String locationType;
        private Logging logging;
        private CustomPlacementConfig customPlacementConfig;
        private ObjectRetention objectRetention;
        private SoftDeletePolicy softDeletePolicy;
        private HierarchicalNamespace hierarchicalNamespace;
        private final ImmutableSet.Builder<UnifiedOpts.NamedField> modifiedFields = ImmutableSet.builder();

        BuilderImpl(String name) {
            this.name = name;
        }

        BuilderImpl(BucketInfo bucketInfo) {
            this.generatedId = bucketInfo.generatedId;
            this.project = bucketInfo.project;
            this.name = bucketInfo.name;
            this.etag = bucketInfo.etag;
            this.createTime = bucketInfo.createTime;
            this.updateTime = bucketInfo.updateTime;
            this.metageneration = bucketInfo.metageneration;
            this.location = bucketInfo.location;
            this.rpo = bucketInfo.rpo;
            this.storageClass = bucketInfo.storageClass;
            this.cors = bucketInfo.cors;
            this.acl = bucketInfo.acl;
            this.defaultAcl = bucketInfo.defaultAcl;
            this.owner = bucketInfo.owner;
            this.selfLink = bucketInfo.selfLink;
            this.versioningEnabled = bucketInfo.versioningEnabled;
            this.indexPage = bucketInfo.indexPage;
            this.notFoundPage = bucketInfo.notFoundPage;
            this.lifecycleRules = bucketInfo.lifecycleRules;
            this.labels = bucketInfo.labels;
            this.requesterPays = bucketInfo.requesterPays;
            this.defaultKmsKeyName = bucketInfo.defaultKmsKeyName;
            this.defaultEventBasedHold = bucketInfo.defaultEventBasedHold;
            this.retentionEffectiveTime = bucketInfo.retentionEffectiveTime;
            this.retentionPolicyIsLocked = bucketInfo.retentionPolicyIsLocked;
            this.retentionPeriod = bucketInfo.retentionPeriod;
            this.iamConfiguration = bucketInfo.iamConfiguration;
            this.autoclass = bucketInfo.autoclass;
            this.locationType = bucketInfo.locationType;
            this.logging = bucketInfo.logging;
            this.customPlacementConfig = bucketInfo.customPlacementConfig;
            this.objectRetention = bucketInfo.objectRetention;
            this.softDeletePolicy = bucketInfo.softDeletePolicy;
            this.hierarchicalNamespace = bucketInfo.hierarchicalNamespace;
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        Builder setProject(BigInteger project) {
            if (!Objects.equals(this.project, project)) {
                this.modifiedFields.add((Object)Storage.BucketField.PROJECT);
            }
            this.project = project;
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            if (!Objects.equals(this.owner, owner)) {
                this.modifiedFields.add((Object)Storage.BucketField.OWNER);
            }
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setVersioningEnabled(Boolean enable) {
            Boolean tmp = (Boolean)MoreObjects.firstNonNull((Object)enable, (Object)((Boolean)Data.nullOf(Boolean.class)));
            if (!Objects.equals(this.versioningEnabled, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.VERSIONING);
            }
            this.versioningEnabled = tmp;
            return this;
        }

        @Override
        public Builder setRequesterPays(Boolean enable) {
            Boolean tmp = (Boolean)MoreObjects.firstNonNull((Object)enable, (Object)((Boolean)Data.nullOf(Boolean.class)));
            if (!Objects.equals(this.requesterPays, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.BILLING);
            }
            this.requesterPays = tmp;
            return this;
        }

        @Override
        public Builder setIndexPage(String indexPage) {
            if (!Objects.equals(this.indexPage, indexPage)) {
                this.modifiedFields.add((Object)Storage.BucketField.WEBSITE);
            }
            this.indexPage = indexPage;
            return this;
        }

        @Override
        public Builder setNotFoundPage(String notFoundPage) {
            if (!Objects.equals(this.notFoundPage, notFoundPage)) {
                this.modifiedFields.add((Object)Storage.BucketField.WEBSITE);
            }
            this.notFoundPage = notFoundPage;
            return this;
        }

        @Override
        @Deprecated
        public Builder setDeleteRules(Iterable<? extends DeleteRule> rules) {
            if (rules == null) {
                return this.clearDeleteLifecycleRules();
            }
            ArrayList deleteRules = Lists.newArrayList(rules);
            if (deleteRules.isEmpty()) {
                if (this.lifecycleRules != null) {
                    return this.clearDeleteLifecycleRules();
                }
                this.lifecycleRules = ImmutableList.of();
                return this;
            }
            Stream<LifecycleRule> newDeleteRules = deleteRules.stream().map(BackwardCompatibilityUtils.deleteRuleCodec::encode);
            if (this.lifecycleRules == null) {
                return this.setLifecycleRules((Iterable)newDeleteRules.collect(ImmutableList.toImmutableList()));
            }
            ImmutableList newLifecycleRules = (ImmutableList)Streams.concat((Stream[])new Stream[]{this.lifecycleRules.stream().filter(IS_DELETE_LIFECYCLE_RULE.negate()), newDeleteRules}).collect(ImmutableList.toImmutableList());
            return this.setLifecycleRules((Iterable<? extends LifecycleRule>)newLifecycleRules);
        }

        @Override
        public Builder setLifecycleRules(Iterable<? extends LifecycleRule> rules) {
            ImmutableList tmp = rules != null ? (rules instanceof ImmutableList ? (ImmutableList)rules : ImmutableList.copyOf(rules)) : ImmutableList.of();
            if (!Objects.equals(this.lifecycleRules, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.LIFECYCLE);
            }
            this.lifecycleRules = tmp;
            return this;
        }

        @Override
        public Builder deleteLifecycleRules() {
            return this.setLifecycleRules(null);
        }

        @Override
        public Builder setRpo(Rpo rpo) {
            if (!Objects.equals((Object)this.rpo, (Object)rpo)) {
                this.modifiedFields.add((Object)Storage.BucketField.RPO);
            }
            this.rpo = rpo;
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            if (!Objects.equals((Object)this.storageClass, (Object)storageClass)) {
                this.modifiedFields.add((Object)Storage.BucketField.STORAGE_CLASS);
            }
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            if (!Objects.equals(this.location, location)) {
                this.modifiedFields.add((Object)Storage.BucketField.LOCATION);
            }
            this.location = location;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            if (!Objects.equals(this.etag, etag)) {
                this.modifiedFields.add((Object)Storage.BucketField.ETAG);
            }
            this.etag = etag;
            return this;
        }

        @Override
        @Deprecated
        Builder setCreateTime(Long createTime) {
            return this.setCreateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(createTime));
        }

        @Override
        Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            if (!Objects.equals(this.createTime, createTime)) {
                this.modifiedFields.add((Object)Storage.BucketField.TIME_CREATED);
            }
            this.createTime = createTime;
            return this;
        }

        @Override
        @Deprecated
        Builder setUpdateTime(Long updateTime) {
            return this.setUpdateTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(updateTime));
        }

        @Override
        Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            if (!Objects.equals(this.updateTime, updateTime)) {
                this.modifiedFields.add((Object)Storage.BucketField.UPDATED);
            }
            this.updateTime = updateTime;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        public Builder setCors(Iterable<Cors> cors) {
            ImmutableList tmp;
            ImmutableList immutableList = tmp = cors != null ? ImmutableList.copyOf(cors) : ImmutableList.of();
            if (!Objects.equals(this.cors, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.CORS);
            }
            this.cors = tmp;
            return this;
        }

        @Override
        public Builder setAcl(Iterable<Acl> acl) {
            ImmutableList tmp;
            ImmutableList immutableList = tmp = acl != null ? ImmutableList.copyOf(acl) : null;
            if (!Objects.equals(this.acl, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.ACL);
            }
            this.acl = tmp;
            return this;
        }

        @Override
        public Builder setDefaultAcl(Iterable<Acl> acl) {
            ImmutableList tmp;
            ImmutableList immutableList = tmp = acl != null ? ImmutableList.copyOf(acl) : null;
            if (!Objects.equals(this.defaultAcl, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.DEFAULT_OBJECT_ACL);
            }
            this.defaultAcl = tmp;
            return this;
        }

        @Override
        public Builder setLabels(@Nullable Map<@NonNull String, @Nullable String> labels) {
            Map<String, String> left = this.labels;
            Map<String, String> right = labels;
            if (!Objects.equals(left, right)) {
                Utils.diffMaps(Storage.BucketField.LABELS, left, right, arg_0 -> this.modifiedFields.add(arg_0));
                this.labels = right != null ? new HashMap<String, String>(right) : (Map)Data.nullOf(BlobInfo.ImmutableEmptyMap.class);
            }
            return this;
        }

        @Override
        public Builder setDefaultKmsKeyName(String defaultKmsKeyName) {
            String tmp;
            String string = tmp = defaultKmsKeyName != null ? defaultKmsKeyName : (String)Data.nullOf(String.class);
            if (!Objects.equals(this.defaultKmsKeyName, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.ENCRYPTION);
            }
            this.defaultKmsKeyName = tmp;
            return this;
        }

        @Override
        public Builder setDefaultEventBasedHold(Boolean defaultEventBasedHold) {
            Boolean tmp = (Boolean)MoreObjects.firstNonNull((Object)defaultEventBasedHold, (Object)((Boolean)Data.nullOf(Boolean.class)));
            if (!Objects.equals(this.defaultEventBasedHold, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.DEFAULT_EVENT_BASED_HOLD);
            }
            this.defaultEventBasedHold = tmp;
            return this;
        }

        @Override
        @Deprecated
        Builder setRetentionEffectiveTime(Long retentionEffectiveTime) {
            return this.setRetentionEffectiveTimeOffsetDateTime((OffsetDateTime)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.encode(retentionEffectiveTime));
        }

        @Override
        Builder setRetentionEffectiveTimeOffsetDateTime(OffsetDateTime retentionEffectiveTime) {
            if (!Objects.equals(this.retentionEffectiveTime, retentionEffectiveTime)) {
                this.modifiedFields.add((Object)Storage.BucketField.RETENTION_POLICY);
            }
            this.retentionEffectiveTime = retentionEffectiveTime;
            return this;
        }

        @Override
        Builder setRetentionPolicyIsLocked(Boolean retentionPolicyIsLocked) {
            Boolean tmp = (Boolean)MoreObjects.firstNonNull((Object)retentionPolicyIsLocked, (Object)((Boolean)Data.nullOf(Boolean.class)));
            if (!Objects.equals(this.retentionPolicyIsLocked, retentionPolicyIsLocked)) {
                this.modifiedFields.add((Object)Storage.BucketField.RETENTION_POLICY);
            }
            this.retentionPolicyIsLocked = tmp;
            return this;
        }

        @Override
        public Builder setRetentionPeriod(Long retentionPeriod) {
            return this.setRetentionPeriodDuration((Duration)BackwardCompatibilityUtils.nullableDurationSecondsCodec.decode(retentionPeriod));
        }

        @Override
        public Builder setRetentionPeriodDuration(Duration retentionPeriod) {
            if (!Objects.equals(this.retentionPeriod, retentionPeriod)) {
                this.modifiedFields.add((Object)Storage.BucketField.RETENTION_POLICY);
            }
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Override
        public Builder setIamConfiguration(IamConfiguration iamConfiguration) {
            if (!Objects.equals(this.iamConfiguration, iamConfiguration)) {
                this.modifiedFields.add((Object)Storage.BucketField.IAMCONFIGURATION);
            }
            this.iamConfiguration = iamConfiguration;
            return this;
        }

        @Override
        public Builder setAutoclass(Autoclass autoclass) {
            if (!Objects.equals(this.autoclass, autoclass)) {
                this.modifiedFields.add((Object)Storage.BucketField.AUTOCLASS);
            }
            this.autoclass = autoclass;
            return this;
        }

        @Override
        public Builder setLogging(Logging logging) {
            Logging tmp;
            Logging logging2 = tmp = logging != null ? logging : Logging.newBuilder().build();
            if (!Objects.equals(this.logging, tmp)) {
                this.modifiedFields.add((Object)Storage.BucketField.LOGGING);
            }
            this.logging = tmp;
            return this;
        }

        @Override
        public Builder setCustomPlacementConfig(CustomPlacementConfig customPlacementConfig) {
            if (!Objects.equals(this.customPlacementConfig, customPlacementConfig)) {
                this.modifiedFields.add((Object)Storage.BucketField.CUSTOM_PLACEMENT_CONFIG);
            }
            this.customPlacementConfig = customPlacementConfig;
            return this;
        }

        @Override
        Builder setObjectRetention(ObjectRetention objectRetention) {
            if (!Objects.equals(this.objectRetention, objectRetention)) {
                this.modifiedFields.add((Object)Storage.BucketField.OBJECT_RETENTION);
            }
            this.objectRetention = objectRetention;
            return this;
        }

        @Override
        public Builder setSoftDeletePolicy(SoftDeletePolicy softDeletePolicy) {
            if (!Objects.equals(this.softDeletePolicy, softDeletePolicy)) {
                this.modifiedFields.add((Object)Storage.BucketField.SOFT_DELETE_POLICY);
            }
            this.softDeletePolicy = softDeletePolicy;
            return this;
        }

        @Override
        public Builder setHierarchicalNamespace(HierarchicalNamespace hierarchicalNamespace) {
            if (!Objects.equals(this.hierarchicalNamespace, hierarchicalNamespace)) {
                this.modifiedFields.add((Object)Storage.BucketField.HIERARCHICAL_NAMESPACE);
            }
            this.hierarchicalNamespace = hierarchicalNamespace;
            return this;
        }

        @Override
        Builder setLocationType(String locationType) {
            if (!Objects.equals(this.locationType, locationType)) {
                this.modifiedFields.add((Object)Storage.BucketField.LOCATION_TYPE);
            }
            this.locationType = locationType;
            return this;
        }

        @Override
        public BucketInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new BucketInfo(this);
        }

        @Override
        BuilderImpl clearGeneratedId() {
            this.generatedId = null;
            return this;
        }

        @Override
        BuilderImpl clearProject() {
            this.project = null;
            return this;
        }

        @Override
        BuilderImpl clearName() {
            this.name = null;
            return this;
        }

        @Override
        BuilderImpl clearOwner() {
            this.owner = null;
            return this;
        }

        @Override
        BuilderImpl clearSelfLink() {
            this.selfLink = null;
            return this;
        }

        @Override
        BuilderImpl clearRequesterPays() {
            this.requesterPays = null;
            return this;
        }

        @Override
        BuilderImpl clearVersioningEnabled() {
            this.versioningEnabled = null;
            return this;
        }

        @Override
        BuilderImpl clearIndexPage() {
            this.indexPage = null;
            return this;
        }

        @Override
        BuilderImpl clearNotFoundPage() {
            this.notFoundPage = null;
            return this;
        }

        @Override
        BuilderImpl clearLifecycleRules() {
            this.lifecycleRules = null;
            return this;
        }

        @Override
        BuilderImpl clearRpo() {
            this.rpo = null;
            return this;
        }

        @Override
        BuilderImpl clearStorageClass() {
            this.storageClass = null;
            return this;
        }

        @Override
        BuilderImpl clearLocation() {
            this.location = null;
            return this;
        }

        @Override
        BuilderImpl clearEtag() {
            this.etag = null;
            return this;
        }

        @Override
        BuilderImpl clearCreateTime() {
            this.createTime = null;
            return this;
        }

        @Override
        BuilderImpl clearUpdateTime() {
            this.updateTime = null;
            return this;
        }

        @Override
        BuilderImpl clearMetageneration() {
            this.metageneration = null;
            return this;
        }

        @Override
        BuilderImpl clearCors() {
            this.cors = null;
            return this;
        }

        @Override
        BuilderImpl clearAcl() {
            this.acl = null;
            return this;
        }

        @Override
        BuilderImpl clearDefaultAcl() {
            this.defaultAcl = null;
            return this;
        }

        @Override
        BuilderImpl clearLabels() {
            this.labels = null;
            return this;
        }

        @Override
        BuilderImpl clearDefaultKmsKeyName() {
            this.defaultKmsKeyName = null;
            return this;
        }

        @Override
        BuilderImpl clearDefaultEventBasedHold() {
            this.defaultEventBasedHold = null;
            return this;
        }

        @Override
        BuilderImpl clearRetentionEffectiveTime() {
            this.retentionEffectiveTime = null;
            return this;
        }

        @Override
        BuilderImpl clearRetentionPolicyIsLocked() {
            this.retentionPolicyIsLocked = null;
            return this;
        }

        @Override
        BuilderImpl clearRetentionPeriod() {
            this.retentionPeriod = null;
            return this;
        }

        @Override
        BuilderImpl clearIamConfiguration() {
            this.iamConfiguration = null;
            return this;
        }

        @Override
        BuilderImpl clearLocationType() {
            this.locationType = null;
            return this;
        }

        @Override
        BuilderImpl clearLogging() {
            this.logging = null;
            return this;
        }

        @Override
        BuilderImpl clearCustomPlacementConfig() {
            this.customPlacementConfig = null;
            return this;
        }

        private Builder clearDeleteLifecycleRules() {
            if (this.lifecycleRules != null && !this.lifecycleRules.isEmpty()) {
                ImmutableList nonDeleteRules = (ImmutableList)this.lifecycleRules.stream().filter(IS_DELETE_LIFECYCLE_RULE.negate()).collect(ImmutableList.toImmutableList());
                return this.setLifecycleRules((Iterable<? extends LifecycleRule>)nonDeleteRules);
            }
            return this;
        }
    }

    public static abstract class Builder {
        Builder() {
        }

        abstract Builder setProject(BigInteger var1);

        public abstract Builder setName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setRequesterPays(Boolean var1);

        public abstract Builder setVersioningEnabled(Boolean var1);

        public abstract Builder setIndexPage(String var1);

        public abstract Builder setNotFoundPage(String var1);

        @Deprecated
        public abstract Builder setDeleteRules(Iterable<? extends DeleteRule> var1);

        public abstract Builder setLifecycleRules(Iterable<? extends LifecycleRule> var1);

        public abstract Builder deleteLifecycleRules();

        public abstract Builder setRpo(Rpo var1);

        public abstract Builder setStorageClass(StorageClass var1);

        public abstract Builder setLocation(String var1);

        abstract Builder setEtag(String var1);

        @Deprecated
        abstract Builder setCreateTime(Long var1);

        Builder setCreateTimeOffsetDateTime(OffsetDateTime createTime) {
            this.setCreateTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(createTime));
            return this;
        }

        @Deprecated
        abstract Builder setUpdateTime(Long var1);

        Builder setUpdateTimeOffsetDateTime(OffsetDateTime updateTime) {
            this.setCreateTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(updateTime));
            return this;
        }

        abstract Builder setMetageneration(Long var1);

        abstract Builder setLocationType(String var1);

        public abstract Builder setCors(Iterable<Cors> var1);

        public abstract Builder setAcl(Iterable<Acl> var1);

        public abstract Builder setDefaultAcl(Iterable<Acl> var1);

        public abstract Builder setLabels(@Nullable Map<@NonNull String, @Nullable String> var1);

        public abstract Builder setDefaultKmsKeyName(String var1);

        @BetaApi
        public abstract Builder setDefaultEventBasedHold(Boolean var1);

        @BetaApi
        @Deprecated
        abstract Builder setRetentionEffectiveTime(Long var1);

        @BetaApi
        Builder setRetentionEffectiveTimeOffsetDateTime(OffsetDateTime retentionEffectiveTime) {
            return this.setRetentionEffectiveTime((Long)BackwardCompatibilityUtils.millisOffsetDateTimeCodec.decode(retentionEffectiveTime));
        }

        @BetaApi
        abstract Builder setRetentionPolicyIsLocked(Boolean var1);

        @BetaApi
        @Deprecated
        public abstract Builder setRetentionPeriod(Long var1);

        @BetaApi
        public Builder setRetentionPeriodDuration(Duration retentionPeriod) {
            return this.setRetentionPeriod((Long)BackwardCompatibilityUtils.nullableDurationSecondsCodec.encode(retentionPeriod));
        }

        @BetaApi
        public abstract Builder setIamConfiguration(IamConfiguration var1);

        public abstract Builder setAutoclass(Autoclass var1);

        public abstract Builder setLogging(Logging var1);

        public abstract Builder setCustomPlacementConfig(CustomPlacementConfig var1);

        public abstract Builder setHierarchicalNamespace(HierarchicalNamespace var1);

        abstract Builder setObjectRetention(ObjectRetention var1);

        public abstract Builder setSoftDeletePolicy(SoftDeletePolicy var1);

        public abstract BucketInfo build();

        abstract Builder clearGeneratedId();

        abstract Builder clearProject();

        abstract Builder clearName();

        abstract Builder clearOwner();

        abstract Builder clearSelfLink();

        abstract Builder clearRequesterPays();

        abstract Builder clearVersioningEnabled();

        abstract Builder clearIndexPage();

        abstract Builder clearNotFoundPage();

        abstract Builder clearLifecycleRules();

        abstract Builder clearRpo();

        abstract Builder clearStorageClass();

        abstract Builder clearLocation();

        abstract Builder clearEtag();

        abstract Builder clearCreateTime();

        abstract Builder clearUpdateTime();

        abstract Builder clearMetageneration();

        abstract Builder clearCors();

        abstract Builder clearAcl();

        abstract Builder clearDefaultAcl();

        abstract Builder clearLabels();

        abstract Builder clearDefaultKmsKeyName();

        abstract Builder clearDefaultEventBasedHold();

        abstract Builder clearRetentionEffectiveTime();

        abstract Builder clearRetentionPolicyIsLocked();

        abstract Builder clearRetentionPeriod();

        abstract Builder clearIamConfiguration();

        abstract Builder clearLocationType();

        abstract Builder clearLogging();

        abstract Builder clearCustomPlacementConfig();
    }

    public static class LifecycleRule
    implements Serializable {
        private static final long serialVersionUID = 8685745573894069326L;
        private final LifecycleAction lifecycleAction;
        private final LifecycleCondition lifecycleCondition;

        public LifecycleRule(LifecycleAction action, LifecycleCondition condition) {
            if (condition.getIsLive() == null && condition.getAge() == null && condition.getCreatedBefore() == null && condition.getMatchesStorageClass() == null && condition.getNumberOfNewerVersions() == null && condition.getDaysSinceNoncurrentTime() == null && condition.getNoncurrentTimeBefore() == null && condition.getCustomTimeBefore() == null && condition.getDaysSinceCustomTime() == null && condition.getMatchesPrefix() == null && condition.getMatchesSuffix() == null) {
                log.warning("Creating a lifecycle condition with no supported conditions:\n" + this + "\nAttempting to update with this rule may cause errors. Please update  to the latest version of google-cloud-storage");
            }
            this.lifecycleAction = action;
            this.lifecycleCondition = condition;
        }

        public LifecycleAction getAction() {
            return this.lifecycleAction;
        }

        public LifecycleCondition getCondition() {
            return this.lifecycleCondition;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lifecycleAction", (Object)this.lifecycleAction).add("lifecycleCondition", (Object)this.lifecycleCondition).toString();
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleAction, this.lifecycleCondition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LifecycleRule)) {
                return false;
            }
            LifecycleRule that = (LifecycleRule)o;
            return Objects.equals(this.lifecycleAction, that.lifecycleAction) && Objects.equals(this.lifecycleCondition, that.lifecycleCondition);
        }

        public static class LifecycleCondition
        implements Serializable {
            private static final long serialVersionUID = 7127585850045827932L;
            private final Integer age;
            private final OffsetDateTime createdBefore;
            private final Integer numberOfNewerVersions;
            private final Boolean isLive;
            private final List<StorageClass> matchesStorageClass;
            private final Integer daysSinceNoncurrentTime;
            private final OffsetDateTime noncurrentTimeBefore;
            private final OffsetDateTime customTimeBefore;
            private final Integer daysSinceCustomTime;
            private final List<String> matchesPrefix;
            private final List<String> matchesSuffix;

            private LifecycleCondition(Builder builder) {
                this.age = builder.age;
                this.createdBefore = builder.createdBefore;
                this.numberOfNewerVersions = builder.numberOfNewerVersions;
                this.isLive = builder.isLive;
                this.matchesStorageClass = builder.matchesStorageClass;
                this.daysSinceNoncurrentTime = builder.daysSinceNoncurrentTime;
                this.noncurrentTimeBefore = builder.noncurrentTimeBefore;
                this.customTimeBefore = builder.customTimeBefore;
                this.daysSinceCustomTime = builder.daysSinceCustomTime;
                this.matchesPrefix = builder.matchesPrefix;
                this.matchesSuffix = builder.matchesSuffix;
            }

            public Builder toBuilder() {
                return LifecycleCondition.newBuilder().setAge(this.age).setCreatedBeforeOffsetDateTime(this.createdBefore).setNumberOfNewerVersions(this.numberOfNewerVersions).setIsLive(this.isLive).setMatchesStorageClass(this.matchesStorageClass).setDaysSinceNoncurrentTime(this.daysSinceNoncurrentTime).setNoncurrentTimeBeforeOffsetDateTime(this.noncurrentTimeBefore).setCustomTimeBeforeOffsetDateTime(this.customTimeBefore).setDaysSinceCustomTime(this.daysSinceCustomTime).setMatchesPrefix(this.matchesPrefix).setMatchesSuffix(this.matchesSuffix);
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("age", (Object)this.age).add("createBefore", (Object)this.createdBefore).add("numberofNewerVersions", (Object)this.numberOfNewerVersions).add("isLive", (Object)this.isLive).add("matchesStorageClass", this.matchesStorageClass).add("daysSinceNoncurrentTime", (Object)this.daysSinceNoncurrentTime).add("noncurrentTimeBefore", (Object)this.noncurrentTimeBefore).add("customTimeBefore", (Object)this.customTimeBefore).add("daysSinceCustomTime", (Object)this.daysSinceCustomTime).add("matchesPrefix", this.matchesPrefix).add("matchesSuffix", this.matchesSuffix).toString();
            }

            public Integer getAge() {
                return this.age;
            }

            @Deprecated
            public DateTime getCreatedBefore() {
                return (DateTime)Utils.dateTimeCodec.nullable().encode(this.createdBefore);
            }

            public OffsetDateTime getCreatedBeforeOffsetDateTime() {
                return this.createdBefore;
            }

            public Integer getNumberOfNewerVersions() {
                return this.numberOfNewerVersions;
            }

            public Boolean getIsLive() {
                return this.isLive;
            }

            public List<StorageClass> getMatchesStorageClass() {
                return this.matchesStorageClass;
            }

            public Integer getDaysSinceNoncurrentTime() {
                return this.daysSinceNoncurrentTime;
            }

            @Deprecated
            public DateTime getNoncurrentTimeBefore() {
                return (DateTime)Utils.dateTimeCodec.nullable().encode(this.noncurrentTimeBefore);
            }

            public OffsetDateTime getNoncurrentTimeBeforeOffsetDateTime() {
                return this.noncurrentTimeBefore;
            }

            @Deprecated
            public DateTime getCustomTimeBefore() {
                return (DateTime)Utils.dateTimeCodec.nullable().encode(this.customTimeBefore);
            }

            public OffsetDateTime getCustomTimeBeforeOffsetDateTime() {
                return this.customTimeBefore;
            }

            public Integer getDaysSinceCustomTime() {
                return this.daysSinceCustomTime;
            }

            public List<String> getMatchesPrefix() {
                return this.matchesPrefix;
            }

            public List<String> getMatchesSuffix() {
                return this.matchesSuffix;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof LifecycleCondition)) {
                    return false;
                }
                LifecycleCondition that = (LifecycleCondition)o;
                return Objects.equals(this.age, that.age) && Objects.equals(this.createdBefore, that.createdBefore) && Objects.equals(this.numberOfNewerVersions, that.numberOfNewerVersions) && Objects.equals(this.isLive, that.isLive) && Objects.equals(this.matchesStorageClass, that.matchesStorageClass) && Objects.equals(this.daysSinceNoncurrentTime, that.daysSinceNoncurrentTime) && Objects.equals(this.noncurrentTimeBefore, that.noncurrentTimeBefore) && Objects.equals(this.customTimeBefore, that.customTimeBefore) && Objects.equals(this.daysSinceCustomTime, that.daysSinceCustomTime) && Objects.equals(this.matchesPrefix, that.matchesPrefix) && Objects.equals(this.matchesSuffix, that.matchesSuffix);
            }

            public int hashCode() {
                return Objects.hash(this.age, this.createdBefore, this.numberOfNewerVersions, this.isLive, this.matchesStorageClass, this.daysSinceNoncurrentTime, this.noncurrentTimeBefore, this.customTimeBefore, this.daysSinceCustomTime, this.matchesPrefix, this.matchesSuffix);
            }

            public static class Builder {
                private Integer age;
                private OffsetDateTime createdBefore;
                private Integer numberOfNewerVersions;
                private Boolean isLive;
                private List<StorageClass> matchesStorageClass;
                private Integer daysSinceNoncurrentTime;
                private OffsetDateTime noncurrentTimeBefore;
                private OffsetDateTime customTimeBefore;
                private Integer daysSinceCustomTime;
                private List<String> matchesPrefix;
                private List<String> matchesSuffix;

                private Builder() {
                }

                public Builder setAge(Integer age) {
                    this.age = age;
                    return this;
                }

                @Deprecated
                public Builder setCreatedBefore(DateTime createdBefore) {
                    return this.setCreatedBeforeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.nullable().decode(createdBefore));
                }

                public Builder setCreatedBeforeOffsetDateTime(OffsetDateTime createdBefore) {
                    this.createdBefore = createdBefore;
                    return this;
                }

                public Builder setNumberOfNewerVersions(Integer numberOfNewerVersions) {
                    this.numberOfNewerVersions = numberOfNewerVersions;
                    return this;
                }

                public Builder setIsLive(Boolean live) {
                    this.isLive = live;
                    return this;
                }

                public Builder setMatchesStorageClass(List<StorageClass> matchesStorageClass) {
                    this.matchesStorageClass = matchesStorageClass;
                    return this;
                }

                public Builder setDaysSinceNoncurrentTime(Integer daysSinceNoncurrentTime) {
                    this.daysSinceNoncurrentTime = daysSinceNoncurrentTime;
                    return this;
                }

                @Deprecated
                public Builder setNoncurrentTimeBefore(DateTime noncurrentTimeBefore) {
                    return this.setNoncurrentTimeBeforeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.nullable().decode(noncurrentTimeBefore));
                }

                public Builder setNoncurrentTimeBeforeOffsetDateTime(OffsetDateTime noncurrentTimeBefore) {
                    this.noncurrentTimeBefore = noncurrentTimeBefore;
                    return this;
                }

                @Deprecated
                public Builder setCustomTimeBefore(DateTime customTimeBefore) {
                    return this.setCustomTimeBeforeOffsetDateTime((OffsetDateTime)Utils.dateTimeCodec.nullable().decode(customTimeBefore));
                }

                public Builder setCustomTimeBeforeOffsetDateTime(OffsetDateTime customTimeBefore) {
                    this.customTimeBefore = customTimeBefore;
                    return this;
                }

                public Builder setDaysSinceCustomTime(Integer daysSinceCustomTime) {
                    this.daysSinceCustomTime = daysSinceCustomTime;
                    return this;
                }

                public Builder setMatchesPrefix(List<String> matchesPrefix) {
                    this.matchesPrefix = matchesPrefix != null ? ImmutableList.copyOf(matchesPrefix) : null;
                    return this;
                }

                public Builder setMatchesSuffix(List<String> matchesSuffix) {
                    this.matchesSuffix = matchesSuffix != null ? ImmutableList.copyOf(matchesSuffix) : null;
                    return this;
                }

                public LifecycleCondition build() {
                    return new LifecycleCondition(this);
                }
            }
        }

        public static class LifecycleAction
        implements Serializable {
            private static final long serialVersionUID = -816170697779323819L;
            private final String actionType;

            public LifecycleAction(String actionType) {
                this.actionType = actionType;
            }

            public String getActionType() {
                return this.actionType;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("actionType", (Object)this.getActionType()).toString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof LifecycleAction)) {
                    return false;
                }
                LifecycleAction that = (LifecycleAction)o;
                return Objects.equals(this.actionType, that.actionType);
            }

            public int hashCode() {
                return Objects.hash(this.actionType);
            }

            public static DeleteLifecycleAction newDeleteAction() {
                return new DeleteLifecycleAction();
            }

            public static SetStorageClassLifecycleAction newSetStorageClassAction(@NonNull StorageClass storageClass) {
                return new SetStorageClassLifecycleAction(storageClass);
            }

            public static LifecycleAction newAbortIncompleteMPUploadAction() {
                return new AbortIncompleteMPUAction();
            }

            public static LifecycleAction newLifecycleAction(@NonNull String actionType) {
                return new LifecycleAction(actionType);
            }
        }

        public static class AbortIncompleteMPUAction
        extends LifecycleAction {
            public static final String TYPE = "AbortIncompleteMultipartUpload";
            private static final long serialVersionUID = 8158049841366366988L;

            private AbortIncompleteMPUAction() {
                super(TYPE);
            }
        }

        public static class SetStorageClassLifecycleAction
        extends LifecycleAction {
            public static final String TYPE = "SetStorageClass";
            private static final long serialVersionUID = 1235008830965208895L;
            private final StorageClass storageClass;

            private SetStorageClassLifecycleAction(StorageClass storageClass) {
                super(TYPE);
                this.storageClass = storageClass;
            }

            @Override
            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("actionType", (Object)this.getActionType()).add("storageClass", (Object)this.storageClass.name()).toString();
            }

            public StorageClass getStorageClass() {
                return this.storageClass;
            }
        }

        public static class DeleteLifecycleAction
        extends LifecycleAction {
            public static final String TYPE = "Delete";
            private static final long serialVersionUID = 4235058923106460876L;

            private DeleteLifecycleAction() {
                super(TYPE);
            }
        }
    }

    @Deprecated
    public static class IsLiveDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 6769701586197631153L;
        private final boolean isLive;

        public IsLiveDeleteRule(boolean isLive) {
            super(DeleteRule.Type.IS_LIVE);
            this.isLive = isLive;
        }

        public boolean isLive() {
            return this.isLive;
        }
    }

    @Deprecated
    public static class NumNewerVersionsDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 8984956956307794724L;
        private final int numNewerVersions;

        public NumNewerVersionsDeleteRule(int numNewerVersions) {
            super(DeleteRule.Type.NUM_NEWER_VERSIONS);
            this.numNewerVersions = numNewerVersions;
        }

        public int getNumNewerVersions() {
            return this.numNewerVersions;
        }
    }

    @Deprecated
    public static class CreatedBeforeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -2941931783781989505L;
        private final OffsetDateTime time;

        @Deprecated
        public CreatedBeforeDeleteRule(long timeMillis) {
            this((OffsetDateTime)BackwardCompatibilityUtils.millisUtcCodec.encode(timeMillis));
        }

        public CreatedBeforeDeleteRule(OffsetDateTime time) {
            super(DeleteRule.Type.CREATE_BEFORE);
            this.time = time;
        }

        @Deprecated
        public long getTimeMillis() {
            return (Long)BackwardCompatibilityUtils.millisUtcCodec.decode(this.time);
        }

        public OffsetDateTime getTime() {
            return this.time;
        }
    }

    static class RawDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -3490275955461147025L;
        private transient Bucket.Lifecycle.Rule rule;

        RawDeleteRule(Bucket.Lifecycle.Rule rule) {
            super(DeleteRule.Type.UNKNOWN);
            this.rule = rule;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeUTF(this.rule.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rule = (Bucket.Lifecycle.Rule)new JacksonFactory().fromString(in.readUTF(), Bucket.Lifecycle.Rule.class);
        }

        Bucket.Lifecycle.Rule getRule() {
            return this.rule;
        }
    }

    @Deprecated
    public static class AgeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 8655342969048652720L;
        private final int daysToLive;

        public AgeDeleteRule(int daysToLive) {
            super(DeleteRule.Type.AGE);
            this.daysToLive = daysToLive;
        }

        public int getDaysToLive() {
            return this.daysToLive;
        }
    }

    @Deprecated
    public static abstract class DeleteRule
    implements Serializable {
        private static final long serialVersionUID = -2831684017163653163L;
        static final String SUPPORTED_ACTION = "Delete";
        private final Type type;

        DeleteRule(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteRule)) {
                return false;
            }
            DeleteRule that = (DeleteRule)o;
            return this.type == that.type;
        }

        public static enum Type {
            AGE,
            CREATE_BEFORE,
            NUM_NEWER_VERSIONS,
            IS_LIVE,
            UNKNOWN;

        }
    }

    public static enum PublicAccessPrevention {
        ENFORCED("enforced"),
        UNSPECIFIED("inherited"),
        UNKNOWN(null),
        INHERITED("inherited");

        private final String value;

        private PublicAccessPrevention(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static PublicAccessPrevention parse(String value) {
            String upper;
            switch (upper = value.toUpperCase()) {
                case "ENFORCED": {
                    return ENFORCED;
                }
                case "UNSPECIFIED": 
                case "INHERITED": {
                    return INHERITED;
                }
            }
            return UNKNOWN;
        }
    }
}

