/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.api.core.BetaApi;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.multipartupload.model.Part;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

@BetaApi
public final class ListPartsResponse {
    @JacksonXmlProperty(localName="Bucket")
    private String bucket;
    @JacksonXmlProperty(localName="Key")
    private String key;
    @JacksonXmlProperty(localName="UploadId")
    private String uploadId;
    @JacksonXmlProperty(localName="PartNumberMarker")
    private int partNumberMarker;
    @JacksonXmlProperty(localName="NextPartNumberMarker")
    private int nextPartNumberMarker;
    @JacksonXmlProperty(localName="MaxParts")
    private int maxParts;
    @JsonAlias(value={"truncated"})
    @JacksonXmlProperty(localName="IsTruncated")
    private boolean isTruncated;
    @JacksonXmlProperty(localName="StorageClass")
    private StorageClass storageClass;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="Part")
    private List<Part> parts;

    private ListPartsResponse() {
    }

    private ListPartsResponse(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.partNumberMarker = builder.partNumberMarker;
        this.nextPartNumberMarker = builder.nextPartNumberMarker;
        this.maxParts = builder.maxParts;
        this.isTruncated = builder.isTruncated;
        this.storageClass = builder.storageClass;
        this.parts = builder.parts;
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public String getBucket() {
        return this.bucket;
    }

    @BetaApi
    public String getKey() {
        return this.key;
    }

    @BetaApi
    public String getUploadId() {
        return this.uploadId;
    }

    @BetaApi
    public int getPartNumberMarker() {
        return this.partNumberMarker;
    }

    @BetaApi
    public int getNextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    @BetaApi
    public int getMaxParts() {
        return this.maxParts;
    }

    @BetaApi
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @BetaApi
    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    @BetaApi
    public List<Part> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse that = (ListPartsResponse)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.partNumberMarker, that.partNumberMarker) && Objects.equals(this.nextPartNumberMarker, that.nextPartNumberMarker) && Objects.equals(this.maxParts, that.maxParts) && Objects.equals(this.isTruncated, that.isTruncated) && Objects.equals((Object)this.storageClass, (Object)that.storageClass) && Objects.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.key, this.uploadId, this.partNumberMarker, this.nextPartNumberMarker, this.maxParts, this.isTruncated, this.storageClass, this.parts});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("uploadId", (Object)this.uploadId).add("partNumberMarker", this.partNumberMarker).add("nextPartNumberMarker", this.nextPartNumberMarker).add("maxParts", this.maxParts).add("isTruncated", this.isTruncated).add("storageClass", (Object)this.storageClass).add("parts", this.parts).toString();
    }

    @BetaApi
    public static final class Builder {
        private String bucket;
        private String key;
        private String uploadId;
        private int partNumberMarker;
        private int nextPartNumberMarker;
        private int maxParts;
        private boolean isTruncated;
        private StorageClass storageClass;
        private List<Part> parts;

        private Builder() {
        }

        @BetaApi
        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder setUploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @BetaApi
        public Builder setPartNumberMarker(int partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        @BetaApi
        public Builder setNextPartNumberMarker(int nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            return this;
        }

        @BetaApi
        public Builder setMaxParts(int maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        @BetaApi
        public Builder setIsTruncated(boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        @BetaApi
        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @BetaApi
        public Builder setParts(List<Part> parts) {
            this.parts = parts;
            return this;
        }

        @BetaApi
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }
    }
}

