/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vmwareengine.v1.Cluster;
import com.google.cloud.vmwareengine.v1.ClusterName;
import com.google.cloud.vmwareengine.v1.CreateClusterRequest;
import com.google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest;
import com.google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.CreatePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.Credentials;
import com.google.cloud.vmwareengine.v1.DeleteClusterRequest;
import com.google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.DeletePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.GetClusterRequest;
import com.google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest;
import com.google.cloud.vmwareengine.v1.GetNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.GetNodeTypeRequest;
import com.google.cloud.vmwareengine.v1.GetPrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.GetPrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.GetSubnetRequest;
import com.google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.HcxActivationKey;
import com.google.cloud.vmwareengine.v1.HcxActivationKeyName;
import com.google.cloud.vmwareengine.v1.ListClustersRequest;
import com.google.cloud.vmwareengine.v1.ListClustersResponse;
import com.google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest;
import com.google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse;
import com.google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest;
import com.google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse;
import com.google.cloud.vmwareengine.v1.ListNodeTypesRequest;
import com.google.cloud.vmwareengine.v1.ListNodeTypesResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateCloudsRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateCloudsResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionsResponse;
import com.google.cloud.vmwareengine.v1.ListSubnetsRequest;
import com.google.cloud.vmwareengine.v1.ListSubnetsResponse;
import com.google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest;
import com.google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse;
import com.google.cloud.vmwareengine.v1.LocationName;
import com.google.cloud.vmwareengine.v1.NetworkPolicy;
import com.google.cloud.vmwareengine.v1.NetworkPolicyName;
import com.google.cloud.vmwareengine.v1.NodeType;
import com.google.cloud.vmwareengine.v1.NodeTypeName;
import com.google.cloud.vmwareengine.v1.OperationMetadata;
import com.google.cloud.vmwareengine.v1.PeeringRoute;
import com.google.cloud.vmwareengine.v1.PrivateCloud;
import com.google.cloud.vmwareengine.v1.PrivateCloudName;
import com.google.cloud.vmwareengine.v1.PrivateConnection;
import com.google.cloud.vmwareengine.v1.PrivateConnectionName;
import com.google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest;
import com.google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest;
import com.google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest;
import com.google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest;
import com.google.cloud.vmwareengine.v1.Subnet;
import com.google.cloud.vmwareengine.v1.SubnetName;
import com.google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.UpdateClusterRequest;
import com.google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.UpdateSubnetRequest;
import com.google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.VmwareEngineNetwork;
import com.google.cloud.vmwareengine.v1.VmwareEngineNetworkName;
import com.google.cloud.vmwareengine.v1.VmwareEngineSettings;
import com.google.cloud.vmwareengine.v1.stub.VmwareEngineStub;
import com.google.cloud.vmwareengine.v1.stub.VmwareEngineStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VmwareEngineClient
implements BackgroundResource {
    private final VmwareEngineSettings settings;
    private final VmwareEngineStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final VmwareEngineClient create() throws IOException {
        return VmwareEngineClient.create(VmwareEngineSettings.newBuilder().build());
    }

    public static final VmwareEngineClient create(VmwareEngineSettings settings) throws IOException {
        return new VmwareEngineClient(settings);
    }

    public static final VmwareEngineClient create(VmwareEngineStub stub) {
        return new VmwareEngineClient(stub);
    }

    protected VmwareEngineClient(VmwareEngineSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VmwareEngineStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected VmwareEngineClient(VmwareEngineStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final VmwareEngineSettings getSettings() {
        return this.settings;
    }

    public VmwareEngineStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(LocationName parent) {
        ListPrivateCloudsRequest request = ListPrivateCloudsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateClouds(request);
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(String parent) {
        ListPrivateCloudsRequest request = ListPrivateCloudsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateClouds(request);
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(ListPrivateCloudsRequest request) {
        return (ListPrivateCloudsPagedResponse)((Object)this.listPrivateCloudsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateCloudsRequest, ListPrivateCloudsPagedResponse> listPrivateCloudsPagedCallable() {
        return this.stub.listPrivateCloudsPagedCallable();
    }

    public final UnaryCallable<ListPrivateCloudsRequest, ListPrivateCloudsResponse> listPrivateCloudsCallable() {
        return this.stub.listPrivateCloudsCallable();
    }

    public final PrivateCloud getPrivateCloud(PrivateCloudName name) {
        GetPrivateCloudRequest request = GetPrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateCloud(request);
    }

    public final PrivateCloud getPrivateCloud(String name) {
        GetPrivateCloudRequest request = GetPrivateCloudRequest.newBuilder().setName(name).build();
        return this.getPrivateCloud(request);
    }

    public final PrivateCloud getPrivateCloud(GetPrivateCloudRequest request) {
        return (PrivateCloud)this.getPrivateCloudCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateCloudRequest, PrivateCloud> getPrivateCloudCallable() {
        return this.stub.getPrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(LocationName parent, PrivateCloud privateCloud, String privateCloudId) {
        CreatePrivateCloudRequest request = CreatePrivateCloudRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateCloud(privateCloud).setPrivateCloudId(privateCloudId).build();
        return this.createPrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(String parent, PrivateCloud privateCloud, String privateCloudId) {
        CreatePrivateCloudRequest request = CreatePrivateCloudRequest.newBuilder().setParent(parent).setPrivateCloud(privateCloud).setPrivateCloudId(privateCloudId).build();
        return this.createPrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(CreatePrivateCloudRequest request) {
        return this.createPrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateCloudRequest, PrivateCloud, OperationMetadata> createPrivateCloudOperationCallable() {
        return this.stub.createPrivateCloudOperationCallable();
    }

    public final UnaryCallable<CreatePrivateCloudRequest, Operation> createPrivateCloudCallable() {
        return this.stub.createPrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> updatePrivateCloudAsync(PrivateCloud privateCloud, FieldMask updateMask) {
        UpdatePrivateCloudRequest request = UpdatePrivateCloudRequest.newBuilder().setPrivateCloud(privateCloud).setUpdateMask(updateMask).build();
        return this.updatePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> updatePrivateCloudAsync(UpdatePrivateCloudRequest request) {
        return this.updatePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePrivateCloudRequest, PrivateCloud, OperationMetadata> updatePrivateCloudOperationCallable() {
        return this.stub.updatePrivateCloudOperationCallable();
    }

    public final UnaryCallable<UpdatePrivateCloudRequest, Operation> updatePrivateCloudCallable() {
        return this.stub.updatePrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(PrivateCloudName name) {
        DeletePrivateCloudRequest request = DeletePrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(String name) {
        DeletePrivateCloudRequest request = DeletePrivateCloudRequest.newBuilder().setName(name).build();
        return this.deletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(DeletePrivateCloudRequest request) {
        return this.deletePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateCloudRequest, PrivateCloud, OperationMetadata> deletePrivateCloudOperationCallable() {
        return this.stub.deletePrivateCloudOperationCallable();
    }

    public final UnaryCallable<DeletePrivateCloudRequest, Operation> deletePrivateCloudCallable() {
        return this.stub.deletePrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(PrivateCloudName name) {
        UndeletePrivateCloudRequest request = UndeletePrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(String name) {
        UndeletePrivateCloudRequest request = UndeletePrivateCloudRequest.newBuilder().setName(name).build();
        return this.undeletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(UndeletePrivateCloudRequest request) {
        return this.undeletePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeletePrivateCloudRequest, PrivateCloud, OperationMetadata> undeletePrivateCloudOperationCallable() {
        return this.stub.undeletePrivateCloudOperationCallable();
    }

    public final UnaryCallable<UndeletePrivateCloudRequest, Operation> undeletePrivateCloudCallable() {
        return this.stub.undeletePrivateCloudCallable();
    }

    public final ListClustersPagedResponse listClusters(PrivateCloudName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(PrivateCloudName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final ListSubnetsPagedResponse listSubnets(PrivateCloudName parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(String parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(ListSubnetsRequest request) {
        return (ListSubnetsPagedResponse)((Object)this.listSubnetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsPagedResponse> listSubnetsPagedCallable() {
        return this.stub.listSubnetsPagedCallable();
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsResponse> listSubnetsCallable() {
        return this.stub.listSubnetsCallable();
    }

    public final Subnet getSubnet(SubnetName name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(String name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(GetSubnetRequest request) {
        return (Subnet)this.getSubnetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubnetRequest, Subnet> getSubnetCallable() {
        return this.stub.getSubnetCallable();
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(Subnet subnet, FieldMask updateMask) {
        UpdateSubnetRequest request = UpdateSubnetRequest.newBuilder().setSubnet(subnet).setUpdateMask(updateMask).build();
        return this.updateSubnetAsync(request);
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(UpdateSubnetRequest request) {
        return this.updateSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationCallable() {
        return this.stub.updateSubnetOperationCallable();
    }

    public final UnaryCallable<UpdateSubnetRequest, Operation> updateSubnetCallable() {
        return this.stub.updateSubnetCallable();
    }

    public final ListNodeTypesPagedResponse listNodeTypes(LocationName parent) {
        ListNodeTypesRequest request = ListNodeTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodeTypes(request);
    }

    public final ListNodeTypesPagedResponse listNodeTypes(String parent) {
        ListNodeTypesRequest request = ListNodeTypesRequest.newBuilder().setParent(parent).build();
        return this.listNodeTypes(request);
    }

    public final ListNodeTypesPagedResponse listNodeTypes(ListNodeTypesRequest request) {
        return (ListNodeTypesPagedResponse)((Object)this.listNodeTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodeTypesRequest, ListNodeTypesPagedResponse> listNodeTypesPagedCallable() {
        return this.stub.listNodeTypesPagedCallable();
    }

    public final UnaryCallable<ListNodeTypesRequest, ListNodeTypesResponse> listNodeTypesCallable() {
        return this.stub.listNodeTypesCallable();
    }

    public final NodeType getNodeType(NodeTypeName name) {
        GetNodeTypeRequest request = GetNodeTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNodeType(request);
    }

    public final NodeType getNodeType(String name) {
        GetNodeTypeRequest request = GetNodeTypeRequest.newBuilder().setName(name).build();
        return this.getNodeType(request);
    }

    public final NodeType getNodeType(GetNodeTypeRequest request) {
        return (NodeType)this.getNodeTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeTypeRequest, NodeType> getNodeTypeCallable() {
        return this.stub.getNodeTypeCallable();
    }

    public final Credentials showNsxCredentials(PrivateCloudName privateCloud) {
        ShowNsxCredentialsRequest request = ShowNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.showNsxCredentials(request);
    }

    public final Credentials showNsxCredentials(String privateCloud) {
        ShowNsxCredentialsRequest request = ShowNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.showNsxCredentials(request);
    }

    public final Credentials showNsxCredentials(ShowNsxCredentialsRequest request) {
        return (Credentials)this.showNsxCredentialsCallable().call((Object)request);
    }

    public final UnaryCallable<ShowNsxCredentialsRequest, Credentials> showNsxCredentialsCallable() {
        return this.stub.showNsxCredentialsCallable();
    }

    public final Credentials showVcenterCredentials(PrivateCloudName privateCloud) {
        ShowVcenterCredentialsRequest request = ShowVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.showVcenterCredentials(request);
    }

    public final Credentials showVcenterCredentials(String privateCloud) {
        ShowVcenterCredentialsRequest request = ShowVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.showVcenterCredentials(request);
    }

    public final Credentials showVcenterCredentials(ShowVcenterCredentialsRequest request) {
        return (Credentials)this.showVcenterCredentialsCallable().call((Object)request);
    }

    public final UnaryCallable<ShowVcenterCredentialsRequest, Credentials> showVcenterCredentialsCallable() {
        return this.stub.showVcenterCredentialsCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(PrivateCloudName privateCloud) {
        ResetNsxCredentialsRequest request = ResetNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.resetNsxCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(String privateCloud) {
        ResetNsxCredentialsRequest request = ResetNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.resetNsxCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(ResetNsxCredentialsRequest request) {
        return this.resetNsxCredentialsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetNsxCredentialsRequest, PrivateCloud, OperationMetadata> resetNsxCredentialsOperationCallable() {
        return this.stub.resetNsxCredentialsOperationCallable();
    }

    public final UnaryCallable<ResetNsxCredentialsRequest, Operation> resetNsxCredentialsCallable() {
        return this.stub.resetNsxCredentialsCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(PrivateCloudName privateCloud) {
        ResetVcenterCredentialsRequest request = ResetVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.resetVcenterCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(String privateCloud) {
        ResetVcenterCredentialsRequest request = ResetVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.resetVcenterCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(ResetVcenterCredentialsRequest request) {
        return this.resetVcenterCredentialsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetVcenterCredentialsRequest, PrivateCloud, OperationMetadata> resetVcenterCredentialsOperationCallable() {
        return this.stub.resetVcenterCredentialsOperationCallable();
    }

    public final UnaryCallable<ResetVcenterCredentialsRequest, Operation> resetVcenterCredentialsCallable() {
        return this.stub.resetVcenterCredentialsCallable();
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(PrivateCloudName parent, HcxActivationKey hcxActivationKey, String hcxActivationKeyId) {
        CreateHcxActivationKeyRequest request = CreateHcxActivationKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHcxActivationKey(hcxActivationKey).setHcxActivationKeyId(hcxActivationKeyId).build();
        return this.createHcxActivationKeyAsync(request);
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(String parent, HcxActivationKey hcxActivationKey, String hcxActivationKeyId) {
        CreateHcxActivationKeyRequest request = CreateHcxActivationKeyRequest.newBuilder().setParent(parent).setHcxActivationKey(hcxActivationKey).setHcxActivationKeyId(hcxActivationKeyId).build();
        return this.createHcxActivationKeyAsync(request);
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(CreateHcxActivationKeyRequest request) {
        return this.createHcxActivationKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHcxActivationKeyRequest, HcxActivationKey, OperationMetadata> createHcxActivationKeyOperationCallable() {
        return this.stub.createHcxActivationKeyOperationCallable();
    }

    public final UnaryCallable<CreateHcxActivationKeyRequest, Operation> createHcxActivationKeyCallable() {
        return this.stub.createHcxActivationKeyCallable();
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(PrivateCloudName parent) {
        ListHcxActivationKeysRequest request = ListHcxActivationKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHcxActivationKeys(request);
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(String parent) {
        ListHcxActivationKeysRequest request = ListHcxActivationKeysRequest.newBuilder().setParent(parent).build();
        return this.listHcxActivationKeys(request);
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(ListHcxActivationKeysRequest request) {
        return (ListHcxActivationKeysPagedResponse)((Object)this.listHcxActivationKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHcxActivationKeysRequest, ListHcxActivationKeysPagedResponse> listHcxActivationKeysPagedCallable() {
        return this.stub.listHcxActivationKeysPagedCallable();
    }

    public final UnaryCallable<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse> listHcxActivationKeysCallable() {
        return this.stub.listHcxActivationKeysCallable();
    }

    public final HcxActivationKey getHcxActivationKey(HcxActivationKeyName name) {
        GetHcxActivationKeyRequest request = GetHcxActivationKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHcxActivationKey(request);
    }

    public final HcxActivationKey getHcxActivationKey(String name) {
        GetHcxActivationKeyRequest request = GetHcxActivationKeyRequest.newBuilder().setName(name).build();
        return this.getHcxActivationKey(request);
    }

    public final HcxActivationKey getHcxActivationKey(GetHcxActivationKeyRequest request) {
        return (HcxActivationKey)this.getHcxActivationKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetHcxActivationKeyRequest, HcxActivationKey> getHcxActivationKeyCallable() {
        return this.stub.getHcxActivationKeyCallable();
    }

    public final NetworkPolicy getNetworkPolicy(NetworkPolicyName name) {
        GetNetworkPolicyRequest request = GetNetworkPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetworkPolicy(request);
    }

    public final NetworkPolicy getNetworkPolicy(String name) {
        GetNetworkPolicyRequest request = GetNetworkPolicyRequest.newBuilder().setName(name).build();
        return this.getNetworkPolicy(request);
    }

    public final NetworkPolicy getNetworkPolicy(GetNetworkPolicyRequest request) {
        return (NetworkPolicy)this.getNetworkPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkPolicyRequest, NetworkPolicy> getNetworkPolicyCallable() {
        return this.stub.getNetworkPolicyCallable();
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(LocationName parent) {
        ListNetworkPoliciesRequest request = ListNetworkPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworkPolicies(request);
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(String parent) {
        ListNetworkPoliciesRequest request = ListNetworkPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listNetworkPolicies(request);
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(ListNetworkPoliciesRequest request) {
        return (ListNetworkPoliciesPagedResponse)((Object)this.listNetworkPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkPoliciesRequest, ListNetworkPoliciesPagedResponse> listNetworkPoliciesPagedCallable() {
        return this.stub.listNetworkPoliciesPagedCallable();
    }

    public final UnaryCallable<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse> listNetworkPoliciesCallable() {
        return this.stub.listNetworkPoliciesCallable();
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(LocationName parent, NetworkPolicy networkPolicy, String networkPolicyId) {
        CreateNetworkPolicyRequest request = CreateNetworkPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNetworkPolicy(networkPolicy).setNetworkPolicyId(networkPolicyId).build();
        return this.createNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(String parent, NetworkPolicy networkPolicy, String networkPolicyId) {
        CreateNetworkPolicyRequest request = CreateNetworkPolicyRequest.newBuilder().setParent(parent).setNetworkPolicy(networkPolicy).setNetworkPolicyId(networkPolicyId).build();
        return this.createNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(CreateNetworkPolicyRequest request) {
        return this.createNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNetworkPolicyRequest, NetworkPolicy, OperationMetadata> createNetworkPolicyOperationCallable() {
        return this.stub.createNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<CreateNetworkPolicyRequest, Operation> createNetworkPolicyCallable() {
        return this.stub.createNetworkPolicyCallable();
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> updateNetworkPolicyAsync(NetworkPolicy networkPolicy, FieldMask updateMask) {
        UpdateNetworkPolicyRequest request = UpdateNetworkPolicyRequest.newBuilder().setNetworkPolicy(networkPolicy).setUpdateMask(updateMask).build();
        return this.updateNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> updateNetworkPolicyAsync(UpdateNetworkPolicyRequest request) {
        return this.updateNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNetworkPolicyRequest, NetworkPolicy, OperationMetadata> updateNetworkPolicyOperationCallable() {
        return this.stub.updateNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateNetworkPolicyRequest, Operation> updateNetworkPolicyCallable() {
        return this.stub.updateNetworkPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(NetworkPolicyName name) {
        DeleteNetworkPolicyRequest request = DeleteNetworkPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNetworkPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(String name) {
        DeleteNetworkPolicyRequest request = DeleteNetworkPolicyRequest.newBuilder().setName(name).build();
        return this.deleteNetworkPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(DeleteNetworkPolicyRequest request) {
        return this.deleteNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkPolicyRequest, Empty, OperationMetadata> deleteNetworkPolicyOperationCallable() {
        return this.stub.deleteNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkPolicyRequest, Operation> deleteNetworkPolicyCallable() {
        return this.stub.deleteNetworkPolicyCallable();
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(LocationName parent, VmwareEngineNetwork vmwareEngineNetwork, String vmwareEngineNetworkId) {
        CreateVmwareEngineNetworkRequest request = CreateVmwareEngineNetworkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVmwareEngineNetwork(vmwareEngineNetwork).setVmwareEngineNetworkId(vmwareEngineNetworkId).build();
        return this.createVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(String parent, VmwareEngineNetwork vmwareEngineNetwork, String vmwareEngineNetworkId) {
        CreateVmwareEngineNetworkRequest request = CreateVmwareEngineNetworkRequest.newBuilder().setParent(parent).setVmwareEngineNetwork(vmwareEngineNetwork).setVmwareEngineNetworkId(vmwareEngineNetworkId).build();
        return this.createVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(CreateVmwareEngineNetworkRequest request) {
        return this.createVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVmwareEngineNetworkRequest, VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkOperationCallable() {
        return this.stub.createVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<CreateVmwareEngineNetworkRequest, Operation> createVmwareEngineNetworkCallable() {
        return this.stub.createVmwareEngineNetworkCallable();
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkAsync(VmwareEngineNetwork vmwareEngineNetwork, FieldMask updateMask) {
        UpdateVmwareEngineNetworkRequest request = UpdateVmwareEngineNetworkRequest.newBuilder().setVmwareEngineNetwork(vmwareEngineNetwork).setUpdateMask(updateMask).build();
        return this.updateVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkAsync(UpdateVmwareEngineNetworkRequest request) {
        return this.updateVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVmwareEngineNetworkRequest, VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkOperationCallable() {
        return this.stub.updateVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<UpdateVmwareEngineNetworkRequest, Operation> updateVmwareEngineNetworkCallable() {
        return this.stub.updateVmwareEngineNetworkCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(VmwareEngineNetworkName name) {
        DeleteVmwareEngineNetworkRequest request = DeleteVmwareEngineNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(String name) {
        DeleteVmwareEngineNetworkRequest request = DeleteVmwareEngineNetworkRequest.newBuilder().setName(name).build();
        return this.deleteVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(DeleteVmwareEngineNetworkRequest request) {
        return this.deleteVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVmwareEngineNetworkRequest, Empty, OperationMetadata> deleteVmwareEngineNetworkOperationCallable() {
        return this.stub.deleteVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<DeleteVmwareEngineNetworkRequest, Operation> deleteVmwareEngineNetworkCallable() {
        return this.stub.deleteVmwareEngineNetworkCallable();
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(VmwareEngineNetworkName name) {
        GetVmwareEngineNetworkRequest request = GetVmwareEngineNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVmwareEngineNetwork(request);
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(String name) {
        GetVmwareEngineNetworkRequest request = GetVmwareEngineNetworkRequest.newBuilder().setName(name).build();
        return this.getVmwareEngineNetwork(request);
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(GetVmwareEngineNetworkRequest request) {
        return (VmwareEngineNetwork)this.getVmwareEngineNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetVmwareEngineNetworkRequest, VmwareEngineNetwork> getVmwareEngineNetworkCallable() {
        return this.stub.getVmwareEngineNetworkCallable();
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(LocationName parent) {
        ListVmwareEngineNetworksRequest request = ListVmwareEngineNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVmwareEngineNetworks(request);
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(String parent) {
        ListVmwareEngineNetworksRequest request = ListVmwareEngineNetworksRequest.newBuilder().setParent(parent).build();
        return this.listVmwareEngineNetworks(request);
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(ListVmwareEngineNetworksRequest request) {
        return (ListVmwareEngineNetworksPagedResponse)((Object)this.listVmwareEngineNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksPagedResponse> listVmwareEngineNetworksPagedCallable() {
        return this.stub.listVmwareEngineNetworksPagedCallable();
    }

    public final UnaryCallable<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse> listVmwareEngineNetworksCallable() {
        return this.stub.listVmwareEngineNetworksCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(LocationName parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(String parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(CreatePrivateConnectionRequest request) {
        return this.createPrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.stub.createPrivateConnectionOperationCallable();
    }

    public final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.stub.createPrivateConnectionCallable();
    }

    public final PrivateConnection getPrivateConnection(PrivateConnectionName name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(String name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(GetPrivateConnectionRequest request) {
        return (PrivateConnection)this.getPrivateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.stub.getPrivateConnectionCallable();
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(LocationName parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(String parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(ListPrivateConnectionsRequest request) {
        return (ListPrivateConnectionsPagedResponse)((Object)this.listPrivateConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.stub.listPrivateConnectionsPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.stub.listPrivateConnectionsCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> updatePrivateConnectionAsync(PrivateConnection privateConnection, FieldMask updateMask) {
        UpdatePrivateConnectionRequest request = UpdatePrivateConnectionRequest.newBuilder().setPrivateConnection(privateConnection).setUpdateMask(updateMask).build();
        return this.updatePrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> updatePrivateConnectionAsync(UpdatePrivateConnectionRequest request) {
        return this.updatePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePrivateConnectionRequest, PrivateConnection, OperationMetadata> updatePrivateConnectionOperationCallable() {
        return this.stub.updatePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<UpdatePrivateConnectionRequest, Operation> updatePrivateConnectionCallable() {
        return this.stub.updatePrivateConnectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(PrivateConnectionName name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(String name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(DeletePrivateConnectionRequest request) {
        return this.deletePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.stub.deletePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.stub.deletePrivateConnectionCallable();
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(PrivateConnectionName parent) {
        ListPrivateConnectionPeeringRoutesRequest request = ListPrivateConnectionPeeringRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnectionPeeringRoutes(request);
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(String parent) {
        ListPrivateConnectionPeeringRoutesRequest request = ListPrivateConnectionPeeringRoutesRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnectionPeeringRoutes(request);
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(ListPrivateConnectionPeeringRoutesRequest request) {
        return (ListPrivateConnectionPeeringRoutesPagedResponse)((Object)this.listPrivateConnectionPeeringRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesPagedResponse> listPrivateConnectionPeeringRoutesPagedCallable() {
        return this.stub.listPrivateConnectionPeeringRoutesPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse> listPrivateConnectionPeeringRoutesCallable() {
        return this.stub.listPrivateConnectionPeeringRoutesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionPeeringRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage, ListPrivateConnectionPeeringRoutesFixedSizeCollection> {
        private ListPrivateConnectionPeeringRoutesFixedSizeCollection(List<ListPrivateConnectionPeeringRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionPeeringRoutesFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionPeeringRoutesFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionPeeringRoutesFixedSizeCollection createCollection(List<ListPrivateConnectionPeeringRoutesPage> pages, int collectionSize) {
            return new ListPrivateConnectionPeeringRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionPeeringRoutesPage
    extends AbstractPage<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage> {
        private ListPrivateConnectionPeeringRoutesPage(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ListPrivateConnectionPeeringRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionPeeringRoutesPage createEmptyPage() {
            return new ListPrivateConnectionPeeringRoutesPage(null, null);
        }

        protected ListPrivateConnectionPeeringRoutesPage createPage(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ListPrivateConnectionPeeringRoutesResponse response) {
            return new ListPrivateConnectionPeeringRoutesPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionPeeringRoutesPage> createPageAsync(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPrivateConnectionPeeringRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionPeeringRoutesPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage, ListPrivateConnectionPeeringRoutesFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionPeeringRoutesPagedResponse> createAsync(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPrivateConnectionPeeringRoutesResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionPeeringRoutesPage> futurePage = ListPrivateConnectionPeeringRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionPeeringRoutesPagedResponse((ListPrivateConnectionPeeringRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionPeeringRoutesPagedResponse(ListPrivateConnectionPeeringRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionPeeringRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        private ListPrivateConnectionsFixedSizeCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionsFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionsFixedSizeCollection createCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            return new ListPrivateConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionsPage
    extends AbstractPage<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage> {
        private ListPrivateConnectionsPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionsPage createEmptyPage() {
            return new ListPrivateConnectionsPage(null, null);
        }

        protected ListPrivateConnectionsPage createPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            return new ListPrivateConnectionsPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionsPage> createPageAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionsPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionsPagedResponse> createAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionsPage> futurePage = ListPrivateConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionsPagedResponse((ListPrivateConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionsPagedResponse(ListPrivateConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVmwareEngineNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage, ListVmwareEngineNetworksFixedSizeCollection> {
        private ListVmwareEngineNetworksFixedSizeCollection(List<ListVmwareEngineNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVmwareEngineNetworksFixedSizeCollection createEmptyCollection() {
            return new ListVmwareEngineNetworksFixedSizeCollection(null, 0);
        }

        protected ListVmwareEngineNetworksFixedSizeCollection createCollection(List<ListVmwareEngineNetworksPage> pages, int collectionSize) {
            return new ListVmwareEngineNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVmwareEngineNetworksPage
    extends AbstractPage<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage> {
        private ListVmwareEngineNetworksPage(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ListVmwareEngineNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListVmwareEngineNetworksPage createEmptyPage() {
            return new ListVmwareEngineNetworksPage(null, null);
        }

        protected ListVmwareEngineNetworksPage createPage(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ListVmwareEngineNetworksResponse response) {
            return new ListVmwareEngineNetworksPage(context, response);
        }

        public ApiFuture<ListVmwareEngineNetworksPage> createPageAsync(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ApiFuture<ListVmwareEngineNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVmwareEngineNetworksPagedResponse
    extends AbstractPagedListResponse<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage, ListVmwareEngineNetworksFixedSizeCollection> {
        public static ApiFuture<ListVmwareEngineNetworksPagedResponse> createAsync(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ApiFuture<ListVmwareEngineNetworksResponse> futureResponse) {
            ApiFuture<ListVmwareEngineNetworksPage> futurePage = ListVmwareEngineNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVmwareEngineNetworksPagedResponse((ListVmwareEngineNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVmwareEngineNetworksPagedResponse(ListVmwareEngineNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVmwareEngineNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworkPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage, ListNetworkPoliciesFixedSizeCollection> {
        private ListNetworkPoliciesFixedSizeCollection(List<ListNetworkPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListNetworkPoliciesFixedSizeCollection(null, 0);
        }

        protected ListNetworkPoliciesFixedSizeCollection createCollection(List<ListNetworkPoliciesPage> pages, int collectionSize) {
            return new ListNetworkPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkPoliciesPage
    extends AbstractPage<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage> {
        private ListNetworkPoliciesPage(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ListNetworkPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworkPoliciesPage createEmptyPage() {
            return new ListNetworkPoliciesPage(null, null);
        }

        protected ListNetworkPoliciesPage createPage(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ListNetworkPoliciesResponse response) {
            return new ListNetworkPoliciesPage(context, response);
        }

        public ApiFuture<ListNetworkPoliciesPage> createPageAsync(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ApiFuture<ListNetworkPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkPoliciesPagedResponse
    extends AbstractPagedListResponse<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage, ListNetworkPoliciesFixedSizeCollection> {
        public static ApiFuture<ListNetworkPoliciesPagedResponse> createAsync(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ApiFuture<ListNetworkPoliciesResponse> futureResponse) {
            ApiFuture<ListNetworkPoliciesPage> futurePage = ListNetworkPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworkPoliciesPagedResponse((ListNetworkPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkPoliciesPagedResponse(ListNetworkPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHcxActivationKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage, ListHcxActivationKeysFixedSizeCollection> {
        private ListHcxActivationKeysFixedSizeCollection(List<ListHcxActivationKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHcxActivationKeysFixedSizeCollection createEmptyCollection() {
            return new ListHcxActivationKeysFixedSizeCollection(null, 0);
        }

        protected ListHcxActivationKeysFixedSizeCollection createCollection(List<ListHcxActivationKeysPage> pages, int collectionSize) {
            return new ListHcxActivationKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHcxActivationKeysPage
    extends AbstractPage<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage> {
        private ListHcxActivationKeysPage(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ListHcxActivationKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListHcxActivationKeysPage createEmptyPage() {
            return new ListHcxActivationKeysPage(null, null);
        }

        protected ListHcxActivationKeysPage createPage(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ListHcxActivationKeysResponse response) {
            return new ListHcxActivationKeysPage(context, response);
        }

        public ApiFuture<ListHcxActivationKeysPage> createPageAsync(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ApiFuture<ListHcxActivationKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHcxActivationKeysPagedResponse
    extends AbstractPagedListResponse<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage, ListHcxActivationKeysFixedSizeCollection> {
        public static ApiFuture<ListHcxActivationKeysPagedResponse> createAsync(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ApiFuture<ListHcxActivationKeysResponse> futureResponse) {
            ApiFuture<ListHcxActivationKeysPage> futurePage = ListHcxActivationKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHcxActivationKeysPagedResponse((ListHcxActivationKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHcxActivationKeysPagedResponse(ListHcxActivationKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHcxActivationKeysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodeTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        private ListNodeTypesFixedSizeCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodeTypesFixedSizeCollection createEmptyCollection() {
            return new ListNodeTypesFixedSizeCollection(null, 0);
        }

        protected ListNodeTypesFixedSizeCollection createCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            return new ListNodeTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodeTypesPage
    extends AbstractPage<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage> {
        private ListNodeTypesPage(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ListNodeTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListNodeTypesPage createEmptyPage() {
            return new ListNodeTypesPage(null, null);
        }

        protected ListNodeTypesPage createPage(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ListNodeTypesResponse response) {
            return new ListNodeTypesPage(context, response);
        }

        public ApiFuture<ListNodeTypesPage> createPageAsync(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ApiFuture<ListNodeTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodeTypesPagedResponse
    extends AbstractPagedListResponse<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        public static ApiFuture<ListNodeTypesPagedResponse> createAsync(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ApiFuture<ListNodeTypesResponse> futureResponse) {
            ApiFuture<ListNodeTypesPage> futurePage = ListNodeTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodeTypesPagedResponse((ListNodeTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodeTypesPagedResponse(ListNodeTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodeTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubnetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        private ListSubnetsFixedSizeCollection(List<ListSubnetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubnetsFixedSizeCollection createEmptyCollection() {
            return new ListSubnetsFixedSizeCollection(null, 0);
        }

        protected ListSubnetsFixedSizeCollection createCollection(List<ListSubnetsPage> pages, int collectionSize) {
            return new ListSubnetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubnetsPage
    extends AbstractPage<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage> {
        private ListSubnetsPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubnetsPage createEmptyPage() {
            return new ListSubnetsPage(null, null);
        }

        protected ListSubnetsPage createPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            return new ListSubnetsPage(context, response);
        }

        public ApiFuture<ListSubnetsPage> createPageAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubnetsPagedResponse
    extends AbstractPagedListResponse<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        public static ApiFuture<ListSubnetsPagedResponse> createAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            ApiFuture<ListSubnetsPage> futurePage = ListSubnetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubnetsPagedResponse((ListSubnetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubnetsPagedResponse(ListSubnetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubnetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateCloudsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage, ListPrivateCloudsFixedSizeCollection> {
        private ListPrivateCloudsFixedSizeCollection(List<ListPrivateCloudsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateCloudsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateCloudsFixedSizeCollection(null, 0);
        }

        protected ListPrivateCloudsFixedSizeCollection createCollection(List<ListPrivateCloudsPage> pages, int collectionSize) {
            return new ListPrivateCloudsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateCloudsPage
    extends AbstractPage<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage> {
        private ListPrivateCloudsPage(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ListPrivateCloudsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateCloudsPage createEmptyPage() {
            return new ListPrivateCloudsPage(null, null);
        }

        protected ListPrivateCloudsPage createPage(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ListPrivateCloudsResponse response) {
            return new ListPrivateCloudsPage(context, response);
        }

        public ApiFuture<ListPrivateCloudsPage> createPageAsync(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ApiFuture<ListPrivateCloudsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateCloudsPagedResponse
    extends AbstractPagedListResponse<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage, ListPrivateCloudsFixedSizeCollection> {
        public static ApiFuture<ListPrivateCloudsPagedResponse> createAsync(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ApiFuture<ListPrivateCloudsResponse> futureResponse) {
            ApiFuture<ListPrivateCloudsPage> futurePage = ListPrivateCloudsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateCloudsPagedResponse((ListPrivateCloudsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateCloudsPagedResponse(ListPrivateCloudsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateCloudsFixedSizeCollection.createEmptyCollection());
        }
    }
}

