/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class BigQueryClientFactoryConfig
implements BigQueryConfig {
    private final Optional<String> accessTokenProviderFQCN;
    private final Optional<String> accessTokenProviderConfig;
    private final Optional<String> credentialsKey;
    private final Optional<String> credentialsFile;
    private final Optional<String> accessToken;
    private final String loggedInUserName;
    private final Set<String> loggedInUserGroups;
    private final Optional<String> impersonationServiceAccount;
    private final Optional<Map<String, String>> impersonationServiceAccountsForUsers;
    private final Optional<Map<String, String>> impersonationServiceAccountsForGroups;
    private final String parentProjectId;
    private final boolean useParentProjectForMetadataOperations;
    private final boolean viewsEnabled;
    private final Optional<String> materializationProject;
    private final Optional<String> materializationDataset;
    private final int bigQueryClientConnectTimeout;
    private final int bigQueryClientReadTimeout;
    private final RetrySettings bigQueryClientRetrySettings;
    private final BigQueryProxyConfig bigQueryProxyConfig;
    private final Optional<String> bigQueryStorageGrpcEndpoint;
    private final Optional<String> bigQueryHttpEndpoint;
    private final int cacheExpirationTimeInMinutes;
    private final ImmutableMap<String, String> bigQueryJobLabels;
    private final Optional<Long> createReadSessionTimeoutInSeconds;
    private final int channelPoolSize;
    private final Optional<Integer> flowControlWindowBytes;
    private final QueryJobConfiguration.Priority queryJobPriority;

    BigQueryClientFactoryConfig(BigQueryConfig bigQueryConfig) {
        this.accessTokenProviderFQCN = bigQueryConfig.getAccessTokenProviderFQCN();
        this.accessTokenProviderConfig = bigQueryConfig.getAccessTokenProviderConfig();
        this.credentialsKey = bigQueryConfig.getCredentialsKey();
        this.credentialsFile = bigQueryConfig.getCredentialsFile();
        this.accessToken = bigQueryConfig.getAccessToken();
        this.loggedInUserName = bigQueryConfig.getLoggedInUserName();
        this.loggedInUserGroups = bigQueryConfig.getLoggedInUserGroups();
        this.impersonationServiceAccountsForUsers = bigQueryConfig.getImpersonationServiceAccountsForUsers();
        this.impersonationServiceAccountsForGroups = bigQueryConfig.getImpersonationServiceAccountsForGroups();
        this.impersonationServiceAccount = bigQueryConfig.getImpersonationServiceAccount();
        this.parentProjectId = bigQueryConfig.getParentProjectId();
        this.useParentProjectForMetadataOperations = bigQueryConfig.useParentProjectForMetadataOperations();
        this.viewsEnabled = bigQueryConfig.isViewsEnabled();
        this.materializationProject = bigQueryConfig.getMaterializationProject();
        this.materializationDataset = bigQueryConfig.getMaterializationDataset();
        this.bigQueryClientConnectTimeout = bigQueryConfig.getBigQueryClientConnectTimeout();
        this.bigQueryClientReadTimeout = bigQueryConfig.getBigQueryClientReadTimeout();
        this.bigQueryClientRetrySettings = bigQueryConfig.getBigQueryClientRetrySettings();
        this.bigQueryProxyConfig = bigQueryConfig.getBigQueryProxyConfig();
        this.bigQueryStorageGrpcEndpoint = bigQueryConfig.getBigQueryStorageGrpcEndpoint();
        this.bigQueryHttpEndpoint = bigQueryConfig.getBigQueryHttpEndpoint();
        this.cacheExpirationTimeInMinutes = bigQueryConfig.getCacheExpirationTimeInMinutes();
        this.bigQueryJobLabels = bigQueryConfig.getBigQueryJobLabels();
        this.createReadSessionTimeoutInSeconds = bigQueryConfig.getCreateReadSessionTimeoutInSeconds();
        this.channelPoolSize = bigQueryConfig.getChannelPoolSize();
        this.flowControlWindowBytes = bigQueryConfig.getFlowControlWindowBytes();
        this.queryJobPriority = bigQueryConfig.getQueryJobPriority();
    }

    @Override
    public Optional<String> getAccessTokenProviderFQCN() {
        return this.accessTokenProviderFQCN;
    }

    @Override
    public Optional<String> getAccessTokenProviderConfig() {
        return this.accessTokenProviderConfig;
    }

    @Override
    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Override
    public Optional<String> getCredentialsFile() {
        return this.credentialsFile;
    }

    @Override
    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getLoggedInUserName() {
        return this.loggedInUserName;
    }

    @Override
    public Set<String> getLoggedInUserGroups() {
        return this.loggedInUserGroups;
    }

    @Override
    public Optional<Map<String, String>> getImpersonationServiceAccountsForUsers() {
        return this.impersonationServiceAccountsForUsers;
    }

    @Override
    public Optional<Map<String, String>> getImpersonationServiceAccountsForGroups() {
        return this.impersonationServiceAccountsForGroups;
    }

    @Override
    public Optional<String> getImpersonationServiceAccount() {
        return this.impersonationServiceAccount;
    }

    @Override
    public String getParentProjectId() {
        return this.parentProjectId;
    }

    @Override
    public boolean useParentProjectForMetadataOperations() {
        return this.useParentProjectForMetadataOperations;
    }

    @Override
    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Override
    public Optional<String> getMaterializationProject() {
        return this.materializationProject;
    }

    @Override
    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset;
    }

    @Override
    public int getBigQueryClientConnectTimeout() {
        return this.bigQueryClientConnectTimeout;
    }

    @Override
    public int getBigQueryClientReadTimeout() {
        return this.bigQueryClientReadTimeout;
    }

    @Override
    public RetrySettings getBigQueryClientRetrySettings() {
        return this.bigQueryClientRetrySettings;
    }

    @Override
    public BigQueryProxyConfig getBigQueryProxyConfig() {
        return this.bigQueryProxyConfig;
    }

    @Override
    public Optional<String> getBigQueryStorageGrpcEndpoint() {
        return this.bigQueryStorageGrpcEndpoint;
    }

    @Override
    public Optional<String> getBigQueryHttpEndpoint() {
        return this.bigQueryHttpEndpoint;
    }

    @Override
    public int getCacheExpirationTimeInMinutes() {
        return this.cacheExpirationTimeInMinutes;
    }

    @Override
    public ImmutableMap<String, String> getBigQueryJobLabels() {
        return this.bigQueryJobLabels;
    }

    @Override
    public Optional<Long> getCreateReadSessionTimeoutInSeconds() {
        return this.createReadSessionTimeoutInSeconds;
    }

    @Override
    public int getChannelPoolSize() {
        return this.channelPoolSize;
    }

    @Override
    public Optional<Integer> getFlowControlWindowBytes() {
        return this.flowControlWindowBytes;
    }

    @Override
    public QueryJobConfiguration.Priority getQueryJobPriority() {
        return this.queryJobPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BigQueryClientFactoryConfig)) {
            return false;
        }
        BigQueryClientFactoryConfig that = (BigQueryClientFactoryConfig)o;
        return this.viewsEnabled == that.viewsEnabled && this.bigQueryClientConnectTimeout == that.bigQueryClientConnectTimeout && this.bigQueryClientReadTimeout == that.bigQueryClientReadTimeout && Objects.equal(this.credentialsKey, that.credentialsKey) && Objects.equal(this.credentialsFile, that.credentialsFile) && Objects.equal(this.accessToken, that.accessToken) && Objects.equal((Object)this.parentProjectId, (Object)that.parentProjectId) && Objects.equal((Object)this.useParentProjectForMetadataOperations, (Object)that.useParentProjectForMetadataOperations) && Objects.equal(this.materializationProject, that.materializationProject) && Objects.equal(this.materializationDataset, that.materializationDataset) && Objects.equal((Object)this.bigQueryClientRetrySettings, (Object)that.bigQueryClientRetrySettings) && Objects.equal((Object)this.bigQueryProxyConfig, (Object)that.bigQueryProxyConfig) && Objects.equal(this.bigQueryStorageGrpcEndpoint, that.bigQueryStorageGrpcEndpoint) && Objects.equal(this.bigQueryHttpEndpoint, that.bigQueryHttpEndpoint) && Objects.equal((Object)this.cacheExpirationTimeInMinutes, (Object)that.cacheExpirationTimeInMinutes) && Objects.equal(this.createReadSessionTimeoutInSeconds, that.createReadSessionTimeoutInSeconds) && Objects.equal((Object)this.channelPoolSize, (Object)that.channelPoolSize) && Objects.equal(this.flowControlWindowBytes, that.flowControlWindowBytes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.credentialsKey, this.credentialsFile, this.accessToken, this.parentProjectId, this.useParentProjectForMetadataOperations, this.viewsEnabled, this.materializationProject, this.materializationDataset, this.bigQueryClientConnectTimeout, this.bigQueryClientReadTimeout, this.bigQueryClientRetrySettings, this.bigQueryProxyConfig, this.bigQueryStorageGrpcEndpoint, this.bigQueryHttpEndpoint, this.cacheExpirationTimeInMinutes, this.channelPoolSize, this.flowControlWindowBytes});
    }
}

