/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorMultiplexer<T>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(IteratorMultiplexer.class);
    private static final Object TERMINAL_SENTINEL = new Object();
    private final Iterator<T> iterator;
    private final int splits;
    private final QueueIterator<T>[] iterators;
    private Thread worker;

    public IteratorMultiplexer(Iterator<T> iterator, int splits) {
        this.iterator = iterator;
        this.splits = splits;
        this.iterators = new QueueIterator[splits];
        for (int x = 0; x < splits; ++x) {
            this.iterators[x] = new QueueIterator();
        }
    }

    @Override
    public void close() {
        if (this.worker != null) {
            this.worker.interrupt();
            try {
                this.worker.join(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting on worker thread shutdown.", e);
            }
            this.worker = null;
        }
        for (int x = 0; x < this.splits; ++x) {
            this.iterators[x].markDone(null);
        }
    }

    void readAhead() {
        Throwable e = null;
        try {
            boolean hasMore = true;
            block3: while (hasMore) {
                for (int x = 0; x < this.splits; ++x) {
                    if (!this.iterator.hasNext()) {
                        hasMore = false;
                        continue block3;
                    }
                    T value = this.iterator.next();
                    ((QueueIterator)this.iterators[x]).sem.acquire();
                    ((QueueIterator)this.iterators[x]).queue.put(value);
                }
            }
        }
        catch (InterruptedException ex) {
            log.info("Worker was interrupted. Ending all iterators");
            e = new RuntimeException(ex);
        }
        catch (Throwable ex) {
            log.info("Worker had exception. Ending all iterators", e);
            e = ex;
        }
        for (int x = 0; x < this.splits; ++x) {
            this.iterators[x].markDone(e);
        }
    }

    public synchronized Iterator<T> getSplit(int split) {
        if (this.worker == null) {
            this.worker = new Thread(this::readAhead, "readahead-worker");
            this.worker.setDaemon(true);
            this.worker.start();
        }
        return this.iterators[split];
    }

    private class QueueIterator<T>
    implements Iterator<T> {
        private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(2);
        private final Semaphore sem = new Semaphore(1);
        private Object t = null;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.t == TERMINAL_SENTINEL) {
                return false;
            }
            try {
                this.t = this.queue.take();
                this.sem.release();
            }
            catch (InterruptedException e) {
                IteratorMultiplexer.this.worker.interrupt();
                this.t = TERMINAL_SENTINEL;
            }
            return this.t != TERMINAL_SENTINEL;
        }

        @Override
        public T next() {
            Preconditions.checkState((this.t != TERMINAL_SENTINEL ? 1 : 0) != 0, (Object)"No next message");
            if (this.t instanceof Throwable) {
                if (this.t instanceof RuntimeException) {
                    throw (RuntimeException)this.t;
                }
                throw new RuntimeException((Throwable)this.t);
            }
            Object ret = this.t;
            this.t = null;
            return (T)ret;
        }

        public synchronized void markDone(Throwable e) {
            if (this.t == TERMINAL_SENTINEL || this.t instanceof Exception) {
                return;
            }
            if (this.queue.remainingCapacity() > 0) {
                if (e != null) {
                    Preconditions.checkState((boolean)this.queue.offer(e), (Object)"Expected room for exception");
                } else {
                    Preconditions.checkState((boolean)this.queue.offer(TERMINAL_SENTINEL), (Object)"Expected room for sentinel");
                }
            }
        }
    }
}

