/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryMetrics;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.DurationTimer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBigQueryStorageReadRowsTracer
implements BigQueryStorageReadRowsTracer {
    private static final Logger log = LoggerFactory.getLogger(LoggingBigQueryStorageReadRowsTracer.class);
    private final String streamName;
    private final int logIntervalPowerOf2;
    Instant startTime;
    final DurationTimer parseTime = new DurationTimer();
    final DurationTimer sparkTime = new DurationTimer();
    final DurationTimer serviceTime = new DurationTimer();
    Instant endTime;
    long rows = 0L;
    long bytes = 0L;
    long linesLogged = 0L;
    BigQueryMetrics bigQueryMetrics;

    LoggingBigQueryStorageReadRowsTracer(String streamName, int logIntervalPowerOf2, BigQueryMetrics bigQueryMetrics) {
        this.streamName = streamName;
        this.logIntervalPowerOf2 = logIntervalPowerOf2;
        this.bigQueryMetrics = bigQueryMetrics;
    }

    @Override
    public void startStream() {
        this.startTime = Instant.now();
    }

    @Override
    public void rowsParseStarted() {
        this.parseTime.start();
    }

    @Override
    public void rowsParseFinished(long rows) {
        this.rows += rows;
        this.parseTime.finish();
    }

    @Override
    public void readRowsResponseRequested() {
        this.serviceTime.start();
    }

    @Override
    public void readRowsResponseObtained(long bytes) {
        this.bytes += bytes;
        this.serviceTime.finish();
    }

    @Override
    public void finished() {
        this.endTime = Instant.now();
        this.logData();
    }

    private static Duration average(DurationTimer durationTimer) {
        long samples = durationTimer.getSamples();
        if (samples == 0L) {
            return null;
        }
        return durationTimer.getAccumulatedTime().dividedBy(samples);
    }

    private static String format(DurationTimer durationTimer) {
        long samples = durationTimer.getSamples();
        if (samples == 0L) {
            return "Not enough samples.";
        }
        Duration average = LoggingBigQueryStorageReadRowsTracer.average(durationTimer);
        return String.format("Average: %s Samples: %d", average.toString(), samples);
    }

    private static String difference(DurationTimer d1, DurationTimer d2) {
        if (d1.getSamples() == 0L || d2.getSamples() == 0L) {
            return "Not enough samples.";
        }
        return String.format("Average: %s", LoggingBigQueryStorageReadRowsTracer.average(d1).minus(LoggingBigQueryStorageReadRowsTracer.average(d2)).toString());
    }

    private static long perSecond(DurationTimer timer, long metric) {
        if (timer.getSamples() == 0L) {
            return 0L;
        }
        Duration time = timer.getAccumulatedTime();
        double seconds = (double)time.toMillis() / 1000.0;
        if (seconds != 0.0) {
            return (long)((double)metric / seconds);
        }
        return 0L;
    }

    private void logData() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("Stream Name", this.streamName);
        jsonObject.addProperty("Started", this.startTime == null ? "" : this.startTime.toString());
        jsonObject.addProperty("Ended", this.endTime == null ? "" : this.endTime.toString());
        jsonObject.addProperty("Parse Timings", LoggingBigQueryStorageReadRowsTracer.format(this.parseTime));
        jsonObject.addProperty("Time in Spark", LoggingBigQueryStorageReadRowsTracer.difference(this.sparkTime, this.parseTime));
        jsonObject.addProperty("Time waiting for service", LoggingBigQueryStorageReadRowsTracer.format(this.serviceTime));
        jsonObject.addProperty("Bytes/s", (Number)LoggingBigQueryStorageReadRowsTracer.perSecond(this.serviceTime, this.getBytesRead()));
        jsonObject.addProperty("Rows/s", (Number)LoggingBigQueryStorageReadRowsTracer.perSecond(this.parseTime, this.getRowsRead()));
        jsonObject.addProperty("Bytes", (Number)this.getBytesRead());
        jsonObject.addProperty("Rows", (Number)this.getRowsRead());
        jsonObject.addProperty("I/O time", (Number)this.getScanTimeInMilliSec());
        log.trace("Tracer Logs:{}", (Object)new Gson().toJson((JsonElement)jsonObject));
        this.bigQueryMetrics.incrementBytesReadCounter(this.getBytesRead());
        this.bigQueryMetrics.incrementRowsReadCounter(this.getRowsRead());
        this.bigQueryMetrics.updateScanTime(this.getScanTimeInMilliSec());
        this.bigQueryMetrics.updateParseTime(this.getParseTimeInMilliSec());
        this.bigQueryMetrics.updateTimeInSpark(this.getTimeInSparkInMilliSec());
        ++this.linesLogged;
    }

    @Override
    public void nextBatchNeeded() {
        this.sparkTime.finish();
        if ((this.sparkTime.getSamples() + 1L & (long)((1 << this.logIntervalPowerOf2) - 1)) == 0L) {
            this.logData();
        }
    }

    @Override
    public BigQueryStorageReadRowsTracer forkWithPrefix(String id) {
        return new LoggingBigQueryStorageReadRowsTracer("id-" + id + "-" + this.streamName, this.logIntervalPowerOf2, this.bigQueryMetrics);
    }

    @Override
    public long getBytesRead() {
        return this.bytes;
    }

    @Override
    public long getRowsRead() {
        return this.rows;
    }

    @Override
    public long getScanTimeInMilliSec() {
        return this.serviceTime.getAccumulatedTime().toMillis();
    }

    @Override
    public long getParseTimeInMilliSec() {
        return this.parseTime.getAccumulatedTime().toMillis();
    }

    @Override
    public long getTimeInSparkInMilliSec() {
        return this.sparkTime.getAccumulatedTime().minus(this.parseTime.getAccumulatedTime()).toMillis();
    }

    String getStreamName() {
        return this.streamName;
    }
}

