/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.MaterializationConfiguration;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BigQueryConfigurationUtil {
    public static final java.util.function.Supplier<com.google.common.base.Optional<String>> DEFAULT_FALLBACK = () -> BigQueryConfigurationUtil.empty();

    private BigQueryConfigurationUtil() {
    }

    public static Supplier<String> defaultBilledProject() {
        return () -> BigQueryOptions.getDefaultInstance().getProjectId();
    }

    public static String getRequiredOption(Map<String, String> options, String name) {
        return (String)BigQueryConfigurationUtil.getOption(options, name, DEFAULT_FALLBACK).toJavaUtil().orElseThrow(() -> new IllegalArgumentException(String.format("Option %s required.", name)));
    }

    public static String getRequiredOption(Map<String, String> options, String name, Supplier<String> fallback) {
        return (String)BigQueryConfigurationUtil.getOption(options, name, DEFAULT_FALLBACK).or(fallback);
    }

    public static com.google.common.base.Optional<String> getOption(Map<String, String> options, String name) {
        return BigQueryConfigurationUtil.getOption(options, name, DEFAULT_FALLBACK);
    }

    public static com.google.common.base.Optional<String> getOption(Map<String, String> options, String name, java.util.function.Supplier<com.google.common.base.Optional<String>> fallback) {
        return BigQueryConfigurationUtil.fromJavaUtil(BigQueryUtil.firstPresent(Optional.ofNullable(options.get(name.toLowerCase())), fallback.get().toJavaUtil()));
    }

    public static com.google.common.base.Optional<String> getOptionFromMultipleParams(Map<String, String> options, Collection<String> names, java.util.function.Supplier<com.google.common.base.Optional<String>> fallback) {
        return names.stream().map(name -> BigQueryConfigurationUtil.getOption(options, name)).filter(com.google.common.base.Optional::isPresent).findFirst().orElseGet(fallback);
    }

    public static Map<String, String> getMapEntriesWithPrefix(Map<String, String> map, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static com.google.common.base.Optional<Map<String, String>> removePrefixFromMapKeys(com.google.common.base.Optional<Map<String, String>> map, String prefix) {
        HashMap modifiedMap = new HashMap();
        if (map.isPresent()) {
            for (Map.Entry entry : ((Map)map.get()).entrySet()) {
                String originalKey = (String)entry.getKey();
                String modifiedKey = originalKey.startsWith(prefix) ? originalKey.substring(prefix.length()) : originalKey;
                modifiedMap.put(modifiedKey, entry.getValue());
            }
        }
        return com.google.common.base.Optional.of(modifiedMap);
    }

    public static com.google.common.base.Optional<Map<String, String>> getAnyOptionsWithPrefix(ImmutableMap<String, String> globalOptions, Map<String, String> options, String prefix) {
        Map<String, String> result = BigQueryConfigurationUtil.getMapEntriesWithPrefix(globalOptions, prefix);
        Map<String, String> prefixOptions = BigQueryConfigurationUtil.getMapEntriesWithPrefix(options, prefix);
        result.putAll(prefixOptions);
        return com.google.common.base.Optional.of(result);
    }

    public static com.google.common.base.Optional<String> getAnyOption(ImmutableMap<String, String> globalOptions, Map<String, String> options, String name) {
        return com.google.common.base.Optional.fromNullable((Object)options.get(name.toLowerCase())).or(com.google.common.base.Optional.fromNullable((Object)globalOptions.get((Object)name)));
    }

    public static com.google.common.base.Optional<String> getAnyOption(ImmutableMap<String, String> globalOptions, Map<String, String> options, Collection<String> names) {
        return names.stream().map(name -> BigQueryConfigurationUtil.getAnyOption(globalOptions, options, name)).filter(optional -> optional.isPresent()).findFirst().orElse(BigQueryConfigurationUtil.empty());
    }

    public static boolean getAnyBooleanOption(ImmutableMap<String, String> globalOptions, Map<String, String> options, String name, boolean defaultValue) {
        return (Boolean)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, name).transform(Boolean::valueOf).or((Object)defaultValue);
    }

    public static com.google.common.base.Optional empty() {
        return com.google.common.base.Optional.absent();
    }

    public static com.google.common.base.Optional fromJavaUtil(Optional o) {
        return com.google.common.base.Optional.fromJavaUtil((Optional)o);
    }

    public static TableId parseSimpleTableId(Map<String, String> options, com.google.common.base.Optional<String> fallbackProject, com.google.common.base.Optional<String> fallbackDataset) {
        String tableParam = (String)BigQueryConfigurationUtil.getOptionFromMultipleParams(options, (Collection<String>)ImmutableList.of((Object)"table", (Object)"path"), DEFAULT_FALLBACK).get();
        com.google.common.base.Optional datasetParam = BigQueryConfigurationUtil.getOption(options, "dataset").or(fallbackDataset);
        com.google.common.base.Optional projectParam = BigQueryConfigurationUtil.getOption(options, "project").or(fallbackProject);
        return BigQueryUtil.parseTableId(tableParam, datasetParam.toJavaUtil(), projectParam.toJavaUtil(), Optional.empty());
    }

    public static TableId parseSimpleTableId(Map<String, String> options, Optional<String> fallbackProject, Optional<String> fallbackDataset) {
        return BigQueryConfigurationUtil.parseSimpleTableId(options, (com.google.common.base.Optional<String>)com.google.common.base.Optional.fromJavaUtil(fallbackProject), (com.google.common.base.Optional<String>)com.google.common.base.Optional.fromJavaUtil(fallbackDataset));
    }

    public static TableId parseSimpleTableId(ImmutableMap<String, String> globalOptions, Map<String, String> options) {
        MaterializationConfiguration materializationConfiguration = MaterializationConfiguration.from(globalOptions, options);
        return BigQueryConfigurationUtil.parseSimpleTableId(options, materializationConfiguration.getMaterializationProject(), materializationConfiguration.getMaterializationDataset());
    }
}

