/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalRowIterator
implements Iterator<InternalRow> {
    private Iterator<ReadRowsResponse> readRowsResponses;
    private ReadRowsResponseToInternalRowIteratorConverter converter;
    private ReadRowsHelper readRowsHelper;
    private final BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer;
    private Iterator<InternalRow> rows = ImmutableList.of().iterator();
    private static final Logger log = LoggerFactory.getLogger(InternalRowIterator.class);

    public InternalRowIterator(Iterator<ReadRowsResponse> readRowsResponses, ReadRowsResponseToInternalRowIteratorConverter converter, ReadRowsHelper readRowsHelper, BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer) {
        this.readRowsResponses = readRowsResponses;
        this.converter = converter;
        this.readRowsHelper = readRowsHelper;
        this.bigQueryStorageReadRowsTracer = bigQueryStorageReadRowsTracer;
    }

    @Override
    public boolean hasNext() {
        while (!this.rows.hasNext()) {
            this.bigQueryStorageReadRowsTracer.readRowsResponseRequested();
            if (!this.readRowsResponses.hasNext()) {
                try {
                    this.bigQueryStorageReadRowsTracer.finished();
                }
                catch (Exception e) {
                    log.debug("Failure finishing tracer. stream:{} exception:{}", (Object)this.readRowsHelper, (Object)e);
                }
                finally {
                    this.readRowsHelper.close();
                }
                return false;
            }
            ReadRowsResponse readRowsResponse = this.readRowsResponses.next();
            this.bigQueryStorageReadRowsTracer.readRowsResponseObtained(readRowsResponse == null ? 0L : (long)this.converter.getBatchSizeInBytes(readRowsResponse));
            this.bigQueryStorageReadRowsTracer.nextBatchNeeded();
            this.bigQueryStorageReadRowsTracer.rowsParseStarted();
            this.rows = this.converter.convert(readRowsResponse);
        }
        return true;
    }

    @Override
    public InternalRow next() {
        return this.rows.next();
    }
}

