/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.time.ZoneId;
import javax.annotation.Nonnull;

public class SchemaConvertersConfiguration
implements Serializable {
    private final ZoneId datetimeZoneId;
    private final boolean allowMapTypeConversion;

    private SchemaConvertersConfiguration(ZoneId datetimeZoneId, boolean allowMapTypeConversion) {
        this.datetimeZoneId = datetimeZoneId;
        this.allowMapTypeConversion = allowMapTypeConversion;
    }

    public static SchemaConvertersConfiguration from(SparkBigQueryConfig config) {
        return SchemaConvertersConfiguration.of(config.getDatetimeZoneId(), config.getAllowMapTypeConversion());
    }

    public static SchemaConvertersConfiguration of(@Nonnull ZoneId datetimeZoneId) {
        return new SchemaConvertersConfiguration(datetimeZoneId, true);
    }

    public static SchemaConvertersConfiguration of(@Nonnull ZoneId datetimeZoneId, @Nonnull boolean allowMapTypeConversion) {
        return new SchemaConvertersConfiguration(datetimeZoneId, allowMapTypeConversion);
    }

    public ZoneId getDatetimeZoneId() {
        return this.datetimeZoneId;
    }

    public boolean getAllowMapTypeConversion() {
        return this.allowMapTypeConversion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaConvertersConfiguration that = (SchemaConvertersConfiguration)o;
        return Objects.equal((Object)this.datetimeZoneId, (Object)that.datetimeZoneId) && Objects.equal((Object)this.allowMapTypeConversion, (Object)that.allowMapTypeConversion);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datetimeZoneId, this.allowMapTypeConversion});
    }

    public String toString() {
        return "SchemaConvertersConfiguration{datetimeZoneId=" + this.datetimeZoneId + ",allowMapTypeConversion=" + this.allowMapTypeConversion + '}';
    }
}

