/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.spark3;

import com.google.cloud.spark.bigquery.DataFrameToRDDConverter;
import com.google.cloud.spark.bigquery.spark3.SerializableAbstractFunction1;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSqlUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;

public class Spark3DataFrameToRDDConverter
implements DataFrameToRDDConverter {
    public RDD<Row> convertToRDD(Dataset<Row> data) {
        StructType schema = data.schema();
        ExpressionEncoder expressionEncoder = SparkSqlUtils.getInstance().createExpressionEncoder(schema);
        ExpressionEncoder.Deserializer deserializer = expressionEncoder.createDeserializer();
        ClassTag classTag = ClassTag$.MODULE$.apply(Row.class);
        RDD rowRdd = data.queryExecution().toRdd().mapPartitions(this.getIteratorMapper((ExpressionEncoder.Deserializer<Row>)deserializer), false, classTag);
        return rowRdd;
    }

    private AbstractFunction1<Iterator<InternalRow>, Iterator<Row>> getIteratorMapper(ExpressionEncoder.Deserializer<Row> deserializer) {
        SerializableAbstractFunction1 internalRowMapper = new SerializableAbstractFunction1((Function<InternalRow, Row> & Serializable)internalRow -> (Row)deserializer.apply(internalRow));
        SerializableAbstractFunction1<Iterator<InternalRow>, Iterator<Row>> iteratorMapper = new SerializableAbstractFunction1<Iterator<InternalRow>, Iterator<Row>>((Function<Iterator, Iterator> & Serializable)iterator -> iterator.map((Function1)internalRowMapper));
        return iteratorMapper;
    }
}

