/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.firestore;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreDefaultClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

@AutoConfiguration
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.firestore.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Firestore.class})
@EnableConfigurationProperties(value={GcpFirestoreProperties.class})
public class GcpFirestoreAutoConfiguration {
    private static final UserAgentHeaderProvider USER_AGENT_HEADER_PROVIDER = new UserAgentHeaderProvider(GcpFirestoreAutoConfiguration.class);
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private final String hostPort;
    private final String firestoreRootPath;

    GcpFirestoreAutoConfiguration(GcpFirestoreProperties gcpFirestoreProperties, GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.projectId = gcpFirestoreProperties.getResolvedProjectId(projectIdProvider);
        this.credentialsProvider = gcpFirestoreProperties.getEmulator().isEnabled() ? NoCredentialsProvider.create() : (gcpFirestoreProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpFirestoreProperties) : credentialsProvider);
        this.hostPort = gcpFirestoreProperties.getHostPort();
        this.firestoreRootPath = gcpFirestoreProperties.getFirestoreRootPath(projectIdProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public FirestoreOptions firestoreOptions() {
        return ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.getDefaultInstance().toBuilder().setCredentialsProvider(this.credentialsProvider).setProjectId(this.projectId)).setHeaderProvider((HeaderProvider)USER_AGENT_HEADER_PROVIDER)).setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(this.hostPort).build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Firestore firestore(FirestoreOptions firestoreOptions) {
        return (Firestore)firestoreOptions.getService();
    }

    CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @ConditionalOnClass(value={FirestoreGrpc.FirestoreStub.class, Flux.class})
    class FirestoreReactiveAutoConfiguration {
        FirestoreReactiveAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreGrpc.FirestoreStub firestoreGrpcStub(@Qualifier(value="firestoreManagedChannel") ManagedChannel firestoreManagedChannel) throws IOException {
            return (FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)firestoreManagedChannel).withCallCredentials(MoreCallCredentials.from((Credentials)GcpFirestoreAutoConfiguration.this.credentialsProvider.getCredentials()));
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreMappingContext firestoreMappingContext() {
            return new FirestoreMappingContext();
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreClassMapper getClassMapper(FirestoreMappingContext mappingContext) {
            return new FirestoreDefaultClassMapper(mappingContext);
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreTemplate firestoreTemplate(FirestoreGrpc.FirestoreStub firestoreStub, FirestoreClassMapper classMapper, FirestoreMappingContext firestoreMappingContext) {
            return new FirestoreTemplate(firestoreStub, GcpFirestoreAutoConfiguration.this.firestoreRootPath, classMapper, firestoreMappingContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"firestoreManagedChannel"})
        public ManagedChannel firestoreManagedChannel() {
            return ManagedChannelBuilder.forTarget((String)("dns:///" + GcpFirestoreAutoConfiguration.this.hostPort)).userAgent(USER_AGENT_HEADER_PROVIDER.getUserAgent()).build();
        }
    }
}

