/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.datastore;

import com.google.cloud.datastore.testing.LocalDatastoreHelper;
import com.google.cloud.spring.autoconfigure.datastore.EmulatorSettings;
import com.google.cloud.spring.autoconfigure.datastore.GcpDatastoreAutoConfiguration;
import com.google.cloud.spring.autoconfigure.datastore.GcpDatastoreProperties;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(value={"spring.cloud.gcp.datastore.emulator.enabled"})
@AutoConfigureBefore(value={GcpDatastoreAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpDatastoreProperties.class})
@ConditionalOnMissingBean(value={LocalDatastoreHelper.class})
public class GcpDatastoreEmulatorAutoConfiguration
implements SmartLifecycle {
    private static final Log LOGGER = LogFactory.getLog(GcpDatastoreEmulatorAutoConfiguration.class);
    private LocalDatastoreHelper helper;
    private volatile boolean running;

    @Bean
    public LocalDatastoreHelper createDatastoreHelper(GcpDatastoreProperties datastoreProperties) {
        EmulatorSettings settings = datastoreProperties.getEmulator();
        this.helper = LocalDatastoreHelper.newBuilder().setConsistency(settings.getConsistency()).setPort(settings.getPort()).setStoreOnDisk(settings.isStoreOnDisk()).setDataDir(settings.getDataDir()).setFirestoreInDatastoreMode(settings.getFirestoreInDatastoreMode()).build();
        return this.helper;
    }

    public void stop() {
        if (!this.isRunning()) {
            LOGGER.warn((Object)"The datastore emulator is not running.");
            return;
        }
        try {
            LOGGER.info((Object)"Stopping datastore emulator.");
            this.helper.stop();
            LOGGER.info((Object)"Datastore emulator stopped.");
            this.running = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while stopping Datastore emulator.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO error while stopping datastore emulator.", e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Timed out while stopping datastore emulator.", e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.isRunning()) {
            LOGGER.warn((Object)"The datastore emulator is already running.");
            return;
        }
        try {
            LOGGER.info((Object)"Starting datastore emulator.");
            this.helper.start();
            LOGGER.info((Object)"Datastore emulator started.");
            this.running = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while starting Datastore emulator.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO error while starting datastore emulator.", e);
        }
    }
}

