/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.secretmanager.DefaultSecretManagerServiceClientFactory;
import com.google.cloud.spring.autoconfigure.secretmanager.GcpSecretManagerProperties;
import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataLoader;
import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataResource;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.secretmanager.SecretManagerServiceClientFactory;
import com.google.cloud.spring.secretmanager.SecretManagerSyntaxUtils;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class SecretManagerConfigDataLocationResolver
implements ConfigDataLocationResolver<SecretManagerConfigDataResource> {
    private static final Logger logger = LoggerFactory.getLogger(SecretManagerConfigDataLocationResolver.class);
    private static SecretManagerServiceClient secretManagerServiceClient;
    private static SecretManagerServiceClientFactory secretManagerServiceClientFactory;

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        Optional matchedPrefix = SecretManagerSyntaxUtils.getMatchedPrefixes(arg_0 -> ((ConfigDataLocation)location).hasPrefix(arg_0));
        SecretManagerSyntaxUtils.warnIfUsingDeprecatedSyntax((Logger)logger, (String)matchedPrefix.orElse(""));
        return matchedPrefix.isPresent();
    }

    public List<SecretManagerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        SecretManagerConfigDataLocationResolver.registerSecretManagerBeans(context);
        return Collections.singletonList(new SecretManagerConfigDataResource(location));
    }

    private static void registerSecretManagerBeans(ConfigDataLocationResolverContext context) {
        SecretManagerConfigDataLocationResolver.registerBean(context, GcpProperties.class, SecretManagerConfigDataLocationResolver.getGcpProperties(context));
        SecretManagerConfigDataLocationResolver.registerBean(context, GcpSecretManagerProperties.class, SecretManagerConfigDataLocationResolver.getSecretManagerProperties(context));
        SecretManagerConfigDataLocationResolver.registerBean(context, CredentialsProvider.class, SecretManagerConfigDataLocationResolver.getCredentialsProvider(context));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, SecretManagerServiceClientFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> SecretManagerConfigDataLocationResolver.createSecretManagerServiceClientFactory(context)));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, SecretManagerServiceClient.class, BootstrapRegistry.InstanceSupplier.from(() -> SecretManagerConfigDataLocationResolver.createSecretManagerClient(context)));
        SecretManagerConfigDataLocationResolver.registerBean(context, GcpProjectIdProvider.class, SecretManagerConfigDataLocationResolver.createProjectIdProvider(context));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, SecretManagerTemplate.class, BootstrapRegistry.InstanceSupplier.of((Object)SecretManagerConfigDataLocationResolver.createSecretManagerTemplate(context)));
    }

    private static GcpProperties getGcpProperties(ConfigDataLocationResolverContext context) {
        return (GcpProperties)context.getBinder().bind("spring.cloud.gcp", GcpProperties.class).orElse((Object)new GcpProperties());
    }

    private static GcpSecretManagerProperties getSecretManagerProperties(ConfigDataLocationResolverContext context) {
        return (GcpSecretManagerProperties)context.getBinder().bind("spring.cloud.gcp.secretmanager", GcpSecretManagerProperties.class).orElse((Object)new GcpSecretManagerProperties());
    }

    private static CredentialsProvider getCredentialsProvider(ConfigDataLocationResolverContext context) {
        try {
            GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
            return (CredentialsProvider)context.getBinder().bind("spring.cloud.gcp.secretmanager", CredentialsProvider.class).orElse((Object)new DefaultCredentialsProvider((CredentialsSupplier)properties));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the Secret Manager Client Factory for ConfigData loading.", e);
        }
    }

    @VisibleForTesting
    static GcpProjectIdProvider createProjectIdProvider(ConfigDataLocationResolverContext context) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        GcpSecretManagerProperties secretManagerProperties = (GcpSecretManagerProperties)bootstrapContext.get(GcpSecretManagerProperties.class);
        if (secretManagerProperties.getProjectId() != null) {
            return secretManagerProperties::getProjectId;
        }
        GcpProperties gcpProperties = (GcpProperties)bootstrapContext.get(GcpProperties.class);
        if (gcpProperties.getProjectId() != null) {
            return gcpProperties::getProjectId;
        }
        return new DefaultGcpProjectIdProvider();
    }

    @VisibleForTesting
    static synchronized SecretManagerServiceClient createSecretManagerClient(ConfigDataLocationResolverContext context) {
        if (secretManagerServiceClient != null && !secretManagerServiceClient.isTerminated()) {
            return secretManagerServiceClient;
        }
        try {
            GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
            DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider((CredentialsSupplier)properties);
            SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(SecretManagerConfigDataLoader.class))).build();
            secretManagerServiceClient = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
            return secretManagerServiceClient;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the Secret Manager Client for ConfigData loading.", e);
        }
    }

    @VisibleForTesting
    static synchronized SecretManagerServiceClientFactory createSecretManagerServiceClientFactory(ConfigDataLocationResolverContext context) {
        if (secretManagerServiceClientFactory != null) {
            return secretManagerServiceClientFactory;
        }
        return new DefaultSecretManagerServiceClientFactory((CredentialsProvider)context.getBootstrapContext().get(CredentialsProvider.class));
    }

    private static SecretManagerTemplate createSecretManagerTemplate(ConfigDataLocationResolverContext context) {
        SecretManagerServiceClient client = (SecretManagerServiceClient)context.getBootstrapContext().get(SecretManagerServiceClient.class);
        SecretManagerServiceClientFactory clientFactory = (SecretManagerServiceClientFactory)context.getBootstrapContext().get(SecretManagerServiceClientFactory.class);
        GcpProjectIdProvider projectIdProvider = (GcpProjectIdProvider)context.getBootstrapContext().get(GcpProjectIdProvider.class);
        GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
        if (clientFactory != null) {
            return new SecretManagerTemplate(clientFactory, projectIdProvider).setAllowDefaultSecretValue(properties.isAllowDefaultSecret());
        }
        return new SecretManagerTemplate(client, projectIdProvider).setAllowDefaultSecretValue(properties.isAllowDefaultSecret());
    }

    private static <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    private static <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        context.getBootstrapContext().registerIfAbsent(type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            String beanName = "gcp-secretmanager-config-data-" + type.getSimpleName();
            ConfigurableListableBeanFactory factory = event.getApplicationContext().getBeanFactory();
            if (!factory.containsSingleton(beanName)) {
                factory.registerSingleton(beanName, instance);
            }
        });
    }

    @VisibleForTesting
    static void setSecretManagerServiceClient(SecretManagerServiceClient client) {
        secretManagerServiceClient = client;
    }

    @VisibleForTesting
    static void setSecretManagerServiceClientFactory(SecretManagerServiceClientFactory clientFactory) {
        secretManagerServiceClientFactory = clientFactory;
    }
}

