/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.core.util;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.spring.core.Retry;

@InternalApi
public class RetryUtil {
    private RetryUtil() {
    }

    public static RetrySettings updateRetrySettings(RetrySettings oldRetrySettings, Retry newRetry) {
        RetrySettings.Builder builder = oldRetrySettings.toBuilder();
        if (newRetry.getTotalTimeout() != null) {
            builder.setTotalTimeout(newRetry.getTotalTimeout());
        }
        if (newRetry.getInitialRetryDelay() != null) {
            builder.setInitialRetryDelay(newRetry.getInitialRetryDelay());
        }
        if (newRetry.getRetryDelayMultiplier() != null) {
            builder.setRetryDelayMultiplier(newRetry.getRetryDelayMultiplier().doubleValue());
        }
        if (newRetry.getMaxRetryDelay() != null) {
            builder.setMaxRetryDelay(newRetry.getMaxRetryDelay());
        }
        if (newRetry.getMaxAttempts() != null) {
            builder.setMaxAttempts(newRetry.getMaxAttempts().intValue());
        }
        if (newRetry.getInitialRpcTimeout() != null) {
            builder.setInitialRpcTimeout(newRetry.getInitialRpcTimeout());
        }
        if (newRetry.getRpcTimeoutMultiplier() != null) {
            builder.setRpcTimeoutMultiplier(newRetry.getRpcTimeoutMultiplier().doubleValue());
        }
        if (newRetry.getMaxRpcTimeout() != null) {
            builder.setMaxRpcTimeout(newRetry.getMaxRpcTimeout());
        }
        return builder.build();
    }
}

