/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spring.data.spanner.core.ReadOnlyTransactionSpannerTemplate;
import com.google.cloud.spring.data.spanner.core.ReadWriteTransactionSpannerTemplate;
import com.google.cloud.spring.data.spanner.core.SpannerMutationFactory;
import com.google.cloud.spring.data.spanner.core.SpannerOperations;
import com.google.cloud.spring.data.spanner.core.SpannerPageableQueryOptions;
import com.google.cloud.spring.data.spanner.core.SpannerQueryOptions;
import com.google.cloud.spring.data.spanner.core.SpannerReadOptions;
import com.google.cloud.spring.data.spanner.core.SpannerTransactionManager;
import com.google.cloud.spring.data.spanner.core.admin.SpannerSchemaUtils;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import com.google.cloud.spring.data.spanner.core.mapping.event.AfterDeleteEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.AfterExecuteDmlEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.AfterQueryEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.AfterReadEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.AfterSaveEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.BeforeDeleteEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.BeforeExecuteDmlEvent;
import com.google.cloud.spring.data.spanner.core.mapping.event.BeforeSaveEvent;
import com.google.cloud.spring.data.spanner.repository.query.SpannerStatementQueryExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpannerTemplate
implements SpannerOperations,
ApplicationEventPublisherAware {
    private static final Log LOGGER = LogFactory.getLog(SpannerTemplate.class);
    private final Supplier<DatabaseClient> databaseClientProvider;
    private final SpannerMappingContext mappingContext;
    private final SpannerEntityProcessor spannerEntityProcessor;
    private final SpannerMutationFactory mutationFactory;
    private final SpannerSchemaUtils spannerSchemaUtils;
    @Nullable
    private ApplicationEventPublisher eventPublisher;

    public SpannerTemplate(Supplier<DatabaseClient> databaseClientProvider, SpannerMappingContext mappingContext, SpannerEntityProcessor spannerEntityProcessor, SpannerMutationFactory spannerMutationFactory, SpannerSchemaUtils spannerSchemaUtils) {
        Assert.notNull(databaseClientProvider, (String)"A valid database client for Spanner is required.");
        Assert.notNull((Object)((Object)mappingContext), (String)"A valid mapping context for Spanner is required.");
        Assert.notNull((Object)spannerEntityProcessor, (String)"A valid entity processor for Spanner is required.");
        Assert.notNull((Object)spannerMutationFactory, (String)"A valid Spanner mutation factory is required.");
        Assert.notNull((Object)spannerSchemaUtils, (String)"A valid Spanner schema utils is required.");
        this.databaseClientProvider = databaseClientProvider;
        this.mappingContext = mappingContext;
        this.spannerEntityProcessor = spannerEntityProcessor;
        this.mutationFactory = spannerMutationFactory;
        this.spannerSchemaUtils = spannerSchemaUtils;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    protected ReadContext getReadContext() {
        return this.doWithOrWithoutTransactionContext(x -> x, () -> ((DatabaseClient)this.databaseClientProvider.get()).singleUse());
    }

    protected ReadContext getReadContext(TimestampBound timestampBound) {
        return this.doWithOrWithoutTransactionContext(x -> x, () -> this.databaseClientProvider.get().singleUse(timestampBound));
    }

    public SpannerMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public SpannerEntityProcessor getSpannerEntityProcessor() {
        return this.spannerEntityProcessor;
    }

    @Override
    public long executeDmlStatement(Statement statement) {
        Assert.notNull((Object)statement, (String)"A non-null statement is required.");
        this.maybeEmitEvent(new BeforeExecuteDmlEvent(statement));
        long rowsAffected = this.doWithOrWithoutTransactionContext(x -> x.executeUpdate(statement, new Options.UpdateOption[0]), () -> (Long)this.databaseClientProvider.get().readWriteTransaction(new Options.TransactionOption[0]).run(transactionContext -> transactionContext.executeUpdate(statement, new Options.UpdateOption[0])));
        this.maybeEmitEvent(new AfterExecuteDmlEvent(statement, rowsAffected));
        return rowsAffected;
    }

    @Override
    public long executePartitionedDmlStatement(Statement statement) {
        return this.executePartitionedDmlStatement(statement, new Options.UpdateOption[0]);
    }

    @Override
    public long executePartitionedDmlStatement(Statement statement, Options.UpdateOption ... options) {
        Assert.notNull((Object)statement, (String)"A non-null statement is required.");
        Assert.notNull((Object)options, (String)"A non-null UpdateOption is required.");
        this.maybeEmitEvent(new BeforeExecuteDmlEvent(statement));
        long rowsAffected = this.doWithOrWithoutTransactionContext(x -> {
            throw new SpannerDataException("Cannot execute partitioned DML in a transaction.");
        }, () -> this.databaseClientProvider.get().executePartitionedUpdate(statement, options));
        this.maybeEmitEvent(new AfterExecuteDmlEvent(statement, rowsAffected));
        return rowsAffected;
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key) {
        return this.read(entityClass, key, null);
    }

    @Override
    public <T> boolean existsById(Class<T> entityClass, Key key) {
        Assert.notNull((Object)key, (String)"A non-null key is required.");
        SpannerPersistentEntity<?> persistentEntity = this.mappingContext.getPersistentEntityOrFail(entityClass);
        KeySet keys = KeySet.singleKey((Key)key);
        try (ResultSet resultSet = this.executeRead(persistentEntity.tableName(), keys, Collections.singleton(persistentEntity.getPrimaryKeyColumnName()), null);){
            this.maybeEmitEvent(new AfterReadEvent(Collections.emptyList(), keys, null));
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key, SpannerReadOptions options) {
        List<T> items = this.read(entityClass, KeySet.singleKey((Key)key), options);
        return items.isEmpty() ? null : (T)items.get(0);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys) {
        return this.read(entityClass, keys, null);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys, SpannerReadOptions options) {
        SpannerPersistentEntity<?> persistentEntity = this.mappingContext.getPersistentEntityOrFail(entityClass);
        List<Object> entities = persistentEntity.hasEagerlyLoadedProperties() || persistentEntity.hasWhere() ? this.executeReadQueryAndResolveChildren(keys, persistentEntity, SpannerTemplate.toQueryOption(keys, options), options != null ? options.getIndex() : null) : this.mapToListAndResolveChildren(this.executeRead(persistentEntity.tableName(), keys, persistentEntity.columns(), options), entityClass, options != null ? options.getIncludeProperties() : null, options != null && options.isAllowPartialRead());
        this.maybeEmitEvent(new AfterReadEvent(entities, keys, options));
        return entities;
    }

    private static SpannerQueryOptions toQueryOption(KeySet keys, SpannerReadOptions options) throws IllegalArgumentException {
        if (keys != null && keys.getRanges().iterator().hasNext()) {
            throw new IllegalArgumentException(String.format("KeySet %s has ranges", keys));
        }
        if (options == null) {
            return new SpannerQueryOptions();
        }
        return options.toQueryOptions();
    }

    @Override
    public <A> List<A> query(Function<Struct, A> rowFunc, Statement statement, SpannerQueryOptions options) {
        ArrayList<A> result = new ArrayList<A>();
        try (ResultSet resultSet = this.executeQuery(statement, options);){
            while (resultSet.next()) {
                result.add(rowFunc.apply(resultSet.getCurrentRowAsStruct()));
            }
        }
        this.maybeEmitEvent(new AfterQueryEvent(result, statement, options));
        return result;
    }

    @Override
    public <T> List<T> query(Class<T> entityClass, Statement statement, SpannerQueryOptions options) {
        List<T> entities = this.queryAndResolveChildren(entityClass, statement, options);
        this.maybeEmitEvent(new AfterQueryEvent(entities, statement, options));
        return entities;
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass, SpannerReadOptions options) {
        return this.read(entityClass, KeySet.all(), options);
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass) {
        return this.readAll(entityClass, null);
    }

    @Override
    public <T> List<T> queryAll(Class<T> entityClass, SpannerPageableQueryOptions options) {
        SpannerPersistentEntity<?> entity = this.mappingContext.getPersistentEntityOrFail(entityClass);
        String sql = "SELECT " + SpannerStatementQueryExecutor.getColumnsStringForSelect(entity, this.mappingContext, true) + " FROM " + entity.tableName() + SpannerStatementQueryExecutor.buildWhere(entity);
        return this.query(entityClass, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(SpannerStatementQueryExecutor.applySortingPagingQueryOptions(entityClass, options, sql, this.mappingContext, false), null, null, null, null, null), (SpannerQueryOptions)options);
    }

    @Override
    public void insert(Object object) {
        this.applySaveMutations(() -> this.mutationFactory.insert(object), Collections.singletonList(object), null);
    }

    @Override
    public void insertAll(Iterable<?> objects) {
        this.applySaveMutations(() -> this.getMutationsForMultipleObjects(objects, this.mutationFactory::insert), objects, null);
    }

    @Override
    public void update(Object object) {
        this.applySaveMutations(() -> this.mutationFactory.update(object, null), Collections.singletonList(object), null);
    }

    @Override
    public void updateAll(Iterable<?> objects) {
        this.applySaveMutations(() -> this.getMutationsForMultipleObjects(objects, x -> this.mutationFactory.update(x, null)), objects, null);
    }

    @Override
    public void update(Object object, String ... includeProperties) {
        HashSet<String> incl = includeProperties.length == 0 ? null : new HashSet<String>(Arrays.asList(includeProperties));
        this.applySaveMutations(() -> this.mutationFactory.update(object, incl), Collections.singletonList(object), incl);
    }

    @Override
    public void update(Object object, Set<String> includeProperties) {
        this.applySaveMutations(() -> this.mutationFactory.update(object, includeProperties), Collections.singletonList(object), includeProperties);
    }

    @Override
    public void upsert(Object object) {
        this.applySaveMutations(() -> this.mutationFactory.upsert(object, null), Collections.singletonList(object), null);
    }

    @Override
    public void upsertAll(Iterable<?> objects) {
        this.applySaveMutations(() -> this.getMutationsForMultipleObjects(objects, x -> this.mutationFactory.upsert(x, null)), objects, null);
    }

    @Override
    public void upsert(Object object, String ... includeProperties) {
        HashSet<String> incl = includeProperties.length == 0 ? null : new HashSet<String>(Arrays.asList(includeProperties));
        this.applySaveMutations(() -> this.mutationFactory.upsert(object, incl), Collections.singletonList(object), incl);
    }

    @Override
    public void upsert(Object object, Set<String> includeProperties) {
        this.applySaveMutations(() -> this.mutationFactory.upsert(object, includeProperties), Collections.singletonList(object), includeProperties);
    }

    private void applySaveMutations(Supplier<List<Mutation>> mutationsSupplier, Iterable<?> entities, Set<String> includeProperties) {
        this.maybeEmitEvent(new BeforeSaveEvent(entities, includeProperties));
        List<Mutation> mutations = mutationsSupplier.get();
        this.applyMutations(mutations);
        this.maybeEmitEvent(new AfterSaveEvent(mutations, entities, includeProperties));
    }

    @Override
    public void delete(Object entity) {
        this.applyDeleteMutations(Collections.singletonList(entity), Collections.singletonList(this.mutationFactory.delete(entity)));
    }

    @Override
    public void deleteAll(Iterable<?> objects) {
        this.applyDeleteMutations(objects, StreamSupport.stream(objects.spliterator(), false).map(this.mutationFactory::delete).collect(Collectors.toList()));
    }

    private void applyDeleteMutations(Iterable<?> objects, List<Mutation> mutations) {
        this.maybeEmitEvent(new BeforeDeleteEvent(mutations, objects, null, null));
        this.applyMutations(mutations);
        this.maybeEmitEvent(new AfterDeleteEvent(mutations, objects, null, null));
    }

    @Override
    public <T> void delete(Class<T> entityClass, Key key) {
        this.applyDeleteMutations(entityClass, KeySet.newBuilder().addKey(key).build(), Collections.singletonList(this.mutationFactory.delete(entityClass, key)));
    }

    @Override
    public <T> void delete(Class<T> entityClass, KeySet keys) {
        this.applyDeleteMutations(entityClass, keys, Collections.singletonList(this.mutationFactory.delete(entityClass, keys)));
    }

    private void applyDeleteMutations(Class<?> entityClass, KeySet keys, List<Mutation> mutations) {
        this.maybeEmitEvent(new BeforeDeleteEvent(mutations, null, keys, entityClass));
        this.applyMutations(mutations);
        this.maybeEmitEvent(new AfterDeleteEvent(mutations, null, keys, entityClass));
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        SpannerPersistentEntity<?> persistentEntity = this.mappingContext.getPersistentEntityOrFail(entityClass);
        Statement statement = Statement.of((String)String.format("SELECT COUNT(*) FROM %s", persistentEntity.tableName()));
        try (ResultSet resultSet = this.executeQuery(statement, null);){
            resultSet.next();
            long l = resultSet.getLong(0);
            return l;
        }
    }

    @Override
    public <T> T performReadWriteTransaction(final Function<SpannerTemplate, T> operations) {
        return (T)this.doWithOrWithoutTransactionContext(x -> {
            throw new IllegalStateException("There is already declarative transaction open. Spanner does not support nested transactions");
        }, () -> this.databaseClientProvider.get().readWriteTransaction(new Options.TransactionOption[0]).run(new TransactionRunner.TransactionCallable<T>(){

            @Nullable
            public T run(TransactionContext transaction) {
                ReadWriteTransactionSpannerTemplate transactionSpannerTemplate = new ReadWriteTransactionSpannerTemplate(SpannerTemplate.this.databaseClientProvider, SpannerTemplate.this.mappingContext, SpannerTemplate.this.spannerEntityProcessor, SpannerTemplate.this.mutationFactory, SpannerTemplate.this.spannerSchemaUtils, transaction);
                return operations.apply(transactionSpannerTemplate);
            }
        }));
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerTemplate, T> operations, SpannerReadOptions readOptions) {
        return (T)this.doWithOrWithoutTransactionContext(x -> {
            throw new IllegalStateException("There is already declarative transaction open. Spanner does not support nested transactions");
        }, () -> {
            SpannerReadOptions options = readOptions != null ? readOptions : new SpannerReadOptions();
            try (ReadOnlyTransaction readOnlyTransaction = options.getTimestampBound() != null ? this.databaseClientProvider.get().readOnlyTransaction(options.getTimestampBound()) : this.databaseClientProvider.get().readOnlyTransaction();){
                Object r = operations.apply(new ReadOnlyTransactionSpannerTemplate(this.databaseClientProvider, this.mappingContext, this.spannerEntityProcessor, this.mutationFactory, this.spannerSchemaUtils, readOnlyTransaction));
                return r;
            }
        });
    }

    public ResultSet executeQuery(Statement statement, SpannerQueryOptions options) {
        ResultSet resultSet = this.performQuery(statement, options);
        if (LOGGER.isDebugEnabled()) {
            Object message = options == null ? "Executing query without additional options: " + statement : this.getQueryLogMessageWithOptions(statement, options);
            LOGGER.debug(message);
        }
        return resultSet;
    }

    private String getQueryLogMessageWithOptions(Statement statement, SpannerQueryOptions options) {
        StringBuilder logSb = new StringBuilder("Executing query");
        if (options.getTimestampBound() != null) {
            logSb.append(" at timestamp ").append(options.getTimestampBound());
        }
        for (Options.QueryOption queryOption : (Options.QueryOption[])options.getOptions()) {
            logSb.append(" with option: ").append(queryOption);
        }
        logSb.append(" : ").append(statement);
        String message = logSb.toString();
        return message;
    }

    private ResultSet performQuery(Statement statement, SpannerQueryOptions options) {
        ResultSet resultSet = options == null ? this.getReadContext().executeQuery(statement, new Options.QueryOption[0]) : (options.getTimestampBound() != null ? this.getReadContext(options.getTimestampBound()) : this.getReadContext()).executeQuery(statement, (Options.QueryOption[])options.getOptions());
        return resultSet;
    }

    private <T> List<T> executeReadQueryAndResolveChildren(KeySet keys, SpannerPersistentEntity<T> persistentEntity, SpannerQueryOptions options, String index) {
        Statement statement = SpannerStatementQueryExecutor.buildQuery(keys, persistentEntity, this.spannerEntityProcessor.getWriteConverter(), this.mappingContext, index);
        return this.resolveChildEntities(this.query(persistentEntity.getType(), statement, options), options.getIncludeProperties());
    }

    private ResultSet executeRead(String tableName, KeySet keys, Iterable<String> columns, SpannerReadOptions options) {
        ReadContext readContext;
        long startTime = LOGGER.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        ReadContext readContext2 = readContext = options != null && options.getTimestampBound() != null ? this.getReadContext(options.getTimestampBound()) : this.getReadContext();
        ResultSet resultSet = options == null ? readContext.read(tableName, keys, columns, new Options.ReadOption[0]) : (options.getIndex() == null ? readContext.read(tableName, keys, columns, (Options.ReadOption[])options.getOptions()) : readContext.readUsingIndex(tableName, options.getIndex(), keys, columns, (Options.ReadOption[])options.getOptions()));
        if (LOGGER.isDebugEnabled()) {
            StringBuilder logs = this.logColumns(tableName, keys, columns);
            this.logReadOptions(options, logs);
            LOGGER.debug((Object)logs.toString());
            LOGGER.debug((Object)("Read elapsed milliseconds: " + (System.currentTimeMillis() - startTime)));
        }
        return resultSet;
    }

    private void logReadOptions(SpannerReadOptions options, StringBuilder logs) {
        if (options == null) {
            return;
        }
        if (options.getTimestampBound() != null) {
            logs.append(" at timestamp ").append(options.getTimestampBound());
        }
        for (Options.ReadOption readOption : (Options.ReadOption[])options.getOptions()) {
            logs.append(" with option: ").append(readOption);
        }
        if (options.getIndex() != null) {
            logs.append(" secondary index: ").append(options.getIndex());
        }
    }

    private StringBuilder logColumns(String tableName, KeySet keys, Iterable<String> columns) {
        StringBuilder logSb = new StringBuilder();
        logSb.append("Executing read on table ").append(tableName).append(" with keys: ").append(keys).append(" and columns: ");
        StringJoiner sj = new StringJoiner(", ");
        columns.forEach(sj::add);
        logSb.append(sj.toString());
        return logSb;
    }

    protected void applyMutations(Collection<Mutation> mutations) {
        LOGGER.debug((Object)("Applying Mutation: " + mutations));
        this.doWithOrWithoutTransactionContext(x -> {
            x.buffer((Iterable)mutations);
            return null;
        }, () -> {
            this.databaseClientProvider.get().write((Iterable)mutations);
            return null;
        });
    }

    private <T> List<T> queryAndResolveChildren(Class<T> entityClass, Statement statement, SpannerQueryOptions options) {
        return this.mapToListAndResolveChildren(this.executeQuery(statement, options), entityClass, options != null ? options.getIncludeProperties() : null, options != null && options.isAllowPartialRead());
    }

    private <T> List<T> mapToListAndResolveChildren(ResultSet resultSet, Class<T> entityClass, Set<String> includeProperties, boolean allowMissingColumns) {
        return this.resolveChildEntities(this.spannerEntityProcessor.mapToList(resultSet, entityClass, includeProperties, allowMissingColumns), includeProperties);
    }

    private <T> List<T> resolveChildEntities(List<T> entities, Set<String> includeProperties) {
        for (T entity : entities) {
            this.resolveChildEntity(entity, includeProperties);
        }
        return entities;
    }

    private void resolveChildEntity(Object entity, Set<String> includeProperties) {
        SpannerPersistentEntity<?> spannerPersistentEntity = this.mappingContext.getPersistentEntityOrFail(entity.getClass());
        PersistentPropertyAccessor accessor = spannerPersistentEntity.getPropertyAccessor(entity);
        spannerPersistentEntity.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (includeProperties != null && !includeProperties.contains(spannerPersistentEntity.getName())) {
                return;
            }
            List propertyValue = (List)accessor.getProperty(spannerPersistentProperty);
            if (propertyValue != null) {
                this.resolveChildEntities(propertyValue, null);
                return;
            }
            Class<?> childType = spannerPersistentProperty.getColumnInnerType();
            Supplier<List> getChildrenEntitiesFunc = () -> this.queryAndResolveChildren(childType, SpannerStatementQueryExecutor.getChildrenRowsQuery(this.spannerSchemaUtils.getKey(entity), spannerPersistentProperty, this.spannerEntityProcessor.getWriteConverter(), this.mappingContext), null);
            accessor.setProperty(spannerPersistentProperty, (Object)(spannerPersistentProperty.isLazyInterleaved() ? ConversionUtils.wrapSimpleLazyProxy(getChildrenEntitiesFunc, List.class) : getChildrenEntitiesFunc.get()));
        }));
    }

    private List<Mutation> getMutationsForMultipleObjects(Iterable<?> it, Function<Object, Collection<Mutation>> individualEntityMutationFunc) {
        return StreamSupport.stream(it.spliterator(), false).flatMap(x -> ((Collection)individualEntityMutationFunc.apply(x)).stream()).collect(Collectors.toList());
    }

    private TransactionContext getTransactionContext() {
        SpannerTransactionManager.Tx tx;
        if (TransactionSynchronizationManager.isActualTransactionActive() && (tx = (SpannerTransactionManager.Tx)TransactionSynchronizationManager.getResource((Object)this.databaseClientProvider.get())) != null && tx.getTransactionContext() != null) {
            return tx.getTransactionContext();
        }
        return null;
    }

    private <A> A doWithOrWithoutTransactionContext(Function<TransactionContext, A> funcWithTransactionContext, Supplier<A> funcWithoutTransactionContext) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext != null ? funcWithTransactionContext.apply(txContext) : funcWithoutTransactionContext.get();
    }

    private void maybeEmitEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }
}

