/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.kms;

import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import org.springframework.util.Assert;

final class KmsPropertyUtils {
    public static final String LOCATION_GLOBAL = "global";

    private KmsPropertyUtils() {
    }

    static CryptoKeyName getCryptoKeyName(String input, GcpProjectIdProvider projectIdProvider) {
        String keyId;
        String keyRingId;
        String locationId;
        String[] tokens = input.split("/");
        String projectId = projectIdProvider.getProjectId();
        if (tokens.length == 2) {
            locationId = LOCATION_GLOBAL;
            keyRingId = tokens[0];
            keyId = tokens[1];
        } else if (tokens.length == 3) {
            locationId = tokens[0];
            keyRingId = tokens[1];
            keyId = tokens[2];
        } else if (tokens.length == 4) {
            projectId = tokens[0];
            locationId = tokens[1];
            keyRingId = tokens[2];
            keyId = tokens[3];
        } else if (tokens.length == 8 && tokens[0].equals("projects") && tokens[2].equals("locations") && tokens[4].equals("keyRings") && tokens[6].equals("cryptoKeys")) {
            projectId = tokens[1];
            locationId = tokens[3];
            keyRingId = tokens[5];
            keyId = tokens[7];
        } else {
            throw new IllegalArgumentException("Unrecognized format for specifying a GCP KMS : " + input);
        }
        Assert.hasText((String)projectId, (String)("The GCP KMS project id must not be empty: " + input));
        Assert.hasText((String)locationId, (String)("The GCP KMS location id must not be empty: " + input));
        Assert.hasText((String)keyRingId, (String)("The GCP KMS keyRing id must not be empty: " + input));
        Assert.hasText((String)keyId, (String)("The GCP KMS key id must not be empty: " + input));
        return CryptoKeyName.newBuilder().setProject(projectId).setLocation(locationId).setKeyRing(keyRingId).setCryptoKey(keyId).build();
    }
}

