/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.kms;

import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.kms.v1.DecryptRequest;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.kms.KmsException;
import com.google.cloud.spring.kms.KmsOperations;
import com.google.cloud.spring.kms.KmsPropertyUtils;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import java.nio.charset.StandardCharsets;

public class KmsTemplate
implements KmsOperations {
    private final KeyManagementServiceClient client;
    private final GcpProjectIdProvider projectIdProvider;

    public KmsTemplate(KeyManagementServiceClient keyManagementServiceClient, GcpProjectIdProvider projectIdProvider) {
        this.client = keyManagementServiceClient;
        this.projectIdProvider = projectIdProvider;
    }

    @Override
    public byte[] encryptText(String cryptoKey, String text) {
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return this.encryptBytes(cryptoKey, bytes);
    }

    @Override
    public byte[] encryptBytes(String cryptoKey, byte[] bytes) {
        CryptoKeyName cryptoKeyName = KmsPropertyUtils.getCryptoKeyName(cryptoKey, this.projectIdProvider);
        long crc32c = this.longCrc32c(bytes);
        EncryptRequest request = EncryptRequest.newBuilder().setName(cryptoKeyName.toString()).setPlaintext(ByteString.copyFrom((byte[])bytes)).setPlaintextCrc32C(Int64Value.newBuilder().setValue(crc32c).build()).build();
        EncryptResponse response = this.client.encrypt(request);
        this.assertCrcMatch(response);
        return response.getCiphertext().toByteArray();
    }

    @Override
    public String decryptText(String cryptoKey, byte[] cipherText) {
        byte[] decryptedBytes = this.decryptBytes(cryptoKey, cipherText);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] decryptBytes(String cryptoKey, byte[] cipherText) {
        CryptoKeyName cryptoKeyName = KmsPropertyUtils.getCryptoKeyName(cryptoKey, this.projectIdProvider);
        ByteString encryptedByteString = ByteString.copyFrom((byte[])cipherText);
        long crc32c = this.longCrc32c(encryptedByteString);
        DecryptRequest request = DecryptRequest.newBuilder().setName(cryptoKeyName.toString()).setCiphertext(encryptedByteString).setCiphertextCrc32C(Int64Value.newBuilder().setValue(crc32c).build()).build();
        DecryptResponse response = this.client.decrypt(request);
        this.assertCrcMatch(response);
        return response.getPlaintext().toByteArray();
    }

    private long longCrc32c(ByteString plaintextByteString) {
        return this.longCrc32c(plaintextByteString.toByteArray());
    }

    private long longCrc32c(byte[] bytes) {
        return Hashing.crc32c().hashBytes(bytes).padToLong();
    }

    private void assertCrcMatch(EncryptResponse response) {
        long received;
        long expected = response.getCiphertextCrc32C().getValue();
        if (expected != (received = this.longCrc32c(response.getCiphertext()))) {
            throw new KmsException("Encryption: response from server corrupted");
        }
    }

    private void assertCrcMatch(DecryptResponse response) {
        long received;
        long expected = response.getPlaintextCrc32C().getValue();
        if (expected != (received = this.longCrc32c(response.getPlaintext()))) {
            throw new KmsException("Decryption : response from server corrupted");
        }
    }
}

