/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.stream.binder.pubsub;

import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherOperations;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberOperations;
import com.google.cloud.spring.pubsub.integration.PubSubHeaderMapper;
import com.google.cloud.spring.pubsub.integration.inbound.PubSubInboundChannelAdapter;
import com.google.cloud.spring.pubsub.integration.inbound.PubSubMessageSource;
import com.google.cloud.spring.pubsub.integration.outbound.PubSubMessageHandler;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubConsumerProperties;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubExtendedBindingProperties;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubProducerProperties;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubChannelProvisioner;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class PubSubMessageChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>, PubSubChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, PubSubConsumerProperties, PubSubProducerProperties> {
    private final PubSubTemplate pubSubTemplate;
    private final PubSubExtendedBindingProperties pubSubExtendedBindingProperties;
    private final PubSubChannelProvisioner pubSubChannelProvisioner;
    private HealthTrackerRegistry healthTrackerRegistry;

    public PubSubMessageChannelBinder(String[] headersToEmbed, PubSubChannelProvisioner provisioningProvider, PubSubTemplate pubSubTemplate, PubSubExtendedBindingProperties pubSubExtendedBindingProperties) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
        this.pubSubTemplate = pubSubTemplate;
        this.pubSubExtendedBindingProperties = pubSubExtendedBindingProperties;
        this.pubSubChannelProvisioner = provisioningProvider;
    }

    public void setHealthTrackerRegistry(HealthTrackerRegistry healthTrackerRegistry) {
        this.healthTrackerRegistry = healthTrackerRegistry;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<PubSubProducerProperties> producerProperties, MessageChannel errorChannel) {
        PubSubMessageHandler messageHandler = new PubSubMessageHandler((PubSubPublisherOperations)this.pubSubTemplate, destination.getName());
        PubSubProducerProperties props = (PubSubProducerProperties)producerProperties.getExtension();
        if (props != null && props.getAllowedHeaders() != null) {
            PubSubHeaderMapper headerMapper = new PubSubHeaderMapper();
            headerMapper.setOutboundHeaderPatterns(props.getAllowedHeaders());
            messageHandler.setHeaderMapper((HeaderMapper)headerMapper);
        }
        messageHandler.setBeanFactory((BeanFactory)this.getBeanFactory());
        messageHandler.setSync(((PubSubProducerProperties)producerProperties.getExtension()).isSync());
        return messageHandler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        PubSubInboundChannelAdapter adapter = new PubSubInboundChannelAdapter((PubSubSubscriberOperations)this.pubSubTemplate, destination.getName());
        PubSubConsumerProperties props = (PubSubConsumerProperties)properties.getExtension();
        if (props != null && props.getAllowedHeaders() != null) {
            PubSubHeaderMapper headerMapper = new PubSubHeaderMapper();
            headerMapper.setInboundHeaderPatterns(props.getAllowedHeaders());
            adapter.setHeaderMapper((HeaderMapper)headerMapper);
        }
        if (this.healthTrackerRegistry != null) {
            adapter.setHealthTrackerRegistry(this.healthTrackerRegistry);
        }
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, group, (ConsumerProperties)properties);
        adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        adapter.setAckMode(((PubSubConsumerProperties)properties.getExtension()).getAckMode());
        adapter.setBeanFactory((BeanFactory)this.getBeanFactory());
        return adapter;
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        return destination.getName() + ".errors";
    }

    public PubSubConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (PubSubConsumerProperties)this.pubSubExtendedBindingProperties.getExtendedConsumerProperties(channelName);
    }

    public PubSubProducerProperties getExtendedProducerProperties(String channelName) {
        return (PubSubProducerProperties)this.pubSubExtendedBindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.pubSubExtendedBindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.pubSubExtendedBindingProperties.getExtendedPropertiesEntryClass();
    }

    protected void afterUnbindConsumer(ConsumerDestination destination, String group, ExtendedConsumerProperties<PubSubConsumerProperties> consumerProperties) {
        super.afterUnbindConsumer(destination, group, consumerProperties);
        this.pubSubChannelProvisioner.afterUnbindConsumer(destination);
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<PubSubConsumerProperties> consumerProperties) {
        PubSubMessageSource source = this.createPubSubMessageSource(destination, consumerProperties);
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)source, this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true));
    }

    protected PubSubMessageSource createPubSubMessageSource(ConsumerDestination destination, ExtendedConsumerProperties<PubSubConsumerProperties> consumerProperties) {
        PubSubMessageSource source = new PubSubMessageSource((PubSubSubscriberOperations)this.pubSubTemplate, destination.getName());
        source.setMaxFetchSize(((PubSubConsumerProperties)consumerProperties.getExtension()).getMaxFetchSize().intValue());
        return source;
    }
}

