/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration.inbound;

import com.google.cloud.spring.storage.integration.GcsFileInfo;
import com.google.cloud.spring.storage.integration.filters.GcsPersistentAcceptOnceFileListFilter;
import com.google.cloud.storage.BlobInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.AbstractRemoteFileStreamingMessageSource;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class GcsStreamingMessageSource
extends AbstractRemoteFileStreamingMessageSource<BlobInfo> {
    public GcsStreamingMessageSource(RemoteFileTemplate<BlobInfo> template) {
        this(template, null);
    }

    public GcsStreamingMessageSource(RemoteFileTemplate<BlobInfo> template, Comparator<BlobInfo> comparator) {
        super(template, comparator);
        this.doSetFilter((FileListFilter)new GcsPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "gcsStreamingMessageSource"));
    }

    public String getComponentType() {
        return "gcp:gcs-inbound-streaming-channel-adapter";
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        throw new UnsupportedOperationException("Google Cloud Storage doesn't support separators other than '/'.");
    }

    protected List<AbstractFileInfo<BlobInfo>> asFileInfoList(Collection<BlobInfo> collection) {
        return collection.stream().map(GcsFileInfo::new).collect(Collectors.toList());
    }

    protected boolean isDirectory(BlobInfo blobInfo) {
        return blobInfo.isDirectory();
    }
}

