/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.springdata;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.r2dbc.springdata.JsonToMapConverter;
import com.google.cloud.spanner.r2dbc.springdata.MapToJsonConverter;
import com.google.cloud.spanner.r2dbc.springdata.SpannerArrayColumns;
import com.google.cloud.spanner.r2dbc.v2.JsonWrapper;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;

public class SpannerR2dbcDialect
extends AbstractDialect
implements R2dbcDialect {
    static final BindMarkersFactory NAMED = BindMarkersFactory.named((String)"@", (String)"val", (int)32);
    public static final String SQL_LIMIT = "LIMIT ";
    private Gson gson = new Gson();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        public String getLimit(long limit) {
            return SpannerR2dbcDialect.SQL_LIMIT + limit;
        }

        public String getOffset(long offset) {
            return "LIMIT 9223372036854775807 OFFSET " + offset;
        }

        public String getLimitOffset(long limit, long offset) {
            return SpannerR2dbcDialect.SQL_LIMIT + limit + " OFFSET " + offset;
        }

        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final LockClause LOCK_CLAUSE = new LockClause(){

        public String getLock(LockOptions lockOptions) {
            return "";
        }

        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_FROM_TABLE;
        }
    };

    public BindMarkersFactory getBindMarkersFactory() {
        return NAMED;
    }

    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    public Collection<? extends Class<?>> getSimpleTypes() {
        return Arrays.asList(JsonWrapper.class, Timestamp.class, ByteArray.class, Date.class);
    }

    public Collection<Object> getConverters() {
        return Arrays.asList(new JsonToMapConverter(this.gson), new MapToJsonConverter(this.gson));
    }

    public ArrayColumns getArraySupport() {
        return new SpannerArrayColumns();
    }
}

