/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class CredentialRetrieverFactory {
    private static final String OAUTH_SCOPE_STORAGE_READ_WRITE = "https://www.googleapis.com/auth/devstorage.read_write";
    private static final ImmutableMap<String, String> WELL_KNOWN_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"docker-credential-gcr", (Object)"amazonaws.com", (Object)"docker-credential-ecr-login");
    private final ImageReference imageReference;
    private final Consumer<LogEvent> logger;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final GoogleCredentialsProvider googleCredentialsProvider;
    private final Map<String, String> environment;

    public static CredentialRetrieverFactory forImage(ImageReference imageReference, Consumer<LogEvent> logger) {
        return new CredentialRetrieverFactory(imageReference, logger, DockerCredentialHelper::new, GoogleCredentials::getApplicationDefault, Collections.emptyMap());
    }

    public static CredentialRetrieverFactory forImage(ImageReference imageReference, Consumer<LogEvent> logger, Map<String, String> environment) {
        return new CredentialRetrieverFactory(imageReference, logger, DockerCredentialHelper::new, GoogleCredentials::getApplicationDefault, environment);
    }

    @VisibleForTesting
    CredentialRetrieverFactory(ImageReference imageReference, Consumer<LogEvent> logger, DockerCredentialHelperFactory dockerCredentialHelperFactory, GoogleCredentialsProvider googleCredentialsProvider, Map<String, String> environment) {
        this.imageReference = imageReference;
        this.logger = logger;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.googleCredentialsProvider = googleCredentialsProvider;
        this.environment = environment;
    }

    public CredentialRetriever known(Credential credential, String credentialSource) {
        return () -> {
            this.logGotCredentialsFrom("credentials from " + credentialSource);
            return Optional.of(credential);
        };
    }

    public CredentialRetriever dockerCredentialHelper(String credentialHelper) {
        return this.dockerCredentialHelper(Paths.get(credentialHelper, new String[0]));
    }

    public CredentialRetriever dockerCredentialHelper(Path credentialHelper) {
        return () -> {
            try {
                return Optional.of(this.retrieveFromDockerCredentialHelper(credentialHelper));
            }
            catch (CredentialHelperUnhandledServerUrlException ex) {
                this.logger.accept(LogEvent.info("No credentials for " + this.imageReference.getRegistry() + " in " + credentialHelper));
                return Optional.empty();
            }
            catch (IOException ex) {
                throw new CredentialRetrievalException(ex);
            }
        };
    }

    public CredentialRetriever wellKnownCredentialHelpers() {
        return () -> {
            for (Map.Entry entry : WELL_KNOWN_CREDENTIAL_HELPERS.entrySet()) {
                try {
                    String registrySuffix = (String)entry.getKey();
                    if (!this.imageReference.getRegistry().endsWith(registrySuffix)) continue;
                    String credentialHelper = (String)entry.getValue();
                    return Optional.of(this.retrieveFromDockerCredentialHelper(Paths.get(credentialHelper, new String[0])));
                }
                catch (CredentialHelperNotFoundException | CredentialHelperUnhandledServerUrlException ex) {
                    if (ex.getMessage() == null) continue;
                    this.logger.accept(LogEvent.info(ex.getMessage()));
                    if (ex.getCause() == null || ex.getCause().getMessage() == null) continue;
                    this.logger.accept(LogEvent.info("  Caused by: " + ex.getCause().getMessage()));
                }
                catch (IOException ex) {
                    throw new CredentialRetrievalException(ex);
                }
            }
            return Optional.empty();
        };
    }

    public CredentialRetriever dockerConfig() {
        return this.dockerConfig(DockerConfigCredentialRetriever.create(this.imageReference.getRegistry(), Paths.get(System.getProperty("user.home"), ".docker", "config.json")));
    }

    public CredentialRetriever dockerConfig(Path dockerConfigFile) {
        return this.dockerConfig(DockerConfigCredentialRetriever.create(this.imageReference.getRegistry(), dockerConfigFile));
    }

    public CredentialRetriever legacyDockerConfig(Path dockerConfigFile) {
        return this.dockerConfig(DockerConfigCredentialRetriever.createForLegacyFormat(this.imageReference.getRegistry(), dockerConfigFile));
    }

    public CredentialRetriever googleApplicationDefaultCredentials() {
        return () -> {
            try {
                if (this.imageReference.getRegistry().endsWith("gcr.io") || this.imageReference.getRegistry().endsWith("docker.pkg.dev")) {
                    GoogleCredentials googleCredentials = this.googleCredentialsProvider.get();
                    this.logger.accept(LogEvent.info("Google ADC found"));
                    if (googleCredentials.createScopedRequired()) {
                        this.logger.accept(LogEvent.info("ADC is a service account. Setting GCS read-write scope"));
                        List<String> scope = Collections.singletonList(OAUTH_SCOPE_STORAGE_READ_WRITE);
                        googleCredentials = googleCredentials.createScoped(scope);
                    }
                    googleCredentials.refreshIfExpired();
                    this.logGotCredentialsFrom("Google Application Default Credentials");
                    AccessToken accessToken = googleCredentials.getAccessToken();
                    return Optional.of(Credential.from("oauth2accesstoken", accessToken.getTokenValue()));
                }
            }
            catch (IOException ex) {
                this.logger.accept(LogEvent.info("ADC not present or error fetching access token: " + ex.getMessage()));
            }
            return Optional.empty();
        };
    }

    @VisibleForTesting
    CredentialRetriever dockerConfig(DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        return () -> {
            Path configFile = dockerConfigCredentialRetriever.getDockerConfigFile();
            try {
                Optional<Credential> credentials = dockerConfigCredentialRetriever.retrieve(this.logger);
                if (credentials.isPresent()) {
                    this.logGotCredentialsFrom("credentials from Docker config (" + configFile + ")");
                    return credentials;
                }
            }
            catch (IOException ex) {
                this.logger.accept(LogEvent.info("Unable to parse Docker config file: " + configFile));
            }
            return Optional.empty();
        };
    }

    private Credential retrieveFromDockerCredentialHelper(Path credentialHelper) throws CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException, IOException {
        Credential credentials = this.dockerCredentialHelperFactory.create(this.imageReference.getRegistry(), credentialHelper, this.environment).retrieve();
        this.logGotCredentialsFrom("credential helper " + credentialHelper.getFileName().toString());
        return credentials;
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.logger.accept(LogEvent.lifecycle("Using " + credentialSource + " for " + this.imageReference));
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface GoogleCredentialsProvider {
        public GoogleCredentials get() throws IOException;
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface DockerCredentialHelperFactory {
        public DockerCredentialHelper create(String var1, Path var2, Map<String, String> var3);
    }
}

