/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;

public class LayerEntry {
    private final Path sourceFile;
    private final AbsoluteUnixPath extractionPath;
    private final FilePermissions permissions;
    private final Instant modificationTime;

    public LayerEntry(Path sourceFile, AbsoluteUnixPath extractionPath, FilePermissions permissions, Instant modificationTime) {
        this.sourceFile = sourceFile;
        this.extractionPath = extractionPath;
        this.permissions = permissions;
        this.modificationTime = modificationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public AbsoluteUnixPath getExtractionPath() {
        return this.extractionPath;
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LayerEntry)) {
            return false;
        }
        LayerEntry otherLayerEntry = (LayerEntry)other;
        return this.sourceFile.equals(otherLayerEntry.sourceFile) && this.extractionPath.equals(otherLayerEntry.extractionPath) && Objects.equals(this.permissions, otherLayerEntry.permissions) && Objects.equals(this.modificationTime, otherLayerEntry.modificationTime);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.extractionPath, this.permissions, this.modificationTime);
    }
}

