/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.filesystem.UnixPathParser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RelativeUnixPath {
    private final ImmutableList<String> pathComponents;

    public static RelativeUnixPath get(String relativePath) {
        Preconditions.checkArgument((!relativePath.startsWith("/") ? 1 : 0) != 0, (Object)("Path starts with forward slash (/): " + relativePath));
        return new RelativeUnixPath(UnixPathParser.parse(relativePath));
    }

    private RelativeUnixPath(ImmutableList<String> pathComponents) {
        this.pathComponents = pathComponents;
    }

    ImmutableList<String> getRelativePathComponents() {
        return this.pathComponents;
    }
}

