/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class PushLayerStep
implements Callable<BlobDescriptor> {
    private final BuildContext buildContext;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final RegistryClient registryClient;
    private final Future<PreparedLayer> preparedLayer;

    static ImmutableList<PushLayerStep> makeList(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, List<Future<PreparedLayer>> cachedLayers) {
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Preparing layer pushers");){
            ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("launching layer pushers", cachedLayers.size());
            try {
                ImmutableList immutableList = (ImmutableList)cachedLayers.stream().map(layer -> new PushLayerStep(buildContext, progressEventDispatcher.newChildProducer(), registryClient, (Future<PreparedLayer>)layer)).collect(ImmutableList.toImmutableList());
                if (progressEventDispatcher != null) {
                    progressEventDispatcher.close();
                }
                return immutableList;
            }
            catch (Throwable throwable) {
                if (progressEventDispatcher != null) {
                    try {
                        progressEventDispatcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private PushLayerStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, RegistryClient registryClient, Future<PreparedLayer> preparedLayer) {
        this.buildContext = buildContext;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryClient = registryClient;
        this.preparedLayer = preparedLayer;
    }

    @Override
    public BlobDescriptor call() throws IOException, RegistryException, ExecutionException, InterruptedException {
        PreparedLayer layer = this.preparedLayer.get();
        if (layer.getStateInTarget() == PreparedLayer.StateInTarget.EXISTING) {
            return layer.getBlobDescriptor();
        }
        boolean forcePush = layer.getStateInTarget() == PreparedLayer.StateInTarget.MISSING;
        return new PushBlobStep(this.buildContext, this.progressEventDispatcherFactory, this.registryClient, layer.getBlobDescriptor(), layer.getBlob(), forcePush).call();
    }
}

