/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.cloud.trace.core.TraceOptions;
import com.google.cloud.trace.core.TraceOptionsFactory;
import java.security.SecureRandom;
import java.util.Random;

public class NaiveSamplingTraceOptionsFactory
implements TraceOptionsFactory {
    private final Random random;
    private final double samplingRate;
    private final boolean stackTraceEnabled;

    public NaiveSamplingTraceOptionsFactory(Random random, double samplingRate, boolean stackTraceEnabled) {
        this.random = random;
        this.samplingRate = samplingRate;
        this.stackTraceEnabled = stackTraceEnabled;
    }

    public NaiveSamplingTraceOptionsFactory(double samplingRate, boolean stackTraceEnabled) {
        this(new SecureRandom(), samplingRate, stackTraceEnabled);
    }

    @Override
    public TraceOptions create() {
        boolean traceEnabled = this.random.nextDouble() <= this.samplingRate;
        return new TraceOptions().overrideTraceEnabled(traceEnabled).overrideStackTraceEnabled(this.stackTraceEnabled);
    }

    @Override
    public TraceOptions create(TraceOptions traceOptions) {
        return traceOptions;
    }
}

