/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.cloud.trace.core.IdFactory;
import com.google.cloud.trace.core.RandomSpanIdFactory;
import com.google.cloud.trace.core.RandomTraceIdFactory;
import com.google.cloud.trace.core.SpanContext;
import com.google.cloud.trace.core.SpanId;
import com.google.cloud.trace.core.TraceId;
import com.google.cloud.trace.core.TraceOptions;
import com.google.cloud.trace.core.TraceOptionsFactory;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigInteger;

public class SpanContextFactory {
    private final TraceOptionsFactory traceOptionsFactory;
    private final IdFactory<TraceId> traceIdFactory;
    private final IdFactory<SpanId> spanIdFactory;

    public static String headerKey() {
        return "X-Cloud-Trace-Context";
    }

    public SpanContextFactory(TraceOptionsFactory traceOptionsFactory) {
        this(traceOptionsFactory, new RandomTraceIdFactory(), new RandomSpanIdFactory());
    }

    public SpanContextFactory(TraceOptionsFactory traceOptionsFactory, IdFactory<TraceId> traceIdFactory, IdFactory<SpanId> spanIdFactory) {
        this.traceOptionsFactory = traceOptionsFactory;
        this.traceIdFactory = traceIdFactory;
        this.spanIdFactory = spanIdFactory;
    }

    public SpanContext childContext(SpanContext parentContext) {
        if (parentContext.getTraceId().isValid()) {
            return new SpanContext(parentContext.getTraceId(), this.spanIdFactory.nextId(), this.traceOptionsFactory.create(parentContext.getTraceOptions()));
        }
        return new SpanContext(this.traceIdFactory.nextId(), this.spanIdFactory.nextId(), this.traceOptionsFactory.create());
    }

    public SpanContext initialContext() {
        return new SpanContext(TraceId.invalid(), SpanId.invalid(), new TraceOptions());
    }

    public SpanContext fromHeader(String header) {
        int index = header.indexOf(47);
        if (index == -1) {
            TraceId traceId = this.parseTraceId(header);
            return new SpanContext(traceId, SpanId.invalid(), this.traceOptionsFactory.create());
        }
        TraceId traceId = this.parseTraceId(header.substring(0, index));
        if (!traceId.isValid()) {
            return new SpanContext(traceId, SpanId.invalid(), this.traceOptionsFactory.create());
        }
        String[] afterTraceId = header.substring(index + 1).split(";");
        SpanId spanId = this.parseSpanId(afterTraceId[0]);
        TraceOptions traceOptions = null;
        for (int i = 1; i < afterTraceId.length; ++i) {
            if (!afterTraceId[i].startsWith("o=")) continue;
            traceOptions = this.parseTraceOptions(afterTraceId[i].substring(2));
        }
        if (traceOptions == null) {
            traceOptions = this.traceOptionsFactory.create();
        }
        return new SpanContext(traceId, spanId, traceOptions);
    }

    private TraceId parseTraceId(String input) {
        try {
            return new TraceId(new BigInteger(input, 16));
        }
        catch (NumberFormatException ex) {
            return TraceId.invalid();
        }
    }

    private SpanId parseSpanId(String input) {
        try {
            return new SpanId(UnsignedLongs.parseUnsignedLong((String)input));
        }
        catch (NumberFormatException ex) {
            return SpanId.invalid();
        }
    }

    private TraceOptions parseTraceOptions(String input) {
        try {
            return this.traceOptionsFactory.create(new TraceOptions(Integer.parseInt(input)));
        }
        catch (NumberFormatException ex) {
            return this.traceOptionsFactory.create();
        }
    }

    public static String toHeader(SpanContext context) {
        StringBuilder builder = new StringBuilder().append(context.getTraceId().getApiString()).append('/').append(context.getSpanId().getApiString()).append(";o=").append(context.getTraceOptions().getOptionsMask());
        return builder.toString();
    }
}

