/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class StackFrame {
    private final String className;
    private final String methodName;
    private final String fileName;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public StackFrame(String className, String methodName, String fileName, Integer lineNumber, Integer columnNumber) {
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackFrame)) {
            return false;
        }
        StackFrame that = (StackFrame)obj;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.lineNumber, that.lineNumber) && Objects.equals(this.columnNumber, that.columnNumber);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.fileName, this.lineNumber, this.columnNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("className", (Object)this.className).add("methodName", (Object)this.methodName).add("fileName", (Object)this.fileName).add("lineNumber", (Object)this.lineNumber).add("columnNumber", (Object)this.columnNumber).toString();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }
}

