/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class TraceOptions {
    private static final int TRACE_ENABLED = 1;
    private static final int STACK_TRACE_ENABLED = 2;
    private final int optionsMask;

    public static TraceOptions forTraceDisabled() {
        return new TraceOptions();
    }

    public static TraceOptions forTraceEnabled() {
        return new TraceOptions(1);
    }

    public TraceOptions() {
        this(0);
    }

    public TraceOptions(int optionsMask) {
        this.optionsMask = optionsMask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceOptions)) {
            return false;
        }
        TraceOptions that = (TraceOptions)obj;
        return Objects.equals(this.optionsMask, that.optionsMask);
    }

    public int hashCode() {
        return Objects.hash(this.optionsMask);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("optionsMask", this.optionsMask).toString();
    }

    public int getOptionsMask() {
        return this.optionsMask;
    }

    public boolean getTraceEnabled() {
        return this.applyMask(1);
    }

    public boolean getStackTraceEnabled() {
        return this.applyMask(2);
    }

    public TraceOptions overrideTraceEnabled(boolean enabled) {
        return new TraceOptions(enabled ? this.set(1) : this.clear(1));
    }

    public TraceOptions overrideStackTraceEnabled(boolean enabled) {
        return new TraceOptions(enabled ? this.set(2) : this.clear(2));
    }

    private boolean applyMask(int optionsMask) {
        return (this.optionsMask & optionsMask) != 0;
    }

    private int clear(int optionsMask) {
        return this.optionsMask & ~optionsMask;
    }

    private int set(int optionsMask) {
        return this.optionsMask | optionsMask;
    }
}

