/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Nullable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Objects {
    private Objects() {
    }

    public static int deepHashCode(@Nullable Object o) {
        if (o == null) {
            return 0;
        }
        if (!o.getClass().isArray()) {
            return o.hashCode();
        }
        if (o instanceof Object[]) {
            return Arrays.deepHashCode((Object[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        throw new AssertionError();
    }

    public static String deepToString(@Nullable Object o) {
        if (o == null) {
            return String.valueOf(o);
        }
        if (!o.getClass().isArray()) {
            return o.toString();
        }
        if (o instanceof Object[]) {
            return Arrays.deepToString((Object[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        throw new AssertionError();
    }

    public static boolean deepEquals(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> type1 = o1.getClass();
        Class<?> type2 = o2.getClass();
        if (!type1.isArray() || !type2.isArray()) {
            return o1.equals(o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
        if (type1 != type2) {
            return false;
        }
        if (o1 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        throw new AssertionError();
    }

    public static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static <T> T nonNull(T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    public static <T> T nonNull(T o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
        return o;
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Objects.nonNull(second);
    }
}

