/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Constraint;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constraints {
    public static final Constraint<Object> NOT_NULL = new NotNullConstraint();
    private static final long serialVersionUID = -7523018223761091862L;

    private Constraints() {
    }

    static Constraint<Object> classConstraint(Class<?> type) {
        return new ClassConstraint(type);
    }

    public static <E> Collection<E> constrainedCollection(Collection<E> collection, Constraint<? super E> constraint) {
        return new ConstrainedCollection<E>(collection, constraint);
    }

    public static <E> Set<E> constrainedSet(Set<E> set, Constraint<? super E> constraint) {
        return new ConstrainedSet<E>(set, constraint);
    }

    public static <E> SortedSet<E> constrainedSortedSet(SortedSet<E> sortedSet, Constraint<? super E> constraint) {
        return new ConstrainedSortedSet<E>(sortedSet, constraint);
    }

    public static <E> List<E> constrainedList(List<E> list, Constraint<? super E> constraint) {
        return list instanceof RandomAccess ? new ConstrainedRandomAccessList<E>(list, constraint) : new ConstrainedList<E>(list, constraint);
    }

    private static <E> ListIterator<E> constrainedListIterator(ListIterator<E> listIterator, Constraint<? super E> constraint) {
        return new ConstrainedListIterator<E>(listIterator, constraint);
    }

    static <E> Collection<E> constrainedTypePreservingCollection(Collection<E> collection, Constraint<E> constraint) {
        if (collection instanceof SortedSet) {
            return Constraints.constrainedSortedSet((SortedSet)collection, constraint);
        }
        if (collection instanceof Set) {
            return Constraints.constrainedSet((Set)collection, constraint);
        }
        if (collection instanceof List) {
            return Constraints.constrainedList((List)collection, constraint);
        }
        return Constraints.constrainedCollection(collection, constraint);
    }

    public static <E> Multiset<E> constrainedMultiset(Multiset<E> multiset, Constraint<? super E> constraint) {
        return new ConstrainedMultiset<E>(multiset, constraint);
    }

    private static <E> Collection<E> checkElements(Collection<E> elements, Constraint<? super E> constraint) {
        ArrayList<E> copy = Lists.newArrayList(elements);
        for (Object element : copy) {
            constraint.checkElement(element);
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedMultiset<E>
    extends ForwardingMultiset<E> {
        private final Constraint<? super E> constraint;

        public ConstrainedMultiset(Multiset<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public boolean add(E element) {
            this.constraint.checkElement(element);
            return super.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return super.addAll(Constraints.checkElements(elements, this.constraint));
        }

        @Override
        public boolean add(E element, int occurrences) {
            this.constraint.checkElement(element);
            return super.add(element, occurrences);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedListIterator<E>
    extends ForwardingListIterator<E> {
        private final Constraint<? super E> constraint;

        public ConstrainedListIterator(ListIterator<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public void add(E element) {
            this.constraint.checkElement(element);
            super.add(element);
        }

        @Override
        public void set(E element) {
            this.constraint.checkElement(element);
            super.set(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedRandomAccessList<E>
    extends ConstrainedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 2847441657918308440L;

        ConstrainedRandomAccessList(List<E> delegate, Constraint<? super E> constraint) {
            super(delegate, constraint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedList<E>
    extends ForwardingList<E> {
        final Constraint<? super E> constraint;
        private static final long serialVersionUID = 771378862182031456L;

        ConstrainedList(List<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public boolean add(E element) {
            this.constraint.checkElement(element);
            return super.add(element);
        }

        @Override
        public void add(int index, E element) {
            this.constraint.checkElement(element);
            super.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return super.addAll(Constraints.checkElements(elements, this.constraint));
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> elements) {
            return super.addAll(index, Constraints.checkElements(elements, this.constraint));
        }

        @Override
        public ListIterator<E> listIterator() {
            return Constraints.constrainedListIterator(super.listIterator(), this.constraint);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return Constraints.constrainedListIterator(super.listIterator(index), this.constraint);
        }

        @Override
        public E set(int index, E element) {
            this.constraint.checkElement(element);
            return super.set(index, element);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Constraints.constrainedList(super.subList(fromIndex, toIndex), this.constraint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedSortedSet<E>
    extends ForwardingSortedSet<E> {
        final Constraint<? super E> constraint;
        private static final long serialVersionUID = -286522409869875345L;

        ConstrainedSortedSet(SortedSet<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return Constraints.constrainedSortedSet(super.headSet(toElement), this.constraint);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return Constraints.constrainedSortedSet(super.subSet(fromElement, toElement), this.constraint);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return Constraints.constrainedSortedSet(super.tailSet(fromElement), this.constraint);
        }

        @Override
        public boolean add(E element) {
            this.constraint.checkElement(element);
            return super.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return super.addAll(Constraints.checkElements(elements, this.constraint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedSet<E>
    extends ForwardingSet<E> {
        private final Constraint<? super E> constraint;
        private static final long serialVersionUID = -830337517974610109L;

        public ConstrainedSet(Set<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public boolean add(E element) {
            this.constraint.checkElement(element);
            return super.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return super.addAll(Constraints.checkElements(elements, this.constraint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedCollection<E>
    extends ForwardingCollection<E> {
        private final Constraint<? super E> constraint;
        private static final long serialVersionUID = 8917285124050266452L;

        public ConstrainedCollection(Collection<E> delegate, Constraint<? super E> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public boolean add(E element) {
            this.constraint.checkElement(element);
            return super.add(element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            return super.addAll(Constraints.checkElements(elements, this.constraint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassConstraint
    implements Constraint<Object>,
    Serializable {
        private final Class<?> type;
        private static final long serialVersionUID = -4064640599187669705L;

        public ClassConstraint(Class<?> type) {
            this.type = Preconditions.checkNotNull(type);
        }

        @Override
        public void checkElement(Object element) {
            if (!this.type.isInstance(element)) {
                throw new ClassCastException("Attempt to insert " + element.getClass() + " element into collection with element " + "type " + this.type);
            }
        }

        @Override
        public String toString() {
            return "Instance of " + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NotNullConstraint
    implements Constraint<Object>,
    Serializable {
        private static final long serialVersionUID = 8771569713494573120L;

        NotNullConstraint() {
        }

        @Override
        public void checkElement(Object element) {
            Preconditions.checkNotNull(element);
        }

        private Object readResolve() {
            return NOT_NULL;
        }

        @Override
        public String toString() {
            return "Not null";
        }
    }
}

