/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private static final ImmutableList<?> EMPTY_IMMUTABLE_LIST = new EmptyImmutableList();
    private static final long serialVersionUID = 0L;

    public static <E> ImmutableList<E> of() {
        return EMPTY_IMMUTABLE_LIST;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new RegularImmutableList(new Object[]{Preconditions.checkNotNull(element)});
    }

    public static <E> ImmutableList<E> of(E ... elements) {
        return elements.length == 0 ? ImmutableList.of() : new RegularImmutableList(ImmutableList.copyIntoArray(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableList) {
            ImmutableList list = (ImmutableList)elements;
            return list;
        }
        int size = Iterables.size(elements);
        return size == 0 ? ImmutableList.of() : new RegularImmutableList(ImmutableList.copyIntoArray(elements, size));
    }

    private ImmutableList() {
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return super.indexOf(object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return super.lastIndexOf(object);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return super.contains(object);
    }

    private static Object[] copyIntoArray(Object[] source) {
        Object[] array = new Object[source.length];
        int index = 0;
        for (Object element : source) {
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        return array;
    }

    private static Object[] copyIntoArray(Iterable<?> source, int size) {
        Object[] array = new Object[size];
        int index = 0;
        for (Object element : source) {
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularImmutableList<E>
    extends ImmutableList<E> {
        private final Object[] array;

        private RegularImmutableList(Object[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object target) {
            return this.indexOf(target) != -1;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.forArray(this.array);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.size()];
            System.arraycopy(this.array, 0, newArray, 0, this.size());
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] other) {
            int size = this.size();
            if (other.length < size) {
                other = ObjectArrays.newArray(other, size);
            } else if (other.length > size) {
                other[size] = null;
            }
            System.arraycopy(this.array, 0, other, 0, size);
            return other;
        }

        @Override
        public E get(int index) {
            return (E)this.array[index];
        }

        @Override
        public int indexOf(Object target) {
            if (target != null) {
                for (int i = 0; i < this.size(); ++i) {
                    if (!this.array[i].equals(target)) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            if (target != null) {
                for (int i = this.size() - 1; i >= 0; --i) {
                    if (!this.array[i].equals(target)) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator(final int start) {
            Preconditions.checkArgument(start >= 0);
            Preconditions.checkArgument(start <= this.size());
            return new ListIterator<E>(){
                int index;
                {
                    this.index = start;
                }

                @Override
                public boolean hasNext() {
                    return this.index < RegularImmutableList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.index > 0;
                }

                @Override
                public int nextIndex() {
                    return this.index;
                }

                @Override
                public int previousIndex() {
                    return this.index - 1;
                }

                @Override
                public E next() {
                    Object result;
                    try {
                        result = RegularImmutableList.this.get(this.index);
                    }
                    catch (IndexOutOfBoundsException unused) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return result;
                }

                @Override
                public E previous() {
                    Object result;
                    try {
                        result = RegularImmutableList.this.get(this.index - 1);
                    }
                    catch (IndexOutOfBoundsException unused) {
                        throw new NoSuchElementException();
                    }
                    --this.index;
                    return result;
                }

                @Override
                public void set(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (that.size() != this.size()) {
                return false;
            }
            int index = 0;
            if (object instanceof RegularImmutableList) {
                RegularImmutableList other = (RegularImmutableList)object;
                for (Object element : other.array) {
                    if (this.array[index++].equals(element)) continue;
                    return false;
                }
            } else {
                for (Object element : that) {
                    if (this.array[index++].equals(element)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Object element : this.array) {
                hashCode = 31 * hashCode + element.hashCode();
            }
            return hashCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.size() * 16);
            sb.append('[').append(this.array[0]);
            for (int i = 1; i < this.size(); ++i) {
                sb.append(", ").append(this.array[i]);
            }
            return sb.append(']').toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyImmutableList
    extends ImmutableList<Object> {
        private EmptyImmutableList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public int indexOf(Object target) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            return -1;
        }

        @Override
        public ListIterator<Object> listIterator() {
            return Iterators.emptyListIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int start) {
            Preconditions.checkArgument(start == 0);
            return Iterators.emptyListIterator();
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof List && ((List)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_IMMUTABLE_LIST;
        }
    }
}

