/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterable;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterables {
    private static final Iterable<Object> EMPTY_ITERABLE = new Iterable<Object>(){

        @Override
        public Iterator<Object> iterator() {
            return Iterators.EMPTY_ITERATOR;
        }
    };

    private Iterables() {
    }

    public static <T> Iterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.unmodifiableIterator(iterable.iterator());
            }

            public String toString() {
                return iterable.toString();
            }
        };
    }

    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Iterators.size(iterable.iterator());
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return Iterators.elementsEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable, @Nullable T defaultValue) {
        return Iterators.getOnlyElement(iterable.iterator(), defaultValue);
    }

    public static <T> T[] newArray(Iterable<T> iterable, Class<T> type) {
        ArrayList<T> collection = iterable instanceof Collection ? (ArrayList<T>)iterable : Lists.newArrayList(iterable);
        T[] array = ObjectArrays.newArray(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> boolean addAll(Collection<T> collection, Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            Collection c = (Collection)iterable;
            return collection.addAll(c);
        }
        return Iterators.addAll(collection, iterable.iterator());
    }

    public static int frequency(Iterable<?> iterable, @Nullable Object element) {
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).count(element);
        }
        if (iterable instanceof Set) {
            return ((Set)iterable).contains(element) ? 1 : 0;
        }
        return Iterators.frequency(iterable.iterator(), element);
    }

    public static <T> Iterable<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.cycle(iterable);
            }

            public String toString() {
                return iterable.toString() + " (cycled)";
            }
        };
    }

    public static <T> Iterable<T> cycle(T ... elements) {
        return Iterables.cycle(Lists.newArrayList(elements));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> firstElements, Iterable<? extends T> nextElements) {
        Preconditions.checkNotNull(firstElements);
        Preconditions.checkNotNull(nextElements);
        return Iterables.concat(Arrays.asList(firstElements, nextElements));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        Preconditions.checkNotNull(iterables);
        Function function = new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> from) {
                return from.iterator();
            }
        };
        final Iterable<T> iterators = Iterables.transform(iterables, function);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(iterators.iterator());
            }
        };
    }

    public static <T> Iterable<Iterable<T>> partition(final Iterable<? extends T> iterable, final int partitionSize, final boolean padToSize) {
        Preconditions.checkNotNull(iterable);
        return new AbstractIterable<Iterable<T>>(){

            @Override
            public Iterator<Iterable<T>> iterator() {
                final Iterator iterator = Iterators.partition(iterable.iterator(), partitionSize, padToSize);
                return new AbstractIterator<Iterable<T>>(){
                    int howFarIn;

                    @Override
                    protected Iterable<T> computeNext() {
                        ++this.howFarIn;
                        if (!iterator.hasNext()) {
                            return (Iterable)this.endOfData();
                        }
                        return new AbstractIterable<T>(){
                            Iterator<T> innerIter;
                            boolean firstIteratorRequest;
                            {
                                this.innerIter = (Iterator)iterator.next();
                                this.firstIteratorRequest = true;
                            }

                            @Override
                            public Iterator<T> iterator() {
                                if (this.firstIteratorRequest) {
                                    this.firstIteratorRequest = false;
                                    return this.innerIter;
                                }
                                Iterator iterator = Iterators.partition(iterable.iterator(), partitionSize, padToSize);
                                for (int i = 0; i < howFarIn; ++i) {
                                    this.innerIter = iterator.next();
                                }
                                return this.innerIter;
                            }
                        };
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), predicate);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<?> unfiltered, final Class<T> type) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(type);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), type);
            }
        };
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.any(iterable.iterator(), predicate);
    }

    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Iterators.all(iterable.iterator(), predicate);
    }

    public static <E> E find(Iterable<E> iterable, Predicate<? super E> predicate) {
        return Iterators.find(iterable.iterator(), predicate);
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(fromIterable.iterator(), function);
            }
        };
    }

    public static <T> Iterable<T> reverse(final List<T> list) {
        Preconditions.checkNotNull(list);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator listIter = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIter.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIter.previous();
                    }

                    @Override
                    public void remove() {
                        listIter.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> rotate(final List<T> list, final int distance) {
        Preconditions.checkNotNull(list);
        if (distance == 0) {
            return list;
        }
        return new AbstractIterable<T>(){

            int calcActualDistance(int size) {
                int actualDistance = distance % size;
                if (actualDistance < 0) {
                    actualDistance += size;
                }
                return actualDistance;
            }

            @Override
            public Iterator<T> iterator() {
                int size = list.size();
                if (size <= 1) {
                    return list.iterator();
                }
                int actualDistance = this.calcActualDistance(size);
                if (actualDistance == 0) {
                    return list.iterator();
                }
                Iterable rotated = Iterables.concat(list.subList(actualDistance, size), list.subList(0, actualDistance));
                return rotated.iterator();
            }
        };
    }

    public static <T> Iterable<T> limit(final Iterable<T> iterable, final int limit) {
        Preconditions.checkNotNull(iterable);
        return new AbstractIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.limit(iterable.iterator(), limit);
            }
        };
    }

    public static <T> boolean isEmpty(Iterable<T> iterable) {
        return !iterable.iterator().hasNext();
    }

    public static <T> Iterable<T> skip(final Iterable<T> iterable, final int numberToSkip) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(numberToSkip >= 0, "number to skip cannot be negative");
        if (iterable instanceof List) {
            final List list = (List)iterable;
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return numberToSkip >= list.size() ? Iterators.emptyIterator() : list.subList(numberToSkip, list.size()).iterator();
                }
            };
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                Iterators.skip(iterator, numberToSkip);
                return new Iterator<T>(){
                    boolean atStart = true;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            Object e = iterator.next();
                            return e;
                        }
                        finally {
                            this.atStart = false;
                        }
                    }

                    @Override
                    public void remove() {
                        if (this.atStart) {
                            throw new IllegalStateException();
                        }
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)list.get(list.size() - 1);
        }
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            return (T)sortedSet.last();
        }
        return Iterators.getLast(iterable.iterator());
    }
}

