/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.binding.AutoValue_ResolvedBindings;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class ResolvedBindings
implements ContributionType.HasContributionType {
    public abstract Key key();

    abstract ImmutableSetMultimap<TypeElement, ContributionBinding> allContributionBindings();

    abstract ImmutableMap<TypeElement, MembersInjectionBinding> allMembersInjectionBindings();

    public abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    public abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    final ImmutableSetMultimap<TypeElement, ? extends Binding> allBindings() {
        return !this.allMembersInjectionBindings().isEmpty() ? this.allMembersInjectionBindings().asMultimap() : this.allContributionBindings();
    }

    public final ImmutableCollection<? extends Binding> bindings() {
        return this.allBindings().values();
    }

    public final Binding binding() {
        return (Binding)Iterables.getOnlyElement(this.bindings());
    }

    public final boolean isEmpty() {
        return this.allMembersInjectionBindings().isEmpty() && this.allContributionBindings().isEmpty() && this.multibindingDeclarations().isEmpty() && this.optionalBindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty();
    }

    public ImmutableSet<? extends Binding> bindingsOwnedBy(ComponentDescriptor component) {
        return this.allBindings().get((Object)component.typeElement());
    }

    public ImmutableSet<ContributionBinding> contributionBindings() {
        return ImmutableSet.copyOf((Collection)this.allContributionBindings().values());
    }

    final TypeElement owningComponent(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)this.contributionBindings().contains((Object)binding), (String)"binding is not resolved for %s: %s", (Object)this.key(), (Object)binding);
        return (TypeElement)Iterables.getOnlyElement((Iterable)this.allContributionBindings().inverse().get((Object)binding));
    }

    public final Optional<MembersInjectionBinding> membersInjectionBinding() {
        return this.allMembersInjectionBindings().isEmpty() ? Optional.empty() : Optional.of((MembersInjectionBinding)Iterables.getOnlyElement((Iterable)this.allMembersInjectionBindings().values()));
    }

    static ResolvedBindings forContributionBindings(Key key, Multimap<TypeElement, ContributionBinding> contributionBindings, Iterable<MultibindingDeclaration> multibindings, Iterable<SubcomponentDeclaration> subcomponentDeclarations, Iterable<OptionalBindingDeclaration> optionalBindingDeclarations) {
        return new AutoValue_ResolvedBindings(key, (ImmutableSetMultimap<TypeElement, ContributionBinding>)ImmutableSetMultimap.copyOf(contributionBindings), (ImmutableMap<TypeElement, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.copyOf(multibindings), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.copyOf(optionalBindingDeclarations));
    }

    static ResolvedBindings forMembersInjectionBinding(Key key, ComponentDescriptor owningComponent, MembersInjectionBinding ownedMembersInjectionBinding) {
        return new AutoValue_ResolvedBindings(key, (ImmutableSetMultimap<TypeElement, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<TypeElement, MembersInjectionBinding>)ImmutableMap.of((Object)owningComponent.typeElement(), (Object)ownedMembersInjectionBinding), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    static ResolvedBindings noBindings(Key key) {
        return new AutoValue_ResolvedBindings(key, (ImmutableSetMultimap<TypeElement, ContributionBinding>)ImmutableSetMultimap.of(), (ImmutableMap<TypeElement, MembersInjectionBinding>)ImmutableMap.of(), (ImmutableSet<MultibindingDeclaration>)ImmutableSet.of(), (ImmutableSet<SubcomponentDeclaration>)ImmutableSet.of(), (ImmutableSet<OptionalBindingDeclaration>)ImmutableSet.of());
    }

    public ContributionBinding contributionBinding() {
        return (ContributionBinding)Iterables.getOnlyElement(this.contributionBindings());
    }

    public final BindingType bindingType() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (String)"empty bindings for %s", (Object)this.key());
        if (!(!this.allBindings().isEmpty() || this.multibindingDeclarations().isEmpty() && this.subcomponentDeclarations().isEmpty())) {
            return BindingType.PROVISION;
        }
        ImmutableSet<BindingType> bindingTypes = this.bindingTypes();
        Preconditions.checkState((bindingTypes.size() == 1 ? 1 : 0) != 0, (String)"conflicting binding types: %s", this.bindings());
        return (BindingType)((Object)Iterables.getOnlyElement(bindingTypes));
    }

    ImmutableSet<BindingType> bindingTypes() {
        return (ImmutableSet)this.bindings().stream().map(Binding::bindingType).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public ContributionType contributionType() {
        return this.contributionBinding().contributionType();
    }

    public Optional<Scope> scope() {
        return this.binding().scope();
    }
}

