/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public final class InjectValidator {
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    InjectValidator(DaggerTypes types, DaggerElements elements, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this(types, elements, compilerOptions, dependencyRequestValidator, Optional.empty(), injectionAnnotations, metadataUtil);
    }

    private InjectValidator(DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions, DependencyRequestValidator dependencyRequestValidator, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    public InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? this : new InjectValidator(this.types, this.elements, this.compilerOptions, this.dependencyRequestValidator, Optional.of(Diagnostic.Kind.ERROR), this.injectionAnnotations, this.metadataUtil);
    }

    public ValidationReport<TypeElement> validateConstructor(ExecutableElement constructorElement) {
        ImmutableSet<Scope> scopes;
        ImmutableSet<ExecutableElement> injectConstructors;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(MoreElements.asType(constructorElement.getEnclosingElement()));
        if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addError("Dagger does not support injection into private constructors", constructorElement);
        }
        for (AnnotationMirror qualifier : this.injectionAnnotations.getQualifiers(constructorElement)) {
            builder.addError("@Qualifier annotations are not allowed on @Inject constructors", constructorElement, qualifier);
        }
        for (Scope scope : Scopes.scopesOf(constructorElement)) {
            builder.addError("@Scope annotations are not allowed on @Inject constructors; annotate the class instead", constructorElement, scope.scopeAnnotation());
        }
        for (VariableElement parameter : constructorElement.getParameters()) {
            this.validateDependencyRequest(builder, parameter);
        }
        if (this.throwsCheckedExceptions(constructorElement)) {
            builder.addItem("Dagger does not support checked exceptions on @Inject constructors", this.privateMemberDiagnosticKind(), constructorElement);
        }
        this.checkInjectIntoPrivateClass(constructorElement, builder);
        TypeElement enclosingElement = MoreElements.asType(constructorElement.getEnclosingElement());
        Set<Modifier> typeModifiers = enclosingElement.getModifiers();
        if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("@Inject is nonsense on the constructor of an abstract class", constructorElement);
        }
        if (enclosingElement.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
            builder.addError("@Inject constructors are invalid on inner classes. Did you mean to make the class static?", constructorElement);
        }
        if ((injectConstructors = InjectionAnnotations.injectedConstructors(enclosingElement)).size() > 1) {
            builder.addError("Types may only contain one @Inject constructor", constructorElement);
        }
        if ((scopes = Scopes.scopesOf(enclosingElement)).size() > 1) {
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", enclosingElement, scope.scopeAnnotation());
            }
        }
        return builder.build();
    }

    private ValidationReport<VariableElement> validateField(VariableElement fieldElement) {
        ValidationReport.Builder<VariableElement> builder = ValidationReport.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind(), fieldElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind(), fieldElement);
        }
        this.validateDependencyRequest(builder, fieldElement);
        return builder.build();
    }

    private ValidationReport<ExecutableElement> validateMethod(ExecutableElement methodElement) {
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Methods with @Inject may not be abstract", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind(), methodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind(), methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addError("Methods with @Inject may not declare type parameters", methodElement);
        }
        if (!methodElement.getThrownTypes().isEmpty()) {
            builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            this.validateDependencyRequest(builder, variableElement);
        }
        return builder.build();
    }

    private void validateDependencyRequest(ValidationReport.Builder<?> builder, VariableElement parameter) {
        this.dependencyRequestValidator.validateDependencyRequest(builder, parameter, parameter.asType());
        this.dependencyRequestValidator.checkNotProducer(builder, parameter);
    }

    public ValidationReport<TypeElement> validateMembersInjectionType(TypeElement typeElement) {
        ValidationReport<TypeElement> validationReport;
        TypeMirror superclass;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        boolean hasInjectedMembers = false;
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(variableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<VariableElement> report2 = this.validateField(variableElement);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(executableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<ExecutableElement> report = this.validateMethod(executableElement);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass(typeElement, builder);
            this.checkInjectIntoKotlinObject(typeElement, builder);
        }
        if (!(superclass = typeElement.getSuperclass()).getKind().equals((Object)TypeKind.NONE) && !(validationReport = this.validateType(MoreTypes.asTypeElement(superclass))).isClean()) {
            builder.addSubreport(validationReport);
        }
        return builder.build();
    }

    public ValidationReport<TypeElement> validateType(TypeElement typeElement) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        ValidationReport<TypeElement> membersInjectionReport = this.validateMembersInjectionType(typeElement);
        if (!membersInjectionReport.isClean()) {
            builder.addSubreport(membersInjectionReport);
        }
        for (ExecutableElement element : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            ValidationReport<TypeElement> report;
            if (!MoreElements.isAnnotationPresent(element, Inject.class) || (report = this.validateConstructor(element)).isClean()) continue;
            builder.addSubreport(report);
        }
        return builder.build();
    }

    public boolean isValidType(TypeMirror type) {
        if (!type.getKind().equals((Object)TypeKind.DECLARED)) {
            return true;
        }
        return this.validateType(MoreTypes.asTypeElement(type)).isClean();
    }

    private boolean throwsCheckedExceptions(ExecutableElement methodElement) {
        TypeMirror runtimeExceptionType = this.elements.getTypeElement(RuntimeException.class).asType();
        TypeMirror errorType = this.elements.getTypeElement(Error.class).asType();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            if (this.types.isSubtype(typeMirror, runtimeExceptionType) || this.types.isSubtype(typeMirror, errorType)) continue;
            return true;
        }
        return false;
    }

    private void checkInjectIntoPrivateClass(Element element, ValidationReport.Builder<TypeElement> builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage(DaggerElements.closestEnclosingTypeElement(element))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind(), element);
        }
    }

    private void checkInjectIntoKotlinObject(TypeElement element, ValidationReport.Builder<TypeElement> builder) {
        if (this.metadataUtil.isObjectClass(element) || this.metadataUtil.isCompanionObjectClass(element)) {
            builder.addError("Dagger does not support injection into Kotlin objects", element);
        }
    }

    private Diagnostic.Kind privateMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind());
    }

    private Diagnostic.Kind staticMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind());
    }
}

