/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.SetBuilder;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.SimpleInvocationBindingExpression;
import dagger.model.DependencyRequest;
import java.util.Collections;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class SetBindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final BindingGraph graph;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final DaggerElements elements;

    SetBindingExpression(ProvisionBinding binding, BindingGraph graph, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, DaggerElements elements) {
        super(binding);
        this.binding = binding;
        this.graph = graph;
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
        this.elements = elements;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        boolean isImmutableSetAvailable = this.isImmutableSetAvailable();
        if (isImmutableSetAvailable && this.binding.dependencies().stream().allMatch(this::isSingleValue)) {
            return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("of($L)", new Object[]{this.binding.dependencies().stream().map(dependency -> this.getContributionExpression((DependencyRequest)dependency, requestingClass)).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.binding.dependencies().size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"emptySet()", (Object[])new Object[0]));
            }
            case 1: {
                DependencyRequest dependency2 = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
                CodeBlock contributionExpression = this.getContributionExpression(dependency2, requestingClass);
                if (this.isSingleValue(dependency2)) {
                    return this.collectionsStaticFactoryInvocation(requestingClass, CodeBlock.of((String)"singleton($L)", (Object[])new Object[]{contributionExpression}));
                }
                if (!isImmutableSetAvailable) break;
                return Expression.create(this.immutableSetType(), CodeBlock.builder().add("$T.", new Object[]{ImmutableSet.class}).add(this.maybeTypeParameter(requestingClass)).add("copyOf($L)", new Object[]{contributionExpression}).build());
            }
        }
        CodeBlock.Builder instantiation = CodeBlock.builder();
        instantiation.add("$T.", new Object[]{isImmutableSetAvailable ? ImmutableSet.class : SetBuilder.class}).add(this.maybeTypeParameter(requestingClass));
        if (this.isImmutableSetBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize($L)", new Object[]{this.binding.dependencies().size()});
        } else if (isImmutableSetAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newSetBuilder($L)", new Object[]{this.binding.dependencies().size()});
        }
        for (DependencyRequest dependency3 : this.binding.dependencies()) {
            String builderMethod = this.isSingleValue(dependency3) ? "add" : "addAll";
            instantiation.add(".$L($L)", new Object[]{builderMethod, this.getContributionExpression(dependency3, requestingClass)});
        }
        instantiation.add(".build()", new Object[0]);
        return Expression.create(isImmutableSetAvailable ? this.immutableSetType() : this.binding.key().type(), instantiation.build());
    }

    private DeclaredType immutableSetType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(ImmutableSet.class), SetType.from(this.binding.key()).elementType());
    }

    private CodeBlock getContributionExpression(DependencyRequest dependency, ClassName requestingClass) {
        return this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock();
    }

    private Expression collectionsStaticFactoryInvocation(ClassName requestingClass, CodeBlock methodInvocation) {
        return Expression.create(this.binding.key().type(), CodeBlock.builder().add("$T.", new Object[]{Collections.class}).add(this.maybeTypeParameter(requestingClass)).add(methodInvocation).build());
    }

    private CodeBlock maybeTypeParameter(ClassName requestingClass) {
        TypeMirror elementType = SetType.from(this.binding.key()).elementType();
        return Accessibility.isTypeAccessibleFrom(elementType, requestingClass.packageName()) ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{elementType}) : CodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isSingleValue(DependencyRequest dependency) {
        return ((ResolvedBindings)this.graph.contributionBindings().get((Object)dependency.key())).contributionBinding().contributionType().equals((Object)ContributionType.SET);
    }

    private boolean isImmutableSetBuilderWithExpectedSizeAvailable() {
        if (this.isImmutableSetAvailable()) {
            return ElementFilter.methodsIn(this.elements.getTypeElement(ImmutableSet.class).getEnclosedElements()).stream().anyMatch(method -> method.getSimpleName().contentEquals("builderWithExpectedSize"));
        }
        return false;
    }

    private boolean isImmutableSetAvailable() {
        return this.elements.getTypeElement(ImmutableSet.class) != null;
    }
}

