/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class SetMultibindingValidator
implements BindingGraphPlugin {
    @Inject
    SetMultibindingValidator() {
    }

    public String pluginName() {
        return "Dagger/SetMultibinding";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.MULTIBOUND_SET)).forEach(binding -> this.checkForDuplicateSetContributions((Binding)binding, bindingGraph, diagnosticReporter));
    }

    private void checkForDuplicateSetContributions(Binding binding, BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        HashMultimap dereferencedBindsTargets = HashMultimap.create();
        for (Binding dep : bindingGraph.requestedBindings(binding)) {
            if (!dep.kind().equals((Object)BindingKind.DELEGATE)) continue;
            dereferencedBindsTargets.put((Object)this.dereferenceDelegateBinding(dep, bindingGraph), (Object)dep);
        }
        dereferencedBindsTargets.asMap().forEach((targetKey, contributions) -> {
            if (contributions.size() > 1) {
                diagnosticReporter.reportComponent(Diagnostic.Kind.ERROR, (BindingGraph.ComponentNode)bindingGraph.componentNode(binding.componentPath()).get(), "Multiple set contributions into %s for the same contribution key: %s.\n\n    %s\n", (Object)binding.key(), new Object[]{targetKey, Joiner.on((String)"\n    ").join((Iterable)contributions)});
            }
        });
    }

    private Key dereferenceDelegateBinding(Binding binding, BindingGraph bindingGraph) {
        ImmutableSet delegateSet = bindingGraph.requestedBindings(binding);
        if (delegateSet.isEmpty()) {
            return ((DependencyRequest)Iterables.getOnlyElement((Iterable)binding.dependencies())).key();
        }
        Binding delegate = (Binding)Iterables.getOnlyElement((Iterable)delegateSet);
        if (delegate.kind().equals((Object)BindingKind.DELEGATE)) {
            return this.dereferenceDelegateBinding(delegate, bindingGraph);
        }
        return delegate.key();
    }
}

