/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.ComponentImplementation;

final class DerivedFromFrameworkInstanceBindingExpression
extends BindingExpression {
    private final BindingRequest bindingRequest;
    private final BindingRequest frameworkRequest;
    private final FrameworkType frameworkType;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;

    @AssistedInject
    DerivedFromFrameworkInstanceBindingExpression(@Assisted BindingRequest bindingRequest, @Assisted FrameworkType frameworkType, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types) {
        this.bindingRequest = (BindingRequest)Preconditions.checkNotNull((Object)bindingRequest);
        this.frameworkType = (FrameworkType)((Object)Preconditions.checkNotNull((Object)((Object)frameworkType)));
        this.frameworkRequest = BindingRequest.bindingRequest(bindingRequest.key(), frameworkType);
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return this.frameworkType.to(this.bindingRequest.requestKind(), this.componentBindingExpressions.getDependencyExpression(this.frameworkRequest, requestingClass), this.types);
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        Expression frameworkInstance = this.componentBindingExpressions.getDependencyExpressionForComponentMethod(this.frameworkRequest, componentMethod, component);
        return this.frameworkType.to(this.bindingRequest.requestKind(), frameworkInstance, this.types);
    }

    @AssistedFactory
    static interface Factory {
        public DerivedFromFrameworkInstanceBindingExpression create(BindingRequest var1, FrameworkType var2);
    }
}

