/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.binding.AutoValue_BindingNode;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.spi.model.BindingKind;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Key;
import dagger.spi.model.Scope;
import java.util.Optional;

@AutoValue
public abstract class BindingNode
implements dagger.spi.model.Binding {
    private BindingDeclarationFormatter bindingDeclarationFormatter;

    public static BindingNode create(ComponentPath component, Binding delegate, ImmutableSet<MultibindingDeclaration> multibindingDeclarations, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations, ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations, BindingDeclarationFormatter bindingDeclarationFormatter) {
        AutoValue_BindingNode node = new AutoValue_BindingNode(component, delegate, multibindingDeclarations, optionalBindingDeclarations, subcomponentDeclarations);
        node.bindingDeclarationFormatter = (BindingDeclarationFormatter)Preconditions.checkNotNull((Object)bindingDeclarationFormatter);
        return node;
    }

    public abstract Binding delegate();

    public abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    public abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    public abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    public final Iterable<BindingDeclaration> associatedDeclarations() {
        return Iterables.concat(this.multibindingDeclarations(), this.optionalBindingDeclarations(), this.subcomponentDeclarations());
    }

    public Key key() {
        return this.delegate().key();
    }

    public ImmutableSet<DependencyRequest> dependencies() {
        return this.delegate().dependencies();
    }

    public Optional<DaggerElement> bindingElement() {
        return this.delegate().bindingElement().map(DaggerElement::from);
    }

    public Optional<DaggerTypeElement> contributingModule() {
        return this.delegate().contributingModule().map(DaggerTypeElement::from);
    }

    public boolean requiresModuleInstance() {
        return this.delegate().requiresModuleInstance();
    }

    public Optional<Scope> scope() {
        return this.delegate().scope();
    }

    public boolean isNullable() {
        return this.delegate().isNullable();
    }

    public boolean isProduction() {
        return this.delegate().bindingType().equals((Object)BindingType.PRODUCTION);
    }

    public BindingKind kind() {
        return this.delegate().kind();
    }

    public final String toString() {
        return this.bindingDeclarationFormatter.format(this.delegate());
    }
}

