/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

abstract class FrameworkInstanceRequestRepresentation
extends RequestRepresentation {
    private final ContributionBinding binding;
    private final FrameworkInstanceSupplier frameworkInstanceSupplier;
    private final XProcessingEnv processingEnv;

    FrameworkInstanceRequestRepresentation(ContributionBinding binding, FrameworkInstanceSupplier frameworkInstanceSupplier, XProcessingEnv processingEnv) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.frameworkInstanceSupplier = (FrameworkInstanceSupplier)Preconditions.checkNotNull((Object)frameworkInstanceSupplier);
        this.processingEnv = (XProcessingEnv)Preconditions.checkNotNull((Object)processingEnv);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        MemberSelect memberSelect = this.frameworkInstanceSupplier.memberSelect();
        XType expressionType = Accessibility.isTypeAccessibleFrom(this.binding.contributedType(), requestingClass.packageName()) || FrameworkInstanceRequestRepresentation.isInlinedFactoryCreation(memberSelect) ? XProcessingEnvs.wrapType((ClassName)this.frameworkType().frameworkClassName(), (XType)this.binding.contributedType(), (XProcessingEnv)this.processingEnv) : this.rawFrameworkType();
        return Expression.create(expressionType, memberSelect.getExpressionFor(requestingClass));
    }

    protected abstract FrameworkType frameworkType();

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }

    private XType rawFrameworkType() {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((TypeName)this.frameworkType().frameworkClassName()), new XType[0]);
    }
}

