/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

final class DelegateRequestRepresentation
extends RequestRepresentation {
    private final ContributionBinding binding;
    private final RequestKind requestKind;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final XProcessingEnv processingEnv;
    private final BindsTypeChecker bindsTypeChecker;

    @AssistedInject
    DelegateRequestRepresentation(@Assisted ContributionBinding binding, @Assisted RequestKind requestKind, ComponentRequestRepresentations componentRequestRepresentations, BindsTypeChecker bindsTypeChecker, XProcessingEnv processingEnv) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.requestKind = (RequestKind)Preconditions.checkNotNull((Object)requestKind);
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
    }

    static boolean isBindsScopeStrongerThanDependencyScope(ContributionBinding bindsBinding, BindingGraph graph) {
        Preconditions.checkArgument((boolean)bindsBinding.kind().equals((Object)BindingKind.DELEGATE));
        ContributionBinding dependencyBinding = graph.contributionBinding(((DependencyRequest)Iterables.getOnlyElement(bindsBinding.dependencies())).key());
        ScopeKind bindsScope = ScopeKind.get(bindsBinding);
        ScopeKind dependencyScope = ScopeKind.get(dependencyBinding);
        return bindsScope.isStrongerScopeThan(dependencyScope);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression delegateExpression = this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(((DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies())).key(), this.requestKind), requestingClass);
        XType contributedType = this.binding.contributedType();
        switch (this.requestKind) {
            case INSTANCE: {
                return DelegateRequestRepresentation.instanceRequiresCast(this.binding, delegateExpression, requestingClass, this.bindsTypeChecker) ? delegateExpression.castTo(contributedType) : delegateExpression;
            }
        }
        return this.castToRawTypeIfNecessary(delegateExpression, RequestKinds.requestType(this.requestKind, contributedType, this.processingEnv));
    }

    static boolean instanceRequiresCast(ContributionBinding binding, Expression delegateExpression, ClassName requestingClass, BindsTypeChecker bindsTypeChecker) {
        XType contributedType = binding.contributedType();
        return !bindsTypeChecker.isAssignable(delegateExpression.type(), contributedType, binding.contributionType()) && Accessibility.isTypeAccessibleFrom(contributedType, requestingClass.packageName());
    }

    private Expression castToRawTypeIfNecessary(Expression delegateExpression, XType desiredType) {
        if (delegateExpression.type().isAssignableTo(desiredType)) {
            return delegateExpression;
        }
        Expression castedExpression = delegateExpression.castTo(desiredType.getRawType());
        return Expression.create(castedExpression.type(), CodeBlock.of((String)"($L)", (Object[])new Object[]{castedExpression.codeBlock()}));
    }

    @AssistedFactory
    static interface Factory {
        public DelegateRequestRepresentation create(ContributionBinding var1, RequestKind var2);
    }

    private static enum ScopeKind {
        UNSCOPED,
        SINGLE_CHECK,
        DOUBLE_CHECK;


        static ScopeKind get(Binding binding) {
            return binding.scope().map(scope -> scope.isReusable() ? SINGLE_CHECK : DOUBLE_CHECK).orElse(UNSCOPED);
        }

        boolean isStrongerScopeThan(ScopeKind other) {
            return this.ordinal() > other.ordinal();
        }
    }
}

